/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.client.gui.armourer.tab;

import cpw.mods.fml.client.config.GuiSlider;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import riskyken.armourersWorkshop.client.gui.GuiHelper;
import riskyken.armourersWorkshop.client.gui.armourer.GuiArmourer;
import riskyken.armourersWorkshop.client.gui.controls.GuiCheckBox;
import riskyken.armourersWorkshop.client.gui.controls.GuiCustomSlider;
import riskyken.armourersWorkshop.client.gui.controls.GuiDropDownList;
import riskyken.armourersWorkshop.client.gui.controls.GuiInventorySize;
import riskyken.armourersWorkshop.client.gui.controls.GuiTabPanel;
import riskyken.armourersWorkshop.client.lib.LibGuiResources;
import riskyken.armourersWorkshop.common.network.PacketHandler;
import riskyken.armourersWorkshop.common.network.messages.client.MessageClientGuiSetArmourerSkinProps;
import riskyken.armourersWorkshop.common.skin.data.SkinProperties;
import riskyken.armourersWorkshop.common.skin.type.SkinTypeRegistry;
import riskyken.armourersWorkshop.common.skin.type.wings.SkinWings;
import riskyken.armourersWorkshop.common.tileentities.TileEntityArmourer;
import riskyken.armourersWorkshop.utils.ModLogger;

@SideOnly(value=Side.CLIENT)
public class GuiTabArmourerSkinSettings
extends GuiTabPanel
implements GuiSlider.ISlider,
GuiDropDownList.IDropDownListCallback {
    private static final ResourceLocation TEXTURE = new ResourceLocation(LibGuiResources.ARMOURER);
    private static final String DEGREE = "\u00b0";
    private final TileEntityArmourer tileEntity;
    private GuiCheckBox checkBlockGlowing;
    private GuiCheckBox checkBlockLadder;
    private GuiCheckBox checkBlockNoCollision;
    private GuiCheckBox checkBlockSeat;
    private GuiCheckBox checkBlockMultiblock;
    private GuiCheckBox checkBlockBed;
    private GuiCheckBox checkBlockInventory;
    private GuiInventorySize inventorySize;
    private GuiCheckBox checkBlockEnderInventory;
    private GuiCustomSlider sliderWingIdleSpeed;
    private GuiCustomSlider sliderWingFlyingSpeed;
    private GuiCustomSlider sliderWingMinAngle;
    private GuiCustomSlider sliderWingMaxAngle;
    private GuiCheckBox checkArmourOverrideBodyPart;
    private GuiCheckBox checkArmourHideOverlay;
    private GuiDropDownList dropDownList;
    private boolean resetting;

    public GuiTabArmourerSkinSettings(int tabId, GuiScreen parent) {
        super(tabId, parent, false);
        this.tileEntity = ((GuiArmourer)parent).tileEntity;
    }

    @Override
    public void initGui(int xPos, int yPos, int width, int height) {
        super.initGui(xPos, yPos, width, height);
        String guiName = this.tileEntity.getInventoryName();
        this.buttonList.clear();
        SkinProperties skinProps = this.tileEntity.getSkinProps();
        this.checkBlockGlowing = new GuiCheckBox(15, 10, 20, GuiHelper.getLocalizedControlName(guiName, "glowing"), SkinProperties.PROP_BLOCK_GLOWING.getValue(skinProps));
        this.checkBlockLadder = new GuiCheckBox(15, 10, 35, GuiHelper.getLocalizedControlName(guiName, "ladder"), SkinProperties.PROP_BLOCK_LADDER.getValue(skinProps));
        this.checkBlockNoCollision = new GuiCheckBox(15, 10, 50, GuiHelper.getLocalizedControlName(guiName, "noCollision"), SkinProperties.PROP_BLOCK_NO_COLLISION.getValue(skinProps));
        this.checkBlockSeat = new GuiCheckBox(15, 10, 65, GuiHelper.getLocalizedControlName(guiName, "seat"), SkinProperties.PROP_BLOCK_SEAT.getValue(skinProps));
        this.checkBlockMultiblock = new GuiCheckBox(15, 10, 80, GuiHelper.getLocalizedControlName(guiName, "multiblock"), SkinProperties.PROP_BLOCK_MULTIBLOCK.getValue(skinProps));
        this.checkBlockBed = new GuiCheckBox(15, 22, 95, GuiHelper.getLocalizedControlName(guiName, "bed"), SkinProperties.PROP_BLOCK_BED.getValue(skinProps));
        this.checkBlockEnderInventory = new GuiCheckBox(15, 10, 110, GuiHelper.getLocalizedControlName(guiName, "enderInventory"), SkinProperties.PROP_BLOCK_ENDER_INVENTORY.getValue(skinProps));
        this.checkBlockInventory = new GuiCheckBox(15, 10, 125, GuiHelper.getLocalizedControlName(guiName, "inventory"), SkinProperties.PROP_BLOCK_INVENTORY.getValue(skinProps));
        if (!this.checkBlockMultiblock.isChecked()) {
            this.checkBlockBed.enabled = false;
            this.checkBlockBed.setIsChecked(false);
        } else {
            this.checkBlockBed.enabled = true;
        }
        this.checkBlockBed.enabled = false;
        this.checkBlockEnderInventory.enabled = !this.checkBlockInventory.isChecked();
        boolean bl = this.checkBlockInventory.enabled = !this.checkBlockEnderInventory.isChecked();
        if (this.checkBlockInventory.isChecked()) {
            this.checkBlockEnderInventory.setIsChecked(false);
        }
        if (this.checkBlockEnderInventory.isChecked()) {
            this.checkBlockInventory.setIsChecked(false);
        }
        this.inventorySize = new GuiInventorySize(10, 158, 9, 6);
        this.inventorySize.setSrc(TEXTURE, 176, 0);
        this.inventorySize.setSelection(SkinProperties.PROP_BLOCK_INVENTORY_WIDTH.getValue(skinProps), SkinProperties.PROP_BLOCK_INVENTORY_HEIGHT.getValue(skinProps));
        this.sliderWingIdleSpeed = new GuiCustomSlider(15, 10, 45, 154, 10, "", "ms", 200.0, 10000.0, SkinProperties.PROP_WINGS_IDLE_SPEED.getValue(skinProps), false, true, this);
        this.sliderWingFlyingSpeed = new GuiCustomSlider(15, 10, 65, 154, 10, "", "ms", 200.0, 10000.0, SkinProperties.PROP_WINGS_FLYING_SPEED.getValue(skinProps), false, true, this);
        this.sliderWingMinAngle = new GuiCustomSlider(15, 10, 85, 154, 10, "", DEGREE, -180.0, 180.0, SkinProperties.PROP_WINGS_MIN_ANGLE.getValue(skinProps), false, true, this);
        this.sliderWingMaxAngle = new GuiCustomSlider(15, 10, 105, 154, 10, "", DEGREE, -180.0, 180.0, SkinProperties.PROP_WINGS_MAX_ANGLE.getValue(skinProps), false, true, this);
        this.sliderWingIdleSpeed.setFineTuneButtons(true);
        this.sliderWingFlyingSpeed.setFineTuneButtons(true);
        this.sliderWingMinAngle.setFineTuneButtons(true);
        this.sliderWingMaxAngle.setFineTuneButtons(true);
        this.checkArmourOverrideBodyPart = new GuiCheckBox(15, 10, 20, GuiHelper.getLocalizedControlName(guiName, "overrideBodyPart"), SkinProperties.PROP_ARMOUR_OVERRIDE.getValue(skinProps));
        this.checkArmourHideOverlay = new GuiCheckBox(15, 10, 35, GuiHelper.getLocalizedControlName(guiName, "hideOverlay"), SkinProperties.PROP_ARMOUR_HIDE_OVERLAY.getValue(skinProps));
        SkinWings.MovementType skinMovmentType = SkinWings.MovementType.valueOf(SkinProperties.PROP_WINGS_MOVMENT_TYPE.getValue(skinProps));
        this.dropDownList = new GuiDropDownList(0, 10, 125, 50, "", this);
        for (int i = 0; i < SkinWings.MovementType.values().length; ++i) {
            SkinWings.MovementType movementType = SkinWings.MovementType.values()[i];
            String unlocalizedName = "movmentType." + "armourersWorkshop".toLowerCase() + ":" + movementType.name().toLowerCase();
            String localizedName = StatCollector.translateToLocal((String)unlocalizedName);
            this.dropDownList.addListItem(localizedName, movementType.name(), true);
            if (movementType != skinMovmentType) continue;
            this.dropDownList.setListSelectedIndex(i);
        }
        this.buttonList.add(this.checkBlockGlowing);
        this.buttonList.add(this.checkBlockLadder);
        this.buttonList.add(this.checkBlockNoCollision);
        this.buttonList.add(this.checkBlockSeat);
        this.buttonList.add(this.checkBlockMultiblock);
        this.buttonList.add(this.checkBlockBed);
        this.buttonList.add(this.checkBlockInventory);
        this.buttonList.add(this.checkBlockEnderInventory);
        this.buttonList.add(this.inventorySize);
        this.buttonList.add(this.sliderWingIdleSpeed);
        this.buttonList.add(this.sliderWingFlyingSpeed);
        this.buttonList.add(this.sliderWingMinAngle);
        this.buttonList.add(this.sliderWingMaxAngle);
        this.buttonList.add(this.checkArmourOverrideBodyPart);
        this.buttonList.add(this.checkArmourHideOverlay);
        this.buttonList.add(this.dropDownList);
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        SkinProperties skinProps = this.tileEntity.getSkinProps();
        if (!this.checkBlockMultiblock.isChecked()) {
            this.checkBlockBed.enabled = false;
            this.checkBlockBed.setIsChecked(false);
        } else {
            this.checkBlockBed.enabled = true;
        }
        this.checkBlockEnderInventory.enabled = !this.checkBlockInventory.isChecked();
        boolean bl = this.checkBlockInventory.enabled = !this.checkBlockEnderInventory.isChecked();
        if (this.checkBlockInventory.isChecked()) {
            this.checkBlockEnderInventory.setIsChecked(false);
        }
        if (this.checkBlockEnderInventory.isChecked()) {
            this.checkBlockInventory.setIsChecked(false);
        }
        this.checkBlockBed.enabled = false;
        if (button == this.checkBlockGlowing | button == this.checkBlockLadder | button == this.checkBlockNoCollision | button == this.checkBlockSeat | button == this.checkBlockMultiblock | button == this.checkBlockBed | button == this.checkBlockInventory | button == this.inventorySize | button == this.checkBlockEnderInventory) {
            SkinProperties.PROP_BLOCK_GLOWING.setValue(skinProps, this.checkBlockGlowing.isChecked());
            SkinProperties.PROP_BLOCK_LADDER.setValue(skinProps, this.checkBlockLadder.isChecked());
            SkinProperties.PROP_BLOCK_NO_COLLISION.setValue(skinProps, this.checkBlockNoCollision.isChecked());
            SkinProperties.PROP_BLOCK_SEAT.setValue(skinProps, this.checkBlockSeat.isChecked());
            SkinProperties.PROP_BLOCK_MULTIBLOCK.setValue(skinProps, this.checkBlockMultiblock.isChecked());
            SkinProperties.PROP_BLOCK_BED.setValue(skinProps, this.checkBlockBed.isChecked());
            SkinProperties.PROP_BLOCK_INVENTORY.setValue(skinProps, this.checkBlockInventory.isChecked());
            SkinProperties.PROP_BLOCK_ENDER_INVENTORY.setValue(skinProps, this.checkBlockEnderInventory.isChecked());
            SkinProperties.PROP_BLOCK_INVENTORY_WIDTH.setValue(skinProps, this.inventorySize.getSelectionWidth());
            SkinProperties.PROP_BLOCK_INVENTORY_HEIGHT.setValue(skinProps, this.inventorySize.getSelectionHeight());
            PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientGuiSetArmourerSkinProps(skinProps));
        }
        if (button == this.checkArmourOverrideBodyPart | button == this.checkArmourHideOverlay) {
            SkinProperties.PROP_ARMOUR_OVERRIDE.setValue(skinProps, this.checkArmourOverrideBodyPart.isChecked());
            SkinProperties.PROP_ARMOUR_HIDE_OVERLAY.setValue(skinProps, this.checkArmourHideOverlay.isChecked());
            PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientGuiSetArmourerSkinProps(skinProps));
        }
        this.inventorySize.visible = this.checkBlockInventory.isChecked();
    }

    public void resetValues(SkinProperties skinProperties) {
        this.resetting = true;
        this.checkBlockGlowing.setIsChecked(SkinProperties.PROP_BLOCK_GLOWING.getValue(skinProperties));
        this.checkBlockLadder.setIsChecked(SkinProperties.PROP_BLOCK_LADDER.getValue(skinProperties));
        this.checkBlockNoCollision.setIsChecked(SkinProperties.PROP_BLOCK_NO_COLLISION.getValue(skinProperties));
        this.checkBlockSeat.setIsChecked(SkinProperties.PROP_BLOCK_SEAT.getValue(skinProperties));
        this.checkBlockMultiblock.setIsChecked(SkinProperties.PROP_BLOCK_MULTIBLOCK.getValue(skinProperties));
        this.checkBlockBed.setIsChecked(SkinProperties.PROP_BLOCK_BED.getValue(skinProperties));
        this.checkBlockInventory.setIsChecked(SkinProperties.PROP_BLOCK_INVENTORY.getValue(skinProperties));
        this.checkBlockEnderInventory.setIsChecked(SkinProperties.PROP_BLOCK_ENDER_INVENTORY.getValue(skinProperties));
        this.inventorySize.setSelection(SkinProperties.PROP_BLOCK_INVENTORY_WIDTH.getValue(skinProperties), SkinProperties.PROP_BLOCK_INVENTORY_HEIGHT.getValue(skinProperties));
        this.inventorySize.visible = this.checkBlockInventory.isChecked();
        this.sliderWingMinAngle.setValue(SkinProperties.PROP_WINGS_MIN_ANGLE.getValue(skinProperties));
        this.sliderWingMinAngle.updateSlider();
        this.sliderWingMaxAngle.setValue(SkinProperties.PROP_WINGS_MAX_ANGLE.getValue(skinProperties));
        this.sliderWingMaxAngle.updateSlider();
        this.sliderWingIdleSpeed.setValue(SkinProperties.PROP_WINGS_IDLE_SPEED.getValue(skinProperties));
        this.sliderWingIdleSpeed.updateSlider();
        this.sliderWingFlyingSpeed.setValue(SkinProperties.PROP_WINGS_FLYING_SPEED.getValue(skinProperties));
        this.sliderWingFlyingSpeed.updateSlider();
        this.checkArmourOverrideBodyPart.setIsChecked(SkinProperties.PROP_ARMOUR_OVERRIDE.getValue(skinProperties));
        this.checkArmourHideOverlay.setIsChecked(SkinProperties.PROP_ARMOUR_HIDE_OVERLAY.getValue(skinProperties));
        SkinWings.MovementType skinMovmentType = SkinWings.MovementType.valueOf(SkinProperties.PROP_WINGS_MOVMENT_TYPE.getValue(skinProperties));
        for (int i = 0; i < SkinWings.MovementType.values().length; ++i) {
            SkinWings.MovementType movementType = SkinWings.MovementType.values()[i];
            if (movementType != skinMovmentType) continue;
            this.dropDownList.setListSelectedIndex(i);
        }
        this.resetting = false;
    }

    @Override
    public void drawBackgroundLayer(float partialTickTime, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.x, this.y, 0, 0, this.width, this.height);
        this.func_73729_b(this.x + 7, this.y + 141, 7, 3, 162, 76);
        this.checkBlockGlowing.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinBlock;
        this.checkBlockLadder.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinBlock;
        this.checkBlockNoCollision.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinBlock;
        this.checkBlockSeat.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinBlock;
        this.checkBlockMultiblock.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinBlock;
        this.checkBlockBed.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinBlock;
        this.checkBlockInventory.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinBlock;
        this.checkBlockEnderInventory.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinBlock;
        this.inventorySize.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinBlock & this.checkBlockInventory.isChecked();
        this.sliderWingIdleSpeed.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinWings;
        this.sliderWingFlyingSpeed.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinWings;
        this.sliderWingMinAngle.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinWings;
        this.sliderWingMaxAngle.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinWings;
        this.dropDownList.visible = this.tileEntity.getSkinType() == SkinTypeRegistry.skinWings;
        this.checkArmourOverrideBodyPart.visible = this.tileEntity.getSkinType().getVanillaArmourSlotId() != -1;
        this.checkArmourHideOverlay.visible = this.tileEntity.getSkinType().getVanillaArmourSlotId() != -1;
    }

    @Override
    public void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.tileEntity.getSkinType() == SkinTypeRegistry.skinWings) {
            String idleSpeedLabel = GuiHelper.getLocalizedControlName(this.tileEntity.getInventoryName(), "label.idleSpeed");
            String flyingSpeedLabel = GuiHelper.getLocalizedControlName(this.tileEntity.getInventoryName(), "label.flyingSpeed");
            String minAngleLabel = GuiHelper.getLocalizedControlName(this.tileEntity.getInventoryName(), "label.minAngle");
            String maxAngleLabel = GuiHelper.getLocalizedControlName(this.tileEntity.getInventoryName(), "label.maxAngle");
            this.fontRenderer.func_78276_b(idleSpeedLabel, 10, 36, 0x404040);
            this.fontRenderer.func_78276_b(flyingSpeedLabel, 10, 56, 0x404040);
            this.fontRenderer.func_78276_b(minAngleLabel, 10, 76, 0x404040);
            this.fontRenderer.func_78276_b(maxAngleLabel, 10, 96, 0x404040);
        }
        if (this.tileEntity.getSkinType() == SkinTypeRegistry.skinBlock & this.checkBlockInventory.isChecked()) {
            String labelInventorySize = GuiHelper.getLocalizedControlName(this.tileEntity.getInventoryName(), "label.inventorySize");
            String labelInventorySlots = "inventory." + "armourersWorkshop".toLowerCase() + ":" + this.tileEntity.getInventoryName() + ".label.inventorySlots";
            labelInventorySlots = StatCollector.translateToLocalFormatted((String)labelInventorySlots, (Object[])new Object[]{this.inventorySize.getSelectionWidth() * this.inventorySize.getSelectionHeight(), this.inventorySize.getSelectionWidth(), this.inventorySize.getSelectionHeight()});
            this.fontRenderer.func_78276_b(labelInventorySize, 10, 140, 0x404040);
            this.fontRenderer.func_78276_b(labelInventorySlots, 10, 150, 0x404040);
        }
    }

    public void onChangeSliderValue(GuiSlider slider) {
        if (!this.resetting) {
            SkinProperties skinProps = this.tileEntity.getSkinProps();
            SkinProperties.PROP_WINGS_IDLE_SPEED.setValue(skinProps, Double.valueOf(Math.round(this.sliderWingIdleSpeed.getValue())));
            SkinProperties.PROP_WINGS_FLYING_SPEED.setValue(skinProps, Double.valueOf(Math.round(this.sliderWingFlyingSpeed.getValue())));
            SkinProperties.PROP_WINGS_MIN_ANGLE.setValue(skinProps, Double.valueOf(Math.round(this.sliderWingMinAngle.getValue())));
            SkinProperties.PROP_WINGS_MAX_ANGLE.setValue(skinProps, Double.valueOf(Math.round(this.sliderWingMaxAngle.getValue())));
            PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientGuiSetArmourerSkinProps(skinProps));
        }
    }

    @Override
    public void onDropDownListChanged(GuiDropDownList dropDownList) {
        SkinProperties skinProps = this.tileEntity.getSkinProps();
        SkinProperties.PROP_WINGS_MOVMENT_TYPE.setValue(skinProps, dropDownList.getListSelectedItem().tag);
        ModLogger.log("Setting skin movment type to: " + dropDownList.getListSelectedItem().tag);
        PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientGuiSetArmourerSkinProps(skinProps));
    }
}

