/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.client.gui.controls;

import cpw.mods.fml.client.config.GuiButtonExt;
import cpw.mods.fml.client.config.GuiUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import riskyken.armourersWorkshop.utils.UtilColour;

@SideOnly(value=Side.CLIENT)
public class GuiColourSelector
extends GuiButtonExt {
    private Color selectedColour;
    private int colorWidth;
    private int colourHeight;
    private int rowLength;
    private ResourceLocation guiTexture;
    private UtilColour.ColourFamily colourFamily;

    public GuiColourSelector(int id, int xPos, int yPos, int width, int height, int colorWidth, int colourHeight, int rowLength, ResourceLocation guiTexture) {
        super(id, xPos, yPos, width, height, "");
        this.colorWidth = colorWidth;
        this.colourHeight = colourHeight;
        this.rowLength = rowLength;
        this.guiTexture = guiTexture;
        this.colourFamily = UtilColour.ColourFamily.MINECRAFT;
    }

    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        this.field_146123_n = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        int k = this.getHoverState(this.field_146123_n);
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)buttonTextures, (int)this.xPosition, (int)this.yPosition, (int)0, (int)46, (int)this.width, (int)this.height, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.zLevel);
        mc.field_71446_o.func_110577_a(this.guiTexture);
        for (int i = 0; i < 16; ++i) {
            int curRow = i / this.rowLength;
            Color c = new Color(UtilColour.getMinecraftColor(i, this.colourFamily));
            float red = (float)c.getRed() / 255.0f;
            float green = (float)c.getGreen() / 255.0f;
            float blue = (float)c.getBlue() / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
            int xPos = this.xPosition + 1 + this.colorWidth * i - curRow * this.colourHeight * this.rowLength;
            int yPos = this.yPosition + 1 + curRow * 10;
            this.drawTexturedModalRect(xPos, yPos, 146, 52, this.colorWidth, this.colourHeight);
            if (!(mouseX >= xPos & mouseY >= yPos & mouseX <= xPos + this.colorWidth & mouseY <= yPos + this.colourHeight)) continue;
            this.selectedColour = new Color(UtilColour.getMinecraftColor(i, this.colourFamily));
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mouseDragged(mc, mouseX, mouseY);
    }

    public UtilColour.ColourFamily getColourFamily() {
        return this.colourFamily;
    }

    public void setColourFamily(UtilColour.ColourFamily colourFamily) {
        this.colourFamily = colourFamily;
    }

    public Color getSelectedColour() {
        return this.selectedColour;
    }
}

