/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.client.gui.controls;

import cpw.mods.fml.client.config.GuiButtonExt;
import net.minecraft.client.Minecraft;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiInventorySize
extends GuiButtonExt {
    private static final int BUTTON_WIDTH = 10;
    private static final int BUTTON_HEIGHT = 10;
    public final int maxWidth;
    public final int maxHeight;
    private int selectionWidth = 1;
    private int selectionHeight = 1;
    private ResourceLocation texture;
    private int srcX = 0;
    private int srcY = 0;

    public GuiInventorySize(int xPos, int yPos, int maxWidth, int maxHeight) {
        super(-1, xPos, yPos, maxWidth * 10, maxHeight * 10, "");
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public void setSrc(ResourceLocation texture, int srcX, int srcY) {
        this.texture = texture;
        this.srcX = srcX;
        this.srcY = srcY;
    }

    public void setSelection(int selectionWidth, int selectionHeight) {
        this.selectionWidth = MathHelper.clamp_int((int)selectionWidth, (int)1, (int)this.maxWidth);
        this.selectionHeight = MathHelper.clamp_int((int)selectionHeight, (int)1, (int)this.maxHeight);
    }

    public int getSelectionWidth() {
        return this.selectionWidth;
    }

    public int getSelectionHeight() {
        return this.selectionHeight;
    }

    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        int hoverWidth = MathHelper.ceiling_float_int((float)((float)(mouseX - this.xPosition) / 10.0f));
        int hoverHeight = MathHelper.ceiling_float_int((float)((float)(mouseY - this.yPosition) / 10.0f));
        if (this.visible) {
            mc.field_71446_o.func_110577_a(this.texture);
            this.field_146123_n = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
            int k = this.getHoverState(this.field_146123_n);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int ix = 0; ix < this.maxWidth; ++ix) {
                for (int iy = 0; iy < this.maxHeight; ++iy) {
                    int srcX = this.srcX;
                    int srcY = this.srcY;
                    if (ix < this.selectionWidth & iy < this.selectionHeight) {
                        srcX += 10;
                    }
                    if (ix < hoverWidth & iy < hoverHeight & k == 2) {
                        srcY += 10;
                    }
                    this.drawTexturedModalRect(this.xPosition + 10 * ix, this.yPosition + 10 * iy, srcX, srcY, 10, 10);
                }
            }
        }
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        if (super.mousePressed(mc, mouseX, mouseY)) {
            int selectionWidth = MathHelper.ceiling_float_int((float)((float)(mouseX - this.xPosition) / 10.0f));
            int selectionHeight = MathHelper.ceiling_float_int((float)((float)(mouseY - this.yPosition) / 10.0f));
            this.setSelection(selectionWidth, selectionHeight);
            return true;
        }
        return false;
    }
}

