/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.client.handler;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.nio.charset.CharsetEncoder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.apache.commons.io.Charsets;

@SideOnly(value=Side.CLIENT)
public final class RehostedJarHandler {
    private static final String STOP_MOD_REPOSTS_URL = "http://stopmodreposts.org/";
    private boolean validJar = false;
    private long lastMessagePost = 0L;
    private long messagePostRate = 60000L;

    public RehostedJarHandler(File jarFile, String originalName) {
        this.checkIfJarIsValid(jarFile, originalName);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    private void checkIfJarIsValid(File jarFile, String originalName) {
        if (jarFile == null) {
            return;
        }
        if (jarFile.getName().equals(originalName)) {
            this.validJar = true;
            return;
        }
        CharsetEncoder asciiEncoder = Charsets.US_ASCII.newEncoder();
        if (!asciiEncoder.canEncode(jarFile.getName())) {
            this.validJar = true;
            return;
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (this.validJar) {
            return;
        }
        if (event.side != Side.CLIENT) {
            return;
        }
        if (event.type != TickEvent.Type.PLAYER) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.lastMessagePost + this.messagePostRate > System.currentTimeMillis()) {
            return;
        }
        this.lastMessagePost = System.currentTimeMillis();
        EntityClientPlayerMP player = Minecraft.func_71410_x().thePlayer;
        ChatComponentTranslation downloadLink = new ChatComponentTranslation("chat.armourersworkshop:invalidJarDownload", new Object[]{null});
        downloadLink.getChatStyle().setUnderlined(Boolean.valueOf(true));
        downloadLink.getChatStyle().setColor(EnumChatFormatting.BLUE);
        downloadLink.getChatStyle().setChatHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentTranslation("chat.armourersworkshop:invalidJarDownloadTooltip", new Object[]{null})));
        downloadLink.getChatStyle().setChatClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/armourers-workshop/files"));
        ChatComponentTranslation stopModRepostsLink = new ChatComponentTranslation("chat.armourersworkshop:invalidJarStopModReposts", new Object[]{null});
        stopModRepostsLink.getChatStyle().setUnderlined(Boolean.valueOf(true));
        stopModRepostsLink.getChatStyle().setColor(EnumChatFormatting.BLUE);
        stopModRepostsLink.getChatStyle().setChatHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentTranslation("chat.armourersworkshop:invalidJarStopModRepostsTooltip", new Object[]{null})));
        stopModRepostsLink.getChatStyle().setChatClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, STOP_MOD_REPOSTS_URL));
        ChatComponentTranslation updateMessage = new ChatComponentTranslation("chat.armourersworkshop:invalidJar", new Object[]{downloadLink, stopModRepostsLink});
        updateMessage.getChatStyle().setColor(EnumChatFormatting.RED);
        player.addChatMessage((IChatComponent)updateMessage);
    }
}

