/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.client.particles;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import riskyken.armourersWorkshop.client.render.IRenderBuffer;
import riskyken.armourersWorkshop.client.render.RenderBridge;
import riskyken.armourersWorkshop.utils.UtilRender;

@SideOnly(value=Side.CLIENT)
public class EntityFXPaintSplash
extends EntityFX {
    private static final ResourceLocation paintSplashTextures = new ResourceLocation("armourersWorkshop".toLowerCase(), "textures/particles/paintSplash.png");
    private static final ResourceLocation particleTextures = (ResourceLocation)ReflectionHelper.getPrivateValue(EffectRenderer.class, null, (String[])new String[]{"particleTextures", "field_110737_b", "b"});

    public EntityFXPaintSplash(World world, double x, double y, double z, int colour, ForgeDirection dir) {
        super(world, x + (double)dir.offsetX * 0.5, y + (double)dir.offsetY * 0.5, z + (double)dir.offsetZ * 0.5);
        this.particleScale = 0.2f + world.field_73012_v.nextFloat() * 0.4f;
        this.particleMaxAge = 10;
        Color c = new Color(colour);
        this.particleRed = (float)c.getRed() / 255.0f;
        this.particleGreen = (float)c.getGreen() / 255.0f;
        this.particleBlue = (float)c.getBlue() / 255.0f;
        float xPos = world.field_73012_v.nextFloat() - 0.5f;
        float yPos = world.field_73012_v.nextFloat() - 0.5f;
        switch (dir) {
            case UP: {
                this.setPosition(this.posX + (double)xPos, this.posY, this.posZ + (double)yPos);
                break;
            }
            case DOWN: {
                this.setPosition(this.posX + (double)xPos, this.posY, this.posZ + (double)yPos);
                break;
            }
            case NORTH: {
                this.setPosition(this.posX + (double)xPos, this.posY + (double)yPos, this.posZ);
                break;
            }
            case SOUTH: {
                this.setPosition(this.posX + (double)xPos, this.posY + (double)yPos, this.posZ);
                break;
            }
            case EAST: {
                this.setPosition(this.posX, this.posY + (double)yPos, this.posZ + (double)xPos);
                break;
            }
            case WEST: {
                this.setPosition(this.posX, this.posY + (double)yPos, this.posZ + (double)xPos);
                break;
            }
        }
        this.motionX = (double)dir.offsetX * 0.08;
        this.motionY = (double)dir.offsetY * 0.08;
        this.motionZ = (double)dir.offsetZ * 0.08;
        this.motionX += (double)(world.field_73012_v.nextFloat() - 0.5f) * 0.06;
        this.motionY += (double)(world.field_73012_v.nextFloat() - 0.5f) * 0.06;
        this.motionZ += (double)(world.field_73012_v.nextFloat() - 0.5f) * 0.06;
        this.particleTextureIndexX = Math.round(world.field_73012_v.nextFloat()) * 8;
        this.particleTextureIndexY = Math.round(world.field_73012_v.nextFloat()) * 8;
        this.noClip = false;
    }

    public void onUpdate() {
        super.onUpdate();
        this.motionY -= 0.02;
        this.particleAlpha = 1.0f + -((float)this.particleAge / (float)this.particleMaxAge);
    }

    public void renderParticle(Tessellator tessellator, float p_70539_2_, float p_70539_3_, float p_70539_4_, float p_70539_5_, float p_70539_6_, float p_70539_7_) {
        IRenderBuffer renderBuffer = RenderBridge.INSTANCE;
        renderBuffer.draw();
        UtilRender.bindTexture(paintSplashTextures);
        renderBuffer.startDrawingQuads();
        renderBuffer.setBrightness(this.getBrightnessForRender(0.0f));
        float f6 = (float)(this.particleTextureIndexX / 8) * 0.5f;
        float f7 = f6 + 0.5f;
        float f8 = (float)(this.particleTextureIndexY / 8) * 0.5f;
        float f9 = f8 + 0.5f;
        float f10 = 0.1f * this.particleScale;
        if (this.particleIcon != null) {
            f6 = this.particleIcon.getMinU();
            f7 = this.particleIcon.getMaxU();
            f8 = this.particleIcon.getMinV();
            f9 = this.particleIcon.getMaxV();
        }
        float f11 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)p_70539_2_ - interpPosX);
        float f12 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)p_70539_2_ - interpPosY);
        float f13 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)p_70539_2_ - interpPosZ);
        renderBuffer.setColourRGBA_F(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha);
        renderBuffer.addVertexWithUV(f11 - p_70539_3_ * f10 - p_70539_6_ * f10, f12 - p_70539_4_ * f10, f13 - p_70539_5_ * f10 - p_70539_7_ * f10, f7, f9);
        renderBuffer.addVertexWithUV(f11 - p_70539_3_ * f10 + p_70539_6_ * f10, f12 + p_70539_4_ * f10, f13 - p_70539_5_ * f10 + p_70539_7_ * f10, f7, f8);
        renderBuffer.addVertexWithUV(f11 + p_70539_3_ * f10 + p_70539_6_ * f10, f12 + p_70539_4_ * f10, f13 + p_70539_5_ * f10 + p_70539_7_ * f10, f6, f8);
        renderBuffer.addVertexWithUV(f11 + p_70539_3_ * f10 - p_70539_6_ * f10, f12 - p_70539_4_ * f10, f13 + p_70539_5_ * f10 - p_70539_7_ * f10, f6, f9);
        renderBuffer.draw();
        UtilRender.bindTexture(particleTextures);
        renderBuffer.startDrawingQuads();
    }
}

