/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.client.render.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import riskyken.armourersWorkshop.api.common.painting.IPantableBlock;
import riskyken.armourersWorkshop.api.common.skin.cubes.ICubeColour;
import riskyken.armourersWorkshop.client.render.IRenderBuffer;
import riskyken.armourersWorkshop.client.render.ModRenderHelper;
import riskyken.armourersWorkshop.client.render.RenderBridge;

@SideOnly(value=Side.CLIENT)
public class RenderBlockGlowing
implements ISimpleBlockRenderingHandler {
    public static int renderId = 0;

    public RenderBlockGlowing() {
        renderId = RenderingRegistry.getNextAvailableRenderId();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        boolean glowing;
        this.renderItem(block, metadata, renderer);
        boolean bl = glowing = block.getLightValue() > 0;
        if (glowing) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
            GL11.glEnable((int)3042);
            ModRenderHelper.enableAlphaBlend();
            GL11.glDisable((int)2896);
            this.renderItem(block, metadata, renderer);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    private void renderItem(Block block, int metadata, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.instance;
        block.setBlockBoundsForItemRender();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderer.renderFaceYNeg(block, 0.0, 0.0, 0.0, block.getIcon(255, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderer.renderFaceYPos(block, 0.0, 0.0, 0.0, block.getIcon(255, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderer.renderFaceZNeg(block, 0.0, 0.0, 0.0, block.getIcon(255, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderer.renderFaceZPos(block, 0.0, 0.0, 0.0, block.getIcon(255, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderer.renderFaceXNeg(block, 0.0, 0.0, 0.0, block.getIcon(255, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderer.renderFaceXPos(block, 0.0, 0.0, 0.0, block.getIcon(255, metadata));
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (block instanceof IPantableBlock) {
            int light = block.getLightValue(world, x, y, z);
            Tessellator tessellator = Tessellator.instance;
            ICubeColour colour = ((IPantableBlock)block).getColour(world, x, y, z);
            boolean rendered = false;
            renderer.renderAllFaces = false;
            rendered = light > 1 ? this.renderFaces(world, x, y, z, colour, block, renderer) : this.renderFacesWithLighting(world, x, y, z, colour, block, renderer);
            return rendered;
        }
        renderer.renderAllFaces = false;
        return renderer.renderStandardBlock(block, x, y, z);
    }

    private boolean renderFaces(IBlockAccess world, int x, int y, int z, ICubeColour colour, Block block, RenderBlocks renderer) {
        int pt;
        boolean rendered = false;
        int meta = world.getBlockMetadata(x, y, z);
        IRenderBuffer renderBuffer = RenderBridge.INSTANCE;
        renderBuffer.setBrightness(0xF000F0);
        double faceOffset = 0.02;
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y - 1, z, 0)) {
            pt = colour.getPaintType(0) & 0xFF;
            renderBuffer.setColorOpaque_B(colour.getRed(0), colour.getGreen(0), colour.getBlue(0));
            renderer.renderFaceYNeg(block, (double)x, (double)y, (double)z, block.getIcon(pt, 0));
            if (meta == 1) {
                renderBuffer.setColorOpaque_B((byte)-1, (byte)-1, (byte)-1);
                renderer.renderFaceYNeg(block, (double)x, (double)y - faceOffset, (double)z, block.getIcon(0, meta));
            }
            rendered = true;
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y + 1, z, 1)) {
            pt = colour.getPaintType(1) & 0xFF;
            renderBuffer.setColorOpaque_B(colour.getRed(1), colour.getGreen(1), colour.getBlue(1));
            renderer.renderFaceYPos(block, (double)x, (double)y, (double)z, block.getIcon(pt, 0));
            if (meta == 2) {
                renderBuffer.setColorOpaque_B((byte)-1, (byte)-1, (byte)-1);
                renderer.renderFaceYPos(block, (double)x, (double)y + faceOffset, (double)z, block.getIcon(1, meta));
            }
            rendered = true;
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y, z - 1, 2)) {
            pt = colour.getPaintType(2) & 0xFF;
            renderBuffer.setColorOpaque_B(colour.getRed(2), colour.getGreen(2), colour.getBlue(2));
            renderer.renderFaceZNeg(block, (double)x, (double)y, (double)z, block.getIcon(pt, 0));
            if (meta == 3) {
                renderBuffer.setColorOpaque_B((byte)-1, (byte)-1, (byte)-1);
                renderer.renderFaceZNeg(block, (double)x, (double)y, (double)z - faceOffset, block.getIcon(2, meta));
            }
            rendered = true;
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y, z + 1, 3)) {
            pt = colour.getPaintType(3) & 0xFF;
            renderBuffer.setColorOpaque_B(colour.getRed(3), colour.getGreen(3), colour.getBlue(3));
            renderer.renderFaceZPos(block, (double)x, (double)y, (double)z, block.getIcon(pt, 0));
            if (meta == 4) {
                renderBuffer.setColorOpaque_B((byte)-1, (byte)-1, (byte)-1);
                renderer.renderFaceZPos(block, (double)x, (double)y, (double)z + faceOffset, block.getIcon(3, meta));
            }
            rendered = true;
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x - 1, y, z, 4)) {
            pt = colour.getPaintType(4) & 0xFF;
            renderBuffer.setColorOpaque_B(colour.getRed(4), colour.getGreen(4), colour.getBlue(4));
            renderer.renderFaceXNeg(block, (double)x, (double)y, (double)z, block.getIcon(pt, 0));
            if (meta == 5) {
                renderBuffer.setColorOpaque_B((byte)-1, (byte)-1, (byte)-1);
                renderer.renderFaceXNeg(block, (double)x - faceOffset, (double)y, (double)z, block.getIcon(4, meta));
            }
            rendered = true;
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x + 1, y, z, 5)) {
            pt = colour.getPaintType(5) & 0xFF;
            renderBuffer.setColorOpaque_B(colour.getRed(5), colour.getGreen(5), colour.getBlue(5));
            renderer.renderFaceXPos(block, (double)x, (double)y, (double)z, block.getIcon(pt, 0));
            if (meta == 6) {
                renderBuffer.setColorOpaque_B((byte)-1, (byte)-1, (byte)-1);
                renderer.renderFaceXPos(block, (double)x + faceOffset, (double)y, (double)z, block.getIcon(5, meta));
            }
            rendered = true;
        }
        return rendered;
    }

    private boolean renderFacesWithLighting(IBlockAccess world, int x, int y, int z, ICubeColour colour, Block block, RenderBlocks renderer) {
        int pt;
        boolean rendered = false;
        int meta = world.getBlockMetadata(x, y, z);
        IRenderBuffer renderBuffer = RenderBridge.INSTANCE;
        double faceOffset = 0.02;
        float yNegLight = 0.5f;
        float yPosLight = 1.0f;
        float zLight = 0.8f;
        float xLight = 0.6f;
        float yNegR = yNegLight * ((float)(colour.getRed(0) & 0xFF) / 255.0f);
        float yNegG = yNegLight * ((float)(colour.getGreen(0) & 0xFF) / 255.0f);
        float yNegB = yNegLight * ((float)(colour.getBlue(0) & 0xFF) / 255.0f);
        float yPosR = yPosLight * ((float)(colour.getRed(1) & 0xFF) / 255.0f);
        float yPosG = yPosLight * ((float)(colour.getGreen(1) & 0xFF) / 255.0f);
        float yPosB = yPosLight * ((float)(colour.getBlue(1) & 0xFF) / 255.0f);
        float zNegR = zLight * ((float)(colour.getRed(2) & 0xFF) / 255.0f);
        float zNegG = zLight * ((float)(colour.getGreen(2) & 0xFF) / 255.0f);
        float zNegB = zLight * ((float)(colour.getBlue(2) & 0xFF) / 255.0f);
        float zPosR = zLight * ((float)(colour.getRed(3) & 0xFF) / 255.0f);
        float zPosG = zLight * ((float)(colour.getGreen(3) & 0xFF) / 255.0f);
        float zPosB = zLight * ((float)(colour.getBlue(3) & 0xFF) / 255.0f);
        float xNegR = xLight * ((float)(colour.getRed(4) & 0xFF) / 255.0f);
        float xNegG = xLight * ((float)(colour.getGreen(4) & 0xFF) / 255.0f);
        float xNegB = xLight * ((float)(colour.getBlue(4) & 0xFF) / 255.0f);
        float xPosR = xLight * ((float)(colour.getRed(5) & 0xFF) / 255.0f);
        float xPosG = xLight * ((float)(colour.getGreen(5) & 0xFF) / 255.0f);
        float xPosB = xLight * ((float)(colour.getBlue(5) & 0xFF) / 255.0f);
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y - 1, z, 0)) {
            pt = colour.getPaintType(0) & 0xFF;
            renderBuffer.setBrightness(block.getMixedBrightnessForBlock(world, x, y - 1, z));
            renderBuffer.setColorOpaque_F(yNegR, yNegG, yNegB);
            renderer.renderFaceYNeg(block, (double)x, (double)y, (double)z, block.getIcon(pt, 0));
            if (meta == 1) {
                renderBuffer.setColorOpaque_B((byte)-1, (byte)-1, (byte)-1);
                renderer.renderFaceYNeg(block, (double)x, (double)y - faceOffset, (double)z, block.getIcon(0, meta));
            }
            rendered = true;
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y + 1, z, 1)) {
            pt = colour.getPaintType(1) & 0xFF;
            renderBuffer.setBrightness(block.getMixedBrightnessForBlock(world, x, y + 1, z));
            renderBuffer.setColorOpaque_F(yPosR, yPosG, yPosB);
            renderer.renderFaceYPos(block, (double)x, (double)y, (double)z, block.getIcon(pt, 0));
            if (meta == 2) {
                renderBuffer.setColorOpaque_B((byte)-1, (byte)-1, (byte)-1);
                renderer.renderFaceYPos(block, (double)x, (double)y + faceOffset, (double)z, block.getIcon(1, meta));
            }
            rendered = true;
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y, z - 1, 2)) {
            pt = colour.getPaintType(2) & 0xFF;
            renderBuffer.setBrightness(block.getMixedBrightnessForBlock(world, x, y, z - 1));
            renderBuffer.setColorOpaque_F(zNegR, zNegG, zNegB);
            renderer.renderFaceZNeg(block, (double)x, (double)y, (double)z, block.getIcon(pt, 0));
            if (meta == 3) {
                renderBuffer.setColorOpaque_B((byte)-1, (byte)-1, (byte)-1);
                renderer.renderFaceZNeg(block, (double)x, (double)y, (double)z - faceOffset, block.getIcon(2, meta));
            }
            rendered = true;
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y, z + 1, 3)) {
            pt = colour.getPaintType(3) & 0xFF;
            renderBuffer.setBrightness(block.getMixedBrightnessForBlock(world, x, y, z + 1));
            renderBuffer.setColorOpaque_F(zPosR, zPosG, zPosB);
            renderer.renderFaceZPos(block, (double)x, (double)y, (double)z, block.getIcon(pt, 0));
            if (meta == 4) {
                renderBuffer.setColorOpaque_B((byte)-1, (byte)-1, (byte)-1);
                renderer.renderFaceZPos(block, (double)x, (double)y, (double)z + faceOffset, block.getIcon(3, meta));
            }
            rendered = true;
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x - 1, y, z, 4)) {
            pt = colour.getPaintType(4) & 0xFF;
            renderBuffer.setBrightness(block.getMixedBrightnessForBlock(world, x - 1, y, z));
            renderBuffer.setColorOpaque_F(xNegR, xNegG, xNegB);
            renderer.renderFaceXNeg(block, (double)x, (double)y, (double)z, block.getIcon(pt, 0));
            if (meta == 5) {
                renderBuffer.setColorOpaque_B((byte)-1, (byte)-1, (byte)-1);
                renderer.renderFaceXNeg(block, (double)x - faceOffset, (double)y, (double)z, block.getIcon(4, meta));
            }
            rendered = true;
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x + 1, y, z, 5)) {
            pt = colour.getPaintType(5) & 0xFF;
            renderBuffer.setBrightness(block.getMixedBrightnessForBlock(world, x + 1, y, z));
            renderBuffer.setColorOpaque_F(xPosR, xPosG, xPosB);
            renderer.renderFaceXPos(block, (double)x, (double)y, (double)z, block.getIcon(pt, 0));
            if (meta == 6) {
                renderBuffer.setColorOpaque_B((byte)-1, (byte)-1, (byte)-1);
                renderer.renderFaceXPos(block, (double)x + faceOffset, (double)y, (double)z, block.getIcon(5, meta));
            }
            rendered = true;
        }
        return rendered;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return renderId;
    }
}

