/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.common.blocks;

import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import riskyken.armourersWorkshop.ArmourersWorkshop;
import riskyken.armourersWorkshop.client.lib.LibBlockResources;
import riskyken.armourersWorkshop.common.blocks.AbstractModBlockContainer;
import riskyken.armourersWorkshop.common.items.block.ModItemBlock;
import riskyken.armourersWorkshop.common.tileentities.TileEntityColourMixer;
import riskyken.armourersWorkshop.proxies.ClientProxy;
import riskyken.armourersWorkshop.utils.BlockUtils;

public class BlockColourMixer
extends AbstractModBlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bottomIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon sideOverlayIcon;

    public BlockColourMixer() {
        super("colourMixer");
        this.setSortPriority(124);
    }

    public Block setBlockName(String name) {
        GameRegistry.registerBlock((Block)this, ModItemBlock.class, (String)("block." + name));
        return super.setBlockName(name);
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        BlockUtils.dropInventoryBlocks(world, x, y, z);
        super.breakBlock(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.blockIcon = register.registerIcon(LibBlockResources.COLOUR_MIXER_SIDE);
        this.topIcon = register.registerIcon(LibBlockResources.COLOUR_MIXER_TOP);
        this.bottomIcon = register.registerIcon(LibBlockResources.COLOUR_MIXER_BOTTOM);
        this.sideOverlayIcon = register.registerIcon(LibBlockResources.COLOUR_MIXER_SIDE_OVERLAY);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (side == 0) {
            return this.bottomIcon;
        }
        if (side == 1) {
            return this.topIcon;
        }
        if (ClientProxy.renderPass == 0) {
            return this.sideOverlayIcon;
        }
        return this.blockIcon;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity te;
        if (ClientProxy.renderPass == 0 && (te = blockAccess.getTileEntity(x, y, z)) != null && te instanceof TileEntityColourMixer) {
            return ((TileEntityColourMixer)te).getColour(0);
        }
        return -1;
    }

    public int getRenderType() {
        return ArmourersWorkshop.proxy.getBlockRenderType((Block)this);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float xHit, float yHit, float zHit) {
        if (!player.canPlayerEdit(x, y, z, side, player.getCurrentEquippedItem())) {
            return false;
        }
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)ArmourersWorkshop.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileEntityColourMixer();
    }
}

