/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.common.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import riskyken.armourersWorkshop.ArmourersWorkshop;
import riskyken.armourersWorkshop.api.common.painting.IPantable;
import riskyken.armourersWorkshop.api.common.painting.IPantableBlock;
import riskyken.armourersWorkshop.api.common.skin.cubes.ICubeColour;
import riskyken.armourersWorkshop.client.lib.LibBlockResources;
import riskyken.armourersWorkshop.common.blocks.AbstractModBlockContainer;
import riskyken.armourersWorkshop.common.items.block.ModItemBlock;
import riskyken.armourersWorkshop.common.painting.PaintType;
import riskyken.armourersWorkshop.common.skin.cubes.CubeColour;
import riskyken.armourersWorkshop.common.tileentities.TileEntityColourable;
import riskyken.armourersWorkshop.utils.UtilColour;

public class BlockColourable
extends AbstractModBlockContainer
implements IPantableBlock {
    @SideOnly(value=Side.CLIENT)
    protected IIcon markerOverlay;
    @SideOnly(value=Side.CLIENT)
    protected IIcon noTexture;

    public BlockColourable(String name, boolean glowing) {
        super(name);
        if (glowing) {
            this.func_149715_a(1.0f);
        }
        this.func_149711_c(1.0f);
        this.func_149713_g(0);
        this.setSortPriority(123);
        if (glowing) {
            this.setSortPriority(122);
        }
    }

    public Block setBlockName(String name) {
        GameRegistry.registerBlock((Block)this, ModItemBlock.class, (String)("block." + name));
        return super.setBlockName(name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.blockIcon = register.registerIcon(LibBlockResources.COLOURABLE);
        this.markerOverlay = register.registerIcon(LibBlockResources.COLOURABLE_MARKER);
        this.noTexture = register.registerIcon(LibBlockResources.COLOURABLE_NO_TEXTURE);
    }

    public IIcon getIcon(int paintType, int meta) {
        if (meta > 0) {
            return this.markerOverlay;
        }
        if (paintType == 0) {
            return this.noTexture;
        }
        return super.getIcon(paintType, meta);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float xHit, float yHit, float zHit) {
        if (!player.canPlayerEdit(x, y, z, side, player.getCurrentEquippedItem())) {
            return false;
        }
        if (player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().func_77973_b() == Items.dye) {
            if (world.field_72995_K) {
                return true;
            }
            this.setColour((IBlockAccess)world, x, y, z, UtilColour.getMinecraftColor(-player.getCurrentEquippedItem().func_77952_i() + 15, UtilColour.ColourFamily.MINECRAFT), side);
            return true;
        }
        return false;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityColourable();
    }

    @Override
    public boolean setColour(IBlockAccess world, int x, int y, int z, int colour, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null & te instanceof IPantable) {
            ((IPantable)te).setColour(colour, side);
            return true;
        }
        return false;
    }

    @Override
    public boolean setColour(IBlockAccess world, int x, int y, int z, byte[] rgb, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null & te instanceof IPantable) {
            ((IPantable)te).setColour(rgb, side);
            return true;
        }
        return false;
    }

    @Override
    public int getColour(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null & te instanceof IPantable) {
            return ((IPantable)te).getColour(side);
        }
        return 0;
    }

    @Override
    public ICubeColour getColour(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null & te instanceof IPantable) {
            return ((IPantable)te).getColour();
        }
        return new CubeColour();
    }

    @Override
    public void setPaintType(IBlockAccess world, int x, int y, int z, PaintType paintType, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null & te instanceof IPantable) {
            ((IPantable)te).setPaintType(paintType, side);
        }
    }

    @Override
    public PaintType getPaintType(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null & te instanceof IPantable) {
            return ((IPantable)te).getPaintType(side);
        }
        return PaintType.NORMAL;
    }

    @Override
    public boolean isRemoteOnly(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public int getRenderType() {
        return ArmourersWorkshop.proxy.getBlockRenderType((Block)this);
    }
}

