/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.common.blocks;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntitySpellParticleFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import riskyken.armourersWorkshop.ArmourersWorkshop;
import riskyken.armourersWorkshop.client.lib.LibBlockResources;
import riskyken.armourersWorkshop.common.Contributors;
import riskyken.armourersWorkshop.common.blocks.AbstractModBlockContainer;
import riskyken.armourersWorkshop.common.blocks.ModBlocks;
import riskyken.armourersWorkshop.common.config.ConfigHandler;
import riskyken.armourersWorkshop.common.items.ModItems;
import riskyken.armourersWorkshop.common.items.block.ModItemBlockNoStack;
import riskyken.armourersWorkshop.common.tileentities.TileEntityMannequin;
import riskyken.armourersWorkshop.utils.BlockUtils;
import riskyken.armourersWorkshop.utils.HolidayHelper;
import riskyken.armourersWorkshop.utils.UtilItems;

public class BlockDoll
extends AbstractModBlockContainer {
    private static final String TAG_OWNER = "owner";
    private final boolean isValentins;

    public BlockDoll() {
        super("doll", Material.rock, soundTypeMetal, !ConfigHandler.hideDollFromCreativeTabs);
        this.func_149713_g(0);
        this.setBlockBounds(0.2f, 0.0f, 0.2f, 0.8f, 0.95f, 0.8f);
        this.isValentins = HolidayHelper.valentins.isHolidayActive();
        this.setSortPriority(198);
    }

    public Block setBlockName(String name) {
        GameRegistry.registerBlock((Block)this, ModItemBlockNoStack.class, (String)("block." + name));
        return super.setBlockName(name);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int metadata) {
        if (!world.field_72995_K) {
            TileEntity te = world.getTileEntity(x, y, z);
            if (te != null && te instanceof TileEntityMannequin) {
                ItemStack dropStack = ((TileEntityMannequin)te).getDropStack();
                UtilItems.spawnItemInWorld(world, x, y, z, dropStack);
            }
            BlockUtils.dropInventoryBlocks(world, x, y, z);
        }
        super.breakBlock(world, x, y, z, block, metadata);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof TileEntityMannequin) {
            int l = MathHelper.floor_double((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
            ((TileEntityMannequin)te).setRotation(l);
            if (stack.func_77942_o()) {
                NBTTagCompound compound = stack.func_77978_p();
                GameProfile gameProfile = null;
                if (compound.func_150297_b(TAG_OWNER, 10)) {
                    gameProfile = NBTUtil.func_152459_a((NBTTagCompound)compound.func_74775_l(TAG_OWNER));
                    ((TileEntityMannequin)te).setGameProfile(gameProfile);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        Contributors.Contributor contributor;
        TileEntityMannequin te;
        TileEntity tileEntity;
        if (this.isValentins && random.nextFloat() * 100.0f > 80.0f) {
            world.spawnParticle("heart", (double)x + 0.2 + (double)(random.nextFloat() * 0.6f), (double)y + 1.0, (double)z + 0.2 + (double)(random.nextFloat() * 0.6f), 0.0, 0.0, 0.0);
        }
        if ((tileEntity = world.getTileEntity(x, y, z)) != null && tileEntity instanceof TileEntityMannequin && (te = (TileEntityMannequin)tileEntity).isRenderExtras() & te.isVisible() && (contributor = Contributors.INSTANCE.getContributor(te.getGameProfile())) != null) {
            EntitySpellParticleFX entityfx = new EntitySpellParticleFX(world, (double)((float)x + random.nextFloat() * 1.0f), (double)y, (double)((float)z + random.nextFloat() * 1.0f), 0.0, 0.0, 0.0);
            entityfx.setBaseSpellTextureIndex(144);
            entityfx.setRBGColorF((float)(contributor.r & 0xFF) / 255.0f, (float)(contributor.g & 0xFF) / 255.0f, (float)(contributor.b & 0xFF) / 255.0f);
            Minecraft.func_71410_x().field_71452_i.addEffect((EntityFX)entityfx);
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof TileEntityMannequin) {
            int rotation = ((TileEntityMannequin)te).getRotation();
            if (++rotation > 15) {
                rotation = 0;
            }
            ((TileEntityMannequin)te).setRotation(rotation);
        }
        return true;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityMannequin teMan;
        TileEntity te;
        ItemStack stack = new ItemStack(ModBlocks.doll, 1);
        int meta = world.getBlockMetadata(x, y, z);
        int yOffset = 0;
        if (meta == 1) {
            yOffset = -1;
        }
        if ((te = world.getTileEntity(x, y + yOffset, z)) != null && te instanceof TileEntityMannequin && (teMan = (TileEntityMannequin)te).getGameProfile() != null) {
            NBTTagCompound profileTag = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)profileTag, (GameProfile)teMan.getGameProfile());
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74782_a(TAG_OWNER, (NBTBase)profileTag);
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.blockIcon = register.registerIcon(LibBlockResources.COLOURABLE);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float xHit, float yHit, float zHit) {
        if (!player.canPlayerEdit(x, y, z, side, player.getCurrentEquippedItem())) {
            return false;
        }
        if (!world.field_72995_K) {
            ItemStack stack = player.getCurrentEquippedItem();
            if (stack != null && stack.func_77973_b() == ModItems.mannequinTool) {
                return false;
            }
            if (stack != null && stack.func_77973_b() == Items.name_tag) {
                TileEntity te = world.getTileEntity(x, y, z);
                if (te != null && te instanceof TileEntityMannequin && stack.func_77973_b() == Items.name_tag) {
                    ((TileEntityMannequin)te).setOwner(player.getCurrentEquippedItem());
                }
            } else {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)ArmourersWorkshop.instance, (int)6, (World)world, (int)x, (int)y, (int)z);
            }
        }
        return player.field_71071_by.func_70448_g() == null || player.field_71071_by.func_70448_g().func_77973_b() != ModItems.mannequinTool;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityMannequin(true);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isNormalCube() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return -1;
    }
}

