/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.common.blocks;

import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import riskyken.armourersWorkshop.ArmourersWorkshop;
import riskyken.armourersWorkshop.client.lib.LibBlockResources;
import riskyken.armourersWorkshop.common.blocks.AbstractModBlockContainer;
import riskyken.armourersWorkshop.common.items.block.ModItemBlock;
import riskyken.armourersWorkshop.common.tileentities.TileEntityHologramProjector;
import riskyken.armourersWorkshop.utils.BlockUtils;

public class BlockHologramProjector
extends AbstractModBlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottom;

    public BlockHologramProjector() {
        super("hologramProjector");
        this.setSortPriority(150);
    }

    public Block setBlockName(String name) {
        GameRegistry.registerBlock((Block)this, ModItemBlock.class, (String)("block." + name));
        return super.setBlockName(name);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        BlockUtils.dropInventoryBlocks(world, x, y, z);
        super.breakBlock(world, x, y, z, block, meta);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        int dir = BlockUtils.determineOrientation(x, y, z, entityLivingBase);
        world.setBlockMetadataWithNotify(x, y, z, dir, 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.blockIcon = register.registerIcon(LibBlockResources.HOLOGRAM_PROJECTOR_SIDE);
        this.iconTop = register.registerIcon(LibBlockResources.HOLOGRAM_PROJECTOR_TOP);
        this.iconBottom = register.registerIcon(LibBlockResources.HOLOGRAM_PROJECTOR_BOTTOM);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (side == 1) {
            return this.iconTop;
        }
        if (side == 0) {
            return this.iconBottom;
        }
        return this.blockIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta < 0 | meta > 5) {
            return this.blockIcon;
        }
        ForgeDirection dir = ForgeDirection.values()[meta];
        if (side == meta) {
            return this.iconTop;
        }
        if (side == dir.getOpposite().ordinal()) {
            return this.iconBottom;
        }
        return this.blockIcon;
    }

    public void onPostBlockPlaced(World world, int x, int y, int z, int p_149714_5_) {
        this.updatePoweredState(world, x, y, z);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityHologramProjector();
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float xHit, float yHit, float zHit) {
        if (!player.canPlayerEdit(x, y, z, side, player.getCurrentEquippedItem())) {
            return false;
        }
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)ArmourersWorkshop.instance, (int)16, (World)world, (int)x, (int)y, (int)z);
        }
        return true;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        world.setBlockMetadataWithNotify(x, y, z, axis.ordinal(), 2);
        return true;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighborBlock) {
        this.updatePoweredState(world, x, y, z);
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        this.updatePoweredState(world, x, y, z);
    }

    private void updatePoweredState(World world, int x, int y, int z) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.getTileEntity(x, y, z)) != null && tileEntity instanceof TileEntityHologramProjector) {
            ((TileEntityHologramProjector)tileEntity).updatePoweredState();
        }
    }
}

