/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.common.tileentities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import riskyken.armourersWorkshop.api.common.skin.type.ISkinPartType;
import riskyken.armourersWorkshop.api.common.skin.type.ISkinType;
import riskyken.armourersWorkshop.common.data.MiniCube;
import riskyken.armourersWorkshop.common.skin.data.SkinPart;
import riskyken.armourersWorkshop.common.skin.type.SkinTypeRegistry;
import riskyken.armourersWorkshop.common.tileentities.AbstractTileEntityInventory;

public class TileEntityMiniArmourer
extends AbstractTileEntityInventory {
    private static final String TAG_TYPE = "type";
    private static final int INVENTORY_SIZE = 2;
    @SideOnly(value=Side.CLIENT)
    public int red;
    @SideOnly(value=Side.CLIENT)
    public int green;
    @SideOnly(value=Side.CLIENT)
    public int blue;
    private ISkinType skinType;
    private ArrayList<SkinPart> skinParts = new ArrayList();

    public TileEntityMiniArmourer() {
        super(2);
        this.setSkinType(SkinTypeRegistry.skinHead, false);
    }

    public void cubeUpdateFromServer(ISkinPartType skinPartType, MiniCube cube, boolean remove) {
    }

    public ISkinType getSkinType() {
        return this.skinType;
    }

    public ArrayList<SkinPart> getSkinParts() {
        return this.skinParts;
    }

    public void setSkinParts(ArrayList<SkinPart> skinParts) {
        this.skinParts = skinParts;
    }

    public void setSkinType(ISkinType skinType) {
        if (skinType != this.skinType) {
            this.setSkinType(skinType, true);
        }
    }

    public void setSkinType(ISkinType skinType, boolean update) {
        this.skinType = skinType;
        this.skinParts.clear();
        if (this.skinType != null) {
            // empty if block
        }
        if (update) {
            this.func_70296_d();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeToNBT(compound);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 5, compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.skinType = SkinTypeRegistry.INSTANCE.getSkinTypeFromRegistryName(compound.func_74779_i(TAG_TYPE));
        if (this.skinType != null) {
            this.setSkinType(this.skinType, false);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.skinType != null) {
            compound.func_74778_a(TAG_TYPE, this.skinType.getRegistryName());
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 2), (double)(this.zCoord + 1));
    }

    public String getInventoryName() {
        return "miniArmourer";
    }
}

