/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.sndctrl.gui.IndividualSoundControlList;
import org.orecruncher.sndctrl.gui.IndividualSoundControlListEntry;

@OnlyIn(value=Dist.CLIENT)
public class IndividualSoundControlScreen
extends Screen {
    private static final int TOP_OFFSET = 10;
    private static final int BOTTOM_OFFSET = 15;
    private static final int HEADER_HEIGHT = 35;
    private static final int FOOTER_HEIGHT = 50;
    private static final int SEARCH_BAR_WIDTH = 200;
    private static final int SEARCH_BAR_HEIGHT = 20;
    private static final int SELECTION_HEIGHT_OFFSET = 5;
    private static final int SELECTION_WIDTH = 600;
    private static final int SELECTION_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 10;
    private static final int CONTROL_WIDTH = 130;
    private static final int TOOLTIP_Y_OFFSET = 30;
    private static final ITextComponent SAVE = new TranslationTextComponent("gui.done");
    private static final ITextComponent CANCEL = new TranslationTextComponent("gui.cancel");
    protected final Screen parent;
    protected final boolean enablePlay;
    protected TextFieldWidget searchField;
    protected IndividualSoundControlList soundConfigList;
    protected Button save;
    protected Button cancel;

    protected IndividualSoundControlScreen(@Nullable Screen parent, boolean enablePlay) {
        super((ITextComponent)new TranslationTextComponent("sndctrl.text.soundconfig.title"));
        this.parent = parent;
        this.enablePlay = enablePlay;
    }

    protected void func_231160_c_() {
        GameUtils.getMC().field_195559_v.func_197967_a(true);
        int searchBarLeftMargin = (this.field_230708_k_ - 200) / 2;
        int searchBarY = 25;
        this.searchField = new TextFieldWidget(this.field_230712_o_, searchBarLeftMargin, 25, 200, 20, this.searchField, StringTextComponent.field_240750_d_);
        this.searchField.func_212954_a(filter -> this.soundConfigList.setSearchFilter(() -> filter, false));
        this.field_230705_e_.add(this.searchField);
        int topY = 50;
        int bottomY = this.field_230709_l_ - 15 - 50 - 5;
        this.soundConfigList = new IndividualSoundControlList(this, GameUtils.getMC(), this.field_230708_k_, this.field_230709_l_, 50, bottomY, 600, 20, this.enablePlay, () -> this.searchField.func_146179_b(), this.soundConfigList);
        this.field_230705_e_.add(this.soundConfigList);
        int controlMargin = (this.field_230708_k_ - 130) / 2;
        int controlHeight = this.field_230709_l_ - 15 - 20;
        this.save = new Button(controlMargin, controlHeight, 60, 20, SAVE, this::save);
        this.func_230480_a_((Widget)this.save);
        this.cancel = new Button(controlMargin + 60 + 10, controlHeight, 60, 20, CANCEL, this::cancel);
        this.func_230480_a_((Widget)this.cancel);
        this.func_212928_a((IGuiEventListener)this.searchField);
    }

    public void func_231023_e_() {
        this.searchField.func_146178_a();
        this.soundConfigList.tick();
    }

    public boolean func_231177_au__() {
        return true;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return super.func_231046_a_(keyCode, scanCode, modifiers) || this.searchField.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void func_231175_as__() {
        GameUtils.getMC().func_147108_a(this.parent);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        return this.searchField.func_231042_a_(codePoint, modifiers);
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        IndividualSoundControlListEntry entry;
        this.func_231165_f_(0);
        this.soundConfigList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.searchField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        IndividualSoundControlScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)10, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.soundConfigList.func_231047_b_(mouseX, mouseY) && (entry = this.soundConfigList.getEntryAt(mouseX, mouseY)) != null) {
            List<ITextComponent> toolTip = entry.getToolTip(mouseX, mouseY);
            this.renderWrappedToolTip(matrixStack, toolTip, mouseX, mouseY + 30, GameUtils.getMC().field_71466_p);
        }
    }

    protected void save(@Nonnull Button button) {
        this.soundConfigList.saveChanges();
        this.func_231164_f_();
        this.func_231175_as__();
    }

    protected void cancel(@Nonnull Button button) {
        this.func_231164_f_();
        this.func_231175_as__();
    }
}

