/*
 * Decompiled with CFR 0.152.
 */
package com.saomc;

import com.saomc.util.ColorUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class GLCore {
    private GLCore() {
    }

    public static Minecraft glMinecraft() {
        return Minecraft.func_71410_x();
    }

    public static FontRenderer glFont() {
        Minecraft mc = GLCore.glMinecraft();
        return mc != null ? mc.field_71466_p : null;
    }

    public static TextureManager glTextureManager() {
        Minecraft mc = GLCore.glMinecraft();
        return mc != null ? mc.func_110434_K() : null;
    }

    public static void glColor(float red, float green, float blue) {
        GL11.glColor3f((float)red, (float)green, (float)blue);
    }

    public static void glColor(float red, float green, float blue, float alpha) {
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glColorRGBA(ColorUtil color) {
        GLCore.glColorRGBA(color.rgba);
    }

    public static void glColorRGBA(int rgba) {
        float red = (float)(rgba >> 24 & 0xFF) / 255.0f;
        float green = (float)(rgba >> 16 & 0xFF) / 255.0f;
        float blue = (float)(rgba >> 8 & 0xFF) / 255.0f;
        float alpha = (float)(rgba & 0xFF) / 255.0f;
        GLCore.glColor(red, green, blue, alpha);
    }

    public static int glFontColor(int rgba) {
        int alpha = rgba & 0xFF;
        int red = rgba >> 24 & 0xFF;
        int blue = rgba >> 8 & 0xFF;
        int green = rgba >> 16 & 0xFF;
        return alpha << 24 | red << 16 | blue << 8 | green;
    }

    public static void glString(FontRenderer font, String string, int x, int y, int argb, boolean shadow) {
        if (font != null) {
            font.func_85187_a(string, x, y, GLCore.glFontColor(argb), shadow);
        }
    }

    public static void glString(FontRenderer font, String string, int x, int y, int argb) {
        GLCore.glString(font, string, x, y, argb, false);
    }

    public static void glString(String string, int x, int y, int argb, boolean shadow) {
        GLCore.glString(GLCore.glFont(), string, x, y, argb, shadow);
    }

    public static void glString(String string, int x, int y, int argb) {
        GLCore.glString(string, x, y, argb, false);
    }

    public static void setFont(Minecraft mc, boolean custom) {
        if (mc.field_71466_p == null) {
            return;
        }
        ResourceLocation fontLocation = custom ? new ResourceLocation("saoui", "textures/ascii.png") : new ResourceLocation("textures/font/ascii.png");
        GameSettings gs = mc.field_71474_y;
        mc.field_71466_p = new FontRenderer(gs, fontLocation, mc.func_110434_K(), false);
        if (gs.field_74363_ab != null) {
            mc.field_71466_p.func_78264_a(mc.func_152349_b());
            mc.field_71466_p.func_78275_b(mc.func_135016_M().func_135044_b());
        }
        ((IReloadableResourceManager)mc.func_110442_L()).func_110542_a((IResourceManagerReloadListener)mc.field_71466_p);
    }

    public static int glStringWidth(FontRenderer font, String string) {
        if (font != null) {
            return font.func_78256_a(string);
        }
        return 0;
    }

    public static int glStringWidth(String string) {
        return GLCore.glStringWidth(GLCore.glFont(), string);
    }

    public static int glStringHeight(FontRenderer font) {
        if (font != null) {
            return font.field_78288_b;
        }
        return 0;
    }

    public static int glStringHeight() {
        return GLCore.glStringHeight(GLCore.glFont());
    }

    public static void glBindTexture(TextureManager textureManager, ResourceLocation location) {
        if (textureManager != null) {
            textureManager.func_110577_a(location);
        }
    }

    public static void glBindTexture(ResourceLocation location) {
        GLCore.glBindTexture(GLCore.glTextureManager(), location);
    }

    public static void glTexturedRect(int x, int y, float z, double width, double height, double srcX, double srcY, double srcWidth, double srcHeight) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)y + height, (double)z, (double)((float)srcX * f), (double)((float)(srcY + srcHeight) * f1));
        tessellator.func_78374_a((double)x + width, (double)y + height, (double)z, (double)((float)(srcX + srcWidth) * f), (double)((float)(srcY + srcHeight) * f1));
        tessellator.func_78374_a((double)x + width, (double)y, (double)z, (double)((float)(srcX + srcWidth) * f), (double)((float)srcY * f1));
        tessellator.func_78374_a((double)x, (double)y, (double)z, (double)((float)srcX * f), (double)((float)srcY * f1));
        tessellator.func_78381_a();
    }

    public static void glTexturedRect(int x, int y, float z, int srcX, int srcY, int width, int height) {
        GLCore.glTexturedRect(x, y, z, width, height, srcX, srcY, width, height);
    }

    public static void glTexturedRect(int x, int y, int width, int height, int srcX, int srcY, int srcWidth, int srcHeight) {
        GLCore.glTexturedRect(x, y, 0.0f, width, height, srcX, srcY, srcWidth, srcHeight);
    }

    public static void glTexturedRect(int x, int y, int srcX, int srcY, int width, int height) {
        GLCore.glTexturedRect(x, y, 0.0f, srcX, srcY, width, height);
    }

    public static void addVertex(double x, double y, double z, double srcX, double srcY) {
        Tessellator.field_78398_a.func_78374_a(x, y, z, srcX, srcY);
    }

    public static void addVertexColor(float red, float green, float blue, float alpha) {
        Tessellator.field_78398_a.func_78369_a(red, green, blue, alpha);
    }

    public static void begin() {
        Tessellator.field_78398_a.func_78382_b();
    }

    public static void begin(int glMode) {
        Tessellator.field_78398_a.func_78371_b(glMode);
    }

    public static void draw() {
        Tessellator.field_78398_a.func_78381_a();
    }

    public static void glRect(int x, int y, int width, int height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x, (double)(y + height), 0.0);
        tessellator.func_78377_a((double)(x + width), (double)(y + height), 0.0);
        tessellator.func_78377_a((double)(x + width), (double)y, 0.0);
        tessellator.func_78377_a((double)x, (double)y, 0.0);
        tessellator.func_78381_a();
    }

    public static void glAlphaTest(boolean flag) {
        if (flag) {
            GL11.glEnable((int)3008);
        } else {
            GL11.glDisable((int)3008);
        }
    }

    public static void alphaFunc(int src, int dst) {
        GL11.glAlphaFunc((int)src, (float)dst);
    }

    public static void glBlend(boolean flag) {
        if (flag) {
            GL11.glEnable((int)3042);
        } else {
            GL11.glDisable((int)3042);
        }
    }

    public static void blendFunc(int src, int dst) {
        GL11.glBlendFunc((int)src, (int)dst);
    }

    public static void tryBlendFuncSeparate(int a, int b, int c, int d) {
        OpenGlHelper.func_148821_a((int)a, (int)b, (int)c, (int)d);
    }

    public static void depthMask(boolean flag) {
        GL11.glDepthMask((boolean)flag);
    }

    public static void glDepthTest(boolean flag) {
        if (flag) {
            GL11.glEnable((int)2929);
        } else {
            GL11.glDisable((int)2929);
        }
    }

    public static void glDepthFunc(int flag) {
        GL11.glDepthFunc((int)flag);
    }

    public static void glRescaleNormal(boolean flag) {
        if (flag) {
            GL11.glEnable((int)32826);
        } else {
            GL11.glDisable((int)32826);
        }
    }

    public static void glTexture2D(boolean flag) {
        if (flag) {
            GL11.glEnable((int)3553);
        } else {
            GL11.glDisable((int)3553);
        }
    }

    public static void glCullFace(boolean flag) {
        if (flag) {
            GL11.glEnable((int)2884);
        } else {
            GL11.glDisable((int)2884);
        }
    }

    public static void glTranslatef(float x, float y, float z) {
        GL11.glTranslatef((float)x, (float)y, (float)z);
    }

    public static void glNormal3f(float x, float y, float z) {
        GL11.glNormal3f((float)x, (float)y, (float)z);
    }

    public static void glRotatef(float angle, float x, float y, float z) {
        GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
    }

    public static void glScalef(float x, float y, float z) {
        GL11.glScalef((float)x, (float)y, (float)z);
    }

    public static void lighting(boolean flag) {
        if (flag) {
            GL11.glEnable((int)2896);
        } else {
            GL11.glDisable((int)2896);
        }
    }

    public static void glStartUI(Minecraft mc) {
        mc.field_71424_I.func_76320_a("saoui[ 'Sword Art Online UI' ]");
    }

    public static void glEndUI(Minecraft mc) {
        mc.field_71424_I.func_76319_b();
    }

    public static void start() {
        GL11.glPushMatrix();
    }

    public static void end() {
        GL11.glPopMatrix();
    }
}

