/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.colorstates;

import com.saomc.GLCore;
import com.saomc.social.StaticPlayerHelper;
import com.saomc.social.party.PartyHelper;
import com.saomc.util.OptionCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;

@SideOnly(value=Side.CLIENT)
public enum ColorState {
    INNOCENT(-1812709633),
    VIOLENT(-191168257),
    KILLER(-1124073217),
    BOSS(-1124073217),
    CREATIVE(1290651135),
    OP(-1),
    INVALID(-1953788929),
    GAMEMASTER(2031329023);

    private final int color;

    private ColorState(int argb) {
        this.color = argb;
    }

    public static ColorState getColorState(Minecraft mc, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return ColorState.getPlayerColorState(mc, (EntityPlayer)entity);
        }
        if (entity instanceof EntityLiving) {
            return ColorState.getState(mc, (EntityLiving)entity);
        }
        return INVALID;
    }

    private static ColorState getState(Minecraft mc, EntityLiving entity) {
        if (entity instanceof EntityWolf && ((EntityWolf)entity).func_70919_bu()) {
            return KILLER;
        }
        if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n()) {
            return ((EntityTameable)entity).func_70902_q() != mc.field_71439_g ? VIOLENT : INNOCENT;
        }
        if (entity instanceof IBossDisplayData) {
            return BOSS;
        }
        if (entity instanceof IMob) {
            return OptionCore.AGGRO_SYSTEM.getValue() ? VIOLENT : KILLER;
        }
        if (entity instanceof IAnimals) {
            return INNOCENT;
        }
        if (entity instanceof IEntityOwnable) {
            return VIOLENT;
        }
        return INVALID;
    }

    public static boolean checkValidState(Entity entity) {
        return entity instanceof IAnimals || entity instanceof EntityPlayer || entity instanceof IEntityOwnable;
    }

    private static ColorState getPlayerColorState(Minecraft mc, EntityPlayer player) {
        if (ColorState.isDev(StaticPlayerHelper.getName(player))) {
            return GAMEMASTER;
        }
        if (PartyHelper.instance().isMember(StaticPlayerHelper.getName(player))) {
            return CREATIVE;
        }
        return INNOCENT;
    }

    private static boolean isDev(String pl) {
        return Stream.of("_Bluexin_", "Blaez", "Felphor", "LordCruaver", "Tencao").anyMatch(name -> name.equals(pl));
    }

    public void glColor() {
        GLCore.glColorRGBA(this.color);
    }
}

