/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.colorstates;

import com.saomc.colorstates.ColorState;
import com.saomc.util.OptionCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

@SideOnly(value=Side.CLIENT)
public class ColorStateHandler {
    private static ColorStateHandler ref;
    ConcurrentMap<Class, ColorState> defaultStates = new ConcurrentHashMap<Class, ColorState>();
    ConcurrentMap<Integer, ColorState> colorStates = new ConcurrentHashMap<Integer, ColorState>();
    ConcurrentMap<UUID, ColorState> playerStates = new ConcurrentHashMap<UUID, ColorState>();
    ConcurrentMap<Integer, Integer> stateKeeper = new ConcurrentHashMap<Integer, Integer>();
    ConcurrentMap<UUID, Integer> playerKeeper = new ConcurrentHashMap<UUID, Integer>();

    private ColorStateHandler() {
    }

    @SideOnly(value=Side.CLIENT)
    public static synchronized ColorStateHandler getInstance() {
        if (ref == null) {
            ref = new ColorStateHandler();
        }
        return ref;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public synchronized ColorState getDefault(EntityLivingBase entity) {
        return (ColorState)((Object)this.defaultStates.get(entity.getClass()));
    }

    public synchronized boolean hasState(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return this.playerStates.get(entity.func_110124_au()) != null;
        }
        return this.colorStates.get(entity.func_145782_y()) != null;
    }

    public synchronized void remove(EntityLivingBase entity) {
        this.colorStates.remove(entity.func_145782_y());
        this.stateKeeper.remove(entity.func_145782_y());
    }

    public synchronized void remove(EntityPlayer entity) {
        this.playerStates.remove(entity.func_110124_au());
        this.playerKeeper.remove(entity.func_110124_au());
    }

    public synchronized boolean isEmpty() {
        return this.colorStates.isEmpty() && this.stateKeeper.isEmpty() && this.playerKeeper.isEmpty() && this.playerStates.isEmpty();
    }

    public void reset(int entity) {
        this.colorStates.remove(entity);
        this.stateKeeper.remove(entity);
    }

    public void reset(UUID entity) {
        this.playerStates.remove(entity);
        this.playerKeeper.remove(entity);
    }

    public void clean() {
        this.stateKeeper.clear();
        this.colorStates.clear();
        this.playerKeeper.clear();
        this.playerStates.clear();
        this.defaultStates.clear();
    }

    public synchronized void stateColor(EntityLivingBase entity) {
        if (!OptionCore.AGGRO_SYSTEM.getValue()) {
            ((ColorState)((Object)this.defaultStates.get(entity.getClass()))).glColor();
        }
        if (entity instanceof EntityPlayer) {
            if (this.playerStates.get(entity.func_110124_au()) != null) {
                ColorState state = (ColorState)((Object)this.playerStates.get(entity.func_110124_au()));
                state.glColor();
            } else if (this.defaultStates.get(entity.getClass()) != null) {
                ColorState state = (ColorState)((Object)this.defaultStates.get(entity.getClass()));
                state.glColor();
            } else {
                this.genDefaultState(entity);
            }
        } else if (this.colorStates.get(entity.func_145782_y()) != null) {
            ColorState state = (ColorState)((Object)this.colorStates.get(entity.func_145782_y()));
            state.glColor();
        } else if (this.defaultStates.get(entity.getClass()) != null) {
            ColorState state = (ColorState)((Object)this.defaultStates.get(entity.getClass()));
            state.glColor();
        } else {
            this.genDefaultState(entity);
        }
    }

    public synchronized void set(EntityLivingBase entity, ColorState newState, boolean event) {
        ColorState defaultState = (ColorState)((Object)this.defaultStates.get(entity.getClass()));
        if (!event) {
            if (this.defaultStates.get(entity.getClass()) != null) {
                this.defaultStates.replace(entity.getClass(), defaultState, newState);
                if (OptionCore.DEBUG_MODE.getValue()) {
                    System.out.print("WARNING - DEFAULT STATE WAS CHANGED\n");
                }
            } else {
                this.defaultStates.putIfAbsent(entity.getClass(), newState);
                if (OptionCore.DEBUG_MODE.getValue()) {
                    System.out.print("WARNING - DEFAULT STATE WAS CHANGED\n");
                }
            }
        } else if (!(entity instanceof EntityPlayer)) {
            this.stateKeeper.put(entity.func_145782_y(), 1200);
            this.colorStates.put(entity.func_145782_y(), newState);
        } else {
            this.playerKeeper.put(entity.func_110124_au(), 12000);
            this.playerStates.replace(entity.func_110124_au(), newState);
        }
    }

    public synchronized void genDefaultState(EntityLivingBase entity) {
        if (this.getDefault(entity) == null) {
            Minecraft mc = Minecraft.func_71410_x();
            ColorState state = ColorState.getColorState(mc, entity);
            this.defaultStates.put(entity.getClass(), state);
            if (entity instanceof EntityPlayer) {
                this.playerStates.putIfAbsent(entity.func_110124_au(), state);
                if (OptionCore.DEBUG_MODE.getValue() && OptionCore.DEBUG_MODE.getValue()) {
                    System.out.print(entity.func_70005_c_() + " added to map\n");
                }
            } else {
                this.colorStates.putIfAbsent(entity.func_145782_y(), state);
                if (OptionCore.DEBUG_MODE.getValue() && OptionCore.DEBUG_MODE.getValue()) {
                    System.out.print(entity.func_70005_c_() + " added to map\n");
                }
            }
        }
    }

    public synchronized ColorState getSavedState(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            if (this.playerKeeper.get(entity.func_110124_au()) != null) {
                return (ColorState)((Object)this.playerStates.get(entity.func_110124_au()));
            }
            return (ColorState)((Object)this.defaultStates.get(entity.getClass()));
        }
        if (this.stateKeeper.get(entity.func_145782_y()) != null) {
            return (ColorState)((Object)this.colorStates.get(entity.func_145782_y()));
        }
        return (ColorState)((Object)this.defaultStates.get(entity.getClass()));
    }

    public synchronized void updateKeeper() {
        if (!OptionCore.AGGRO_SYSTEM.getValue()) {
            this.clean();
        }
        if (!this.stateKeeper.isEmpty()) {
            this.stateKeeper.forEach((uuid, ticks) -> {
                if ((ticks = Integer.valueOf(ticks - 1)) == 0) {
                    this.reset((int)uuid);
                } else {
                    this.stateKeeper.put((Integer)uuid, (Integer)ticks);
                }
            });
        }
        if (!this.playerKeeper.isEmpty()) {
            this.playerKeeper.forEach((uuid, ticks) -> {
                if ((ticks = Integer.valueOf(ticks - 1)) == 0) {
                    this.reset((UUID)uuid);
                } else {
                    this.playerKeeper.put((UUID)uuid, (Integer)ticks);
                }
            });
        }
    }
}

