/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.commands;

import com.saomc.commands.CommandType;
import com.saomc.social.StaticPlayerHelper;
import com.saomc.util.OptionCore;
import java.util.Arrays;
import java.util.MissingFormatArgumentException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;

public class Command {
    private final CommandType type;
    private final String from;
    private final String to;
    private final String[] args;

    private Command(String raw) {
        if (!raw.contains("$")) {
            throw new MissingFormatArgumentException("<username> not found in \"" + raw + '\"');
        }
        if (!raw.contains("[SAOUI ") || !raw.contains("]")) {
            throw new MissingFormatArgumentException("invalid command: \"" + raw + '\"');
        }
        this.from = raw.substring(raw.indexOf(36) + 1, raw.lastIndexOf(36));
        this.type = CommandType.getCommand(raw);
        this.to = StaticPlayerHelper.getName(Minecraft.func_71410_x());
        this.args = Command.getContent(raw);
    }

    public Command(CommandType type, String to, String ... args) {
        this.type = type;
        this.to = to;
        this.from = StaticPlayerHelper.getName(Minecraft.func_71410_x());
        this.args = args;
    }

    public static boolean processCommand(String raw) {
        if (Minecraft.func_71410_x().field_71439_g == null || !OptionCore.CLIENT_CHAT_PACKETS.getValue()) {
            return false;
        }
        if (raw.contains("[SAOUI ") && raw.contains("]")) {
            Command command;
            try {
                command = new Command(raw);
            }
            catch (MissingFormatArgumentException e) {
                return false;
            }
            if (command.type != null) {
                if (!command.from.equals(StaticPlayerHelper.getName(Minecraft.func_71410_x()))) {
                    command.activate();
                }
                return true;
            }
        }
        return false;
    }

    public static String[] getContent(String data) {
        return !data.contains("{[") || !data.contains("]}") ? null : data.substring(data.indexOf("{[") + 2, data.indexOf("]}")).split(", ");
    }

    public CommandType getType() {
        return this.type;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String toChat() {
        String format = I18n.func_135052_a((String)"commands.message.usage", (Object[])new Object[0]);
        String cmd = format.substring(0, format.indexOf(32));
        String args = this.args != null ? Arrays.toString(this.args) : "[]";
        return cmd + ' ' + this.to + ' ' + this.type.toString() + " $" + this.from + "$ {" + args + '}';
    }

    public void send(Minecraft mc) {
        if (mc.field_71439_g == null || !OptionCore.CLIENT_CHAT_PACKETS.getValue()) {
            return;
        }
        mc.field_71439_g.func_71165_d(this.toChat());
    }

    private void activate() {
        this.type.action(Minecraft.func_71410_x(), this.from, this.args);
    }
}

