/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.commands;

import com.saomc.events.FriendsHandler;
import com.saomc.social.party.PartyHelper;
import com.saomc.util.TriConsumer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

@SideOnly(value=Side.CLIENT)
public enum CommandType {
    INVITE_TO_PARTY((mc, username, args) -> PartyHelper.instance().receiveInvite((Minecraft)mc, (String)username, (String)args)),
    DISSOLVE_PARTY((mc, username, args) -> PartyHelper.instance().receiveDissolve((Minecraft)mc, (String)username)),
    UPDATE_PARTY((mc, username, args) -> PartyHelper.instance().receiveUpdate((Minecraft)mc, (String)username, (String[])args)),
    CONFIRM_INVITE_PARTY((mc, username, args) -> PartyHelper.instance().receiveConfirmation((Minecraft)mc, (String)username, (String)args)),
    CANCEL_INVITE_PARTY((mc, username, args) -> mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"ptDecline", (Object[])new Object[]{username})))),
    ADD_FRIEND_REQUEST((mc, username, args) -> FriendsHandler.instance().addFriendRequest((Minecraft)mc, (String)username)),
    ACCEPT_ADD_FRIEND((mc, username, args) -> FriendsHandler.instance().acceptAddFriend((String)username)),
    CANCEL_ADD_FRIEND((mc, username, args) -> FriendsHandler.instance().cancelAddFriend((String)username));

    public static final String PREFIX = "[SAOUI ";
    public static final String SUFFIX = "]";
    private final TriConsumer<Minecraft, String, String[]> action;

    private CommandType(TriConsumer<Minecraft, String, String[]> action) {
        this.action = action;
    }

    static CommandType getCommand(String id) {
        return Stream.of(CommandType.values()).filter(t -> id.contains(t.name())).findAny().orElse(null);
    }

    public final String toString() {
        return PREFIX + this.name() + SUFFIX;
    }

    public final String key() {
        return "saouiCommand" + this.name().replace("_", "");
    }

    public void action(Minecraft mc, String username, String[] args) {
        this.action.accept(mc, username, args);
    }
}

