/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.effects;

import com.saomc.GLCore;
import com.saomc.effects.RenderDispatcher;
import com.saomc.resources.StringNames;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class DeathParticles
extends EntityFX {
    public static Queue<DeathParticles> queuedRenders = new ArrayDeque<DeathParticles>();
    float ParticleScale;
    float time;
    float particleX;
    float particleY;
    float particleZ;
    float f0;
    float f1;
    float rotationY;
    float speedRotationY;

    public DeathParticles(World world, double xCoord, double yCoord, double zCoord, float redValue, float greenValue, float blueValue) {
        this(world, xCoord, yCoord, zCoord, redValue, greenValue, blueValue, 1.0f);
    }

    private DeathParticles(World world, double xCoord, double yCoord, double zCoord, float redValue, float greenValue, float blueVale, float scale) {
        super(world, xCoord, yCoord, zCoord, 0.0, 0.0, 0.0);
        this.field_70159_w = (float)(Math.random() * 2.0 - 1.0) * 0.05f;
        this.field_70181_x = (float)(Math.random() * 2.0 - 1.0) * 0.05f;
        this.field_70179_y = (float)(Math.random() * 2.0 - 1.0) * 0.05f;
        this.rotationY = this.field_70146_Z.nextFloat() * 2.0f;
        this.speedRotationY = (this.field_70146_Z.nextFloat() + 2.0f) / (this.field_70146_Z.nextBoolean() ? 16.0f : -16.0f);
        this.field_70552_h = redValue;
        this.field_70553_i = greenValue;
        this.field_70551_j = blueVale;
        this.field_70544_f *= scale;
        this.ParticleScale = this.field_70544_f;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.field_70547_e = (int)((float)this.field_70547_e * scale);
        this.field_70145_X = false;
    }

    public void func_70539_a(Tessellator tessellator, float time, float x, float y, float z, float f0, float f1) {
        this.time = time;
        this.particleX = x;
        this.particleY = y;
        this.particleZ = z;
        this.f0 = f0;
        this.f1 = f1;
        queuedRenders.add(this);
    }

    public static void dispatchQueuedRenders(Tessellator tessellator) {
        RenderDispatcher.particleFxCount = 0;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(StringNames.particleLarge);
        GLCore.begin();
        queuedRenders.forEach(p -> p.renderQueued(tessellator));
        GLCore.draw();
        queuedRenders.clear();
    }

    private void renderQueued(Tessellator tessellator) {
        boolean q;
        float particle = ((float)this.field_70546_d + this.time) / (float)this.field_70547_e * 32.0f;
        if (particle < 0.0f) {
            particle = 0.0f;
        }
        if (particle > 1.0f) {
            particle = 1.0f;
        }
        this.field_70544_f = this.ParticleScale * particle;
        float scale = 0.1f * this.field_70544_f;
        float xPos = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)this.time - field_70556_an);
        float yPos = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)this.time - field_70554_ao);
        float zPos = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)this.time - field_70555_ap);
        float colorIntensity = 1.0f;
        GLCore.addVertexColor(this.field_70552_h * colorIntensity, this.field_70553_i * colorIntensity, this.field_70551_j * colorIntensity, 1.0f);
        double x1 = -(this.particleX + this.f0) * scale;
        double y1 = -this.particleY * scale;
        double z1 = -(this.particleZ + this.f1) * scale;
        double x2 = (this.f0 - this.particleX) * scale;
        double y2 = this.particleY * scale;
        double z2 = (this.f1 - this.particleZ) * scale;
        double x3 = (this.particleX + this.f0) * scale;
        double y3 = this.particleY * scale;
        double z3 = (this.particleZ + this.f1) * scale;
        double x4 = (this.particleX - this.f0) * scale;
        double y4 = -this.particleY * scale;
        double z4 = (this.particleZ - this.f1) * scale;
        ForgeDirection e = ForgeDirection.getOrientation((int)(MathHelper.func_76128_c((double)((double)(Minecraft.func_71410_x().field_71439_g.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3));
        boolean bl = q = e.equals((Object)ForgeDirection.NORTH) || e.equals((Object)ForgeDirection.SOUTH);
        double a = (double)(q ? (this.rotationY < 1.5f && this.rotationY > 0.5f ? this.rotationY - 1.0f : this.rotationY + 1.0f) : this.rotationY) * Math.PI;
        double cos = Math.cos(a);
        double sin = Math.sin(a);
        if (a < Math.PI) {
            GLCore.addVertex((double)xPos + x1 * cos, (double)yPos + y1, (double)zPos + z1 * sin, 0.0, 1.0);
            GLCore.addVertex((double)xPos + x2 * cos, (double)yPos + y2, (double)zPos + z2 * sin, 1.0, 1.0);
            GLCore.addVertex((double)xPos + x3 * cos, (double)yPos + y3, (double)zPos + z3 * sin, 1.0, 0.0);
            GLCore.addVertex((double)xPos + x4 * cos, (double)yPos + y4, (double)zPos + z4 * sin, 0.0, 0.0);
        } else {
            GLCore.addVertex((double)xPos - x1 * cos, (double)yPos + y1, (double)zPos - z1 * sin, 0.0, 0.0);
            GLCore.addVertex((double)xPos - x2 * cos, (double)yPos + y2, (double)zPos - z2 * sin, 1.0, 0.0);
            GLCore.addVertex((double)xPos - x3 * cos, (double)yPos + y3, (double)zPos - z3 * sin, 1.0, 1.0);
            GLCore.addVertex((double)xPos - x4 * cos, (double)yPos + y4, (double)zPos - z4 * sin, 0.0, 1.0);
        }
    }

    public void func_110125_a(IIcon p_110125_1_) {
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
        this.field_70181_x += 0.004;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.9f;
        this.field_70181_x *= (double)0.9f;
        this.field_70179_y *= (double)0.9f;
        this.rotationY += this.speedRotationY;
        this.rotationY %= 2.0f;
        if (this.field_70122_E) {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
        }
    }
}

