/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.events;

import com.saomc.resources.StringNames;
import com.saomc.util.OptionCore;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.stream.Stream;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static String _PARTY_DISSOLVING_TITLE;
    public static String _PARTY_DISSOLVING_TEXT;
    public static String _PARTY_LEAVING_TITLE;
    public static String _PARTY_LEAVING_TEXT;
    public static String _MESSAGE_TITLE;
    public static String _MESSAGE_FROM;
    public static String _FRIEND_REQUEST_TITLE;
    public static String _FRIEND_REQUEST_TEXT;
    public static String _PARTY_INVITATION_TITLE;
    public static String _PARTY_INVITATION_TEXT;
    public static String _DEAD_ALERT;
    public static String _LAST_UPDATE;
    public static boolean _IGNORE_UPATE;
    public static boolean DEBUG;
    private static Configuration config;

    public static void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        DEBUG = config.get("general", "debug", DEBUG).getBoolean();
        _FRIEND_REQUEST_TITLE = config.get("general", "friend.request.title", StringNames.FRIEND_REQUEST_TITLE).getString();
        _FRIEND_REQUEST_TEXT = config.get("general", "friend.request.text", "guiFriendRequestText").getString();
        _PARTY_INVITATION_TITLE = config.get("general", "party.invitation.title", StringNames.PARTY_INVITATION_TITLE).getString();
        _PARTY_INVITATION_TEXT = config.get("general", "party.invitation.text", "guiPartyInviteText").getString();
        _PARTY_DISSOLVING_TITLE = config.get("general", "party.dissolving.title", StringNames.PARTY_DISSOLVING_TITLE).getString();
        _PARTY_DISSOLVING_TEXT = config.get("general", "party.dissolving.text", StringNames.PARTY_DISSOLVING_TEXT).getString();
        _PARTY_LEAVING_TITLE = config.get("general", "party.leaving.title", StringNames.PARTY_LEAVING_TITLE).getString();
        _PARTY_LEAVING_TEXT = config.get("general", "party.leaving.text", StringNames.PARTY_LEAVING_TEXT).getString();
        _MESSAGE_TITLE = config.get("general", "message.title", StringNames.MESSAGE_TITLE).getString();
        _MESSAGE_FROM = config.get("general", "message.from", "guiMessageFrom").getString();
        _DEAD_ALERT = config.get("general", "dead.alert", StringNames.DEAD_ALERT).getString();
        _LAST_UPDATE = config.get("general", "last.update", "nothing").getString();
        _IGNORE_UPATE = config.get("general", "ignore.update", false).getBoolean();
        Stream.of(OptionCore.values()).forEach(option -> {
            if (config.get("general", "option." + option.name().toLowerCase(), option.getValue()).getBoolean()) {
                option.enable();
            } else {
                option.disable();
            }
        });
        config.save();
    }

    public static void setOption(OptionCore option) {
        config.get("general", "option." + option.name().toLowerCase(), option.getValue()).set(option.getValue());
        ConfigHandler.saveAllOptions();
    }

    private static void saveAllOptions() {
        config.save();
    }

    public static void saveVersion(String version) {
        config.get("general", "last.update", ConfigHandler.getLastVersion()).set(version);
        config.save();
    }

    public static void setIgnoreVersion(boolean value) {
        config.get("general", "ignore.update", ConfigHandler.ignoreVersion()).set(value);
        config.save();
    }

    public static String getLastVersion() {
        return _LAST_UPDATE;
    }

    public static boolean ignoreVersion() {
        return _IGNORE_UPATE;
    }

    static {
        DEBUG = false;
    }
}

