/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.events;

import com.saomc.commands.Command;
import com.saomc.commands.CommandType;
import com.saomc.events.ConfigHandler;
import com.saomc.screens.menu.Categories;
import com.saomc.screens.window.WindowView;
import com.saomc.social.StaticPlayerHelper;
import com.saomc.social.friends.FriendRequest;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;

public class FriendsHandler {
    private static FriendsHandler instance;
    private final File friendsFile;
    private final List<FriendRequest> friendRequests = new ArrayList<FriendRequest>();
    private String[] friends;

    private FriendsHandler(FMLPreInitializationEvent event) {
        this.friendsFile = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath() + "/saouifriends");
        if (!this.friendsFile.exists()) {
            this.writeFriends(this.friends);
        }
        this.friends = this.loadFriends();
    }

    public static FriendsHandler instance() {
        return instance;
    }

    public static void preInit(FMLPreInitializationEvent event) {
        instance = new FriendsHandler(event);
    }

    public String[] loadFriends() {
        try {
            String[] friends;
            FileInputStream stream = new FileInputStream(this.friendsFile);
            if (stream.available() != 0) {
                int count = stream.read() & 0xFF;
                friends = new String[count];
                for (int i = 0; i < count; ++i) {
                    int length = stream.read() & 0xFF;
                    byte[] bytes = new byte[length];
                    stream.read(bytes, 0, length);
                    friends[i] = new String(bytes);
                }
            } else {
                friends = new String[]{};
            }
            stream.close();
            return friends;
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    public String[] listFriends() {
        if (this.friends == null) {
            this.friends = this.loadFriends();
        }
        return this.friends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFriendRequests(Minecraft mc, String ... names) {
        List<FriendRequest> list = this.friendRequests;
        synchronized (list) {
            for (String name : names) {
                if (this.friendRequests.contains(new FriendRequest(name, 10000)) || this.isFriend(name)) continue;
                this.friendRequests.add(new FriendRequest(name, 10000));
                new Command(CommandType.ADD_FRIEND_REQUEST, name, new String[0]).send(mc);
            }
        }
    }

    public boolean addFriends(String ... names) {
        this.friends = this.listFriends();
        ArrayList newNames = new ArrayList();
        Stream.of(names).forEach(name -> {
            if (Stream.of(this.friends).noneMatch(friend -> friend.equals(name))) {
                newNames.add(name);
            }
        });
        String[] bb = new String[newNames.size()];
        System.arraycopy(newNames.toArray(), 0, bb, 0, bb.length);
        return newNames.size() <= 0 || this.addRawFriends(bb);
    }

    public boolean isFriend(String name) {
        return Stream.of(this.listFriends()).anyMatch(friend -> friend.equals(name));
    }

    public boolean isFriend(EntityPlayer player) {
        return this.isFriend(StaticPlayerHelper.getName(player));
    }

    public boolean addRawFriends(String[] names) {
        this.friends = this.listFriends();
        String[] resized = new String[this.friends.length + names.length];
        System.arraycopy(this.friends, 0, resized, 0, this.friends.length);
        System.arraycopy(names, 0, resized, this.friends.length, names.length);
        if (this.writeFriends(resized)) {
            this.friends = resized;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeFriends(String[] friends) {
        String[] data = friends == null ? new String[]{} : friends;
        File file = this.friendsFile;
        synchronized (file) {
            try (FileOutputStream stream = new FileOutputStream(this.friendsFile);){
                int count = data.length % 256;
                stream.write(count);
                for (int i = 0; i < count; ++i) {
                    byte[] bytes = data[i].getBytes();
                    int length = bytes.length % 256;
                    stream.write(length);
                    stream.write(bytes, 0, length);
                }
                stream.flush();
                stream.close();
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                if (ConfigHandler.DEBUG) {
                    e.printStackTrace();
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptAddFriend(String username) {
        List<FriendRequest> list = this.friendRequests;
        synchronized (list) {
            int index = -1;
            for (int i = 0; i < this.friendRequests.size(); ++i) {
                if (!this.friendRequests.get(i).equals(username)) continue;
                index = i;
                break;
            }
            if (index >= 0 && (this.isFriend(username) || this.addFriends(username))) {
                this.friendRequests.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAddFriend(String username) {
        List<FriendRequest> list = this.friendRequests;
        synchronized (list) {
            int index = -1;
            for (int i = 0; i < this.friendRequests.size(); ++i) {
                if (!this.friendRequests.get(i).equals(username)) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                this.friendRequests.remove(index);
            }
        }
    }

    public void addFriendRequest(Minecraft mc, String username) {
        if (!FriendsHandler.instance().isFriend(username)) {
            GuiScreen keepScreen = mc.field_71462_r;
            boolean ingameFocus = mc.field_71415_G;
            String text = StatCollector.func_74837_a((String)ConfigHandler._FRIEND_REQUEST_TEXT, (Object[])new Object[]{username});
            mc.func_147108_a((GuiScreen)WindowView.viewConfirm(ConfigHandler._FRIEND_REQUEST_TITLE, text, (element, action, data) -> {
                Categories id = element.ID();
                if (id == Categories.CONFIRM && (FriendsHandler.instance().isFriend(username) || FriendsHandler.instance().addFriends(username))) {
                    new Command(CommandType.ACCEPT_ADD_FRIEND, username, new String[0]).send(mc);
                } else {
                    new Command(CommandType.CANCEL_ADD_FRIEND, username, new String[0]).send(mc);
                }
                mc.func_147108_a(keepScreen);
                if (ingameFocus) {
                    mc.func_71381_h();
                } else {
                    mc.func_71364_i();
                }
            }));
            if (ingameFocus) {
                mc.func_71364_i();
            }
        } else {
            new Command(CommandType.ACCEPT_ADD_FRIEND, username, new String[0]).send(mc);
        }
    }
}

