/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.renders;

import com.saomc.GLCore;
import com.saomc.colorstates.ColorState;
import com.saomc.effects.DeathParticles;
import com.saomc.events.StateEventHandler;
import com.saomc.resources.StringNames;
import com.saomc.screens.ingame.HealthStep;
import com.saomc.screens.window.ui.CharacterView;
import com.saomc.social.StaticPlayerHelper;
import com.saomc.util.OptionCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class StaticRenderer {
    private static final int HEALTH_COUNT = 32;
    private static final double HEALTH_ANGLE = (double)0.35f;
    private static final double HEALTH_RANGE = (double)0.975f;
    private static final float HEALTH_OFFSET = 0.75f;
    private static final double HEALTH_HEIGHT = (double)0.21f;

    public static void render(RenderManager renderManager, EntityLivingBase living, double x, double y, double z) {
        boolean dead;
        Minecraft mc = Minecraft.func_71410_x();
        boolean bl = dead = StaticPlayerHelper.getHealth(mc, (Entity)living, -1.0f) <= 0.0f;
        if (living.field_70725_aQ == 1) {
            ++living.field_70725_aQ;
        }
        if (!(CharacterView.IS_VIEWING || dead || living.func_98034_c((EntityPlayer)mc.field_71439_g))) {
            if (OptionCore.COLOR_CURSOR.getValue()) {
                if (!OptionCore.DEBUG_MODE.getValue() || !ColorState.checkValidState((Entity)living)) {
                    StaticRenderer.doRenderColorCursor(renderManager, mc, living, x, y, z, 64);
                } else if (OptionCore.DEBUG_MODE.getValue()) {
                    StaticRenderer.doRenderColorCursor(renderManager, mc, living, x, y, z, 64);
                }
            }
            if (OptionCore.HEALTH_BARS.getValue() && !living.equals((Object)mc.field_71439_g)) {
                if (!OptionCore.DEBUG_MODE.getValue() || !ColorState.checkValidState((Entity)living)) {
                    StaticRenderer.doRenderHealthBar(renderManager, mc, living, x, y, z);
                } else if (OptionCore.DEBUG_MODE.getValue()) {
                    StaticRenderer.doRenderHealthBar(renderManager, mc, living, x, y, z);
                }
            }
        }
    }

    public static void doRenderColorCursor(RenderManager renderManager, Minecraft mc, EntityLivingBase living, double x, double y, double z, int distance) {
        double d3;
        if (living.field_70153_n != null) {
            return;
        }
        if (OptionCore.LESS_VISUALS.getValue() && !(living instanceof IMob) && StaticPlayerHelper.getHealth(mc, (Entity)living, -1.0f) == StaticPlayerHelper.getMaxHealth((Entity)living)) {
            return;
        }
        if (living.field_70170_p.field_72995_K && (d3 = living.func_70068_e((Entity)renderManager.field_78734_h)) <= (double)(distance * distance)) {
            float sizeMult = living.func_70631_g_() && living instanceof EntityMob ? 0.5f : 1.0f;
            float f = 1.6f;
            float f1 = 0.016666668f * f;
            GLCore.start();
            GLCore.glTranslatef((float)x + 0.0f, (float)y + sizeMult * living.field_70131_O + sizeMult * 1.1f, (float)z);
            GLCore.glNormal3f(0.0f, 1.0f, 0.0f);
            GLCore.glRotatef(-renderManager.field_78735_i, 0.0f, 1.0f, 0.0f);
            GLCore.glScalef(-(f1 * sizeMult), -(f1 * sizeMult), f1 * sizeMult);
            GLCore.lighting(false);
            GLCore.glDepthTest(true);
            GLCore.glAlphaTest(true);
            GLCore.glBlend(true);
            GLCore.tryBlendFuncSeparate(770, 771, 1, 0);
            GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.entities : StringNames.entitiesCustom);
            StateEventHandler.getColor(living);
            GLCore.begin();
            if (OptionCore.SPINNING_CRYSTALS.getValue()) {
                double a = (double)(living.field_70170_p.func_82737_E() % 40L) / 20.0 * Math.PI;
                double cos = Math.cos(a);
                double sin = Math.sin(a);
                if (a > 1.5707963267948966 && a <= 4.71238898038469) {
                    GLCore.addVertex(9.0 * cos, -1.0, 9.0 * sin, 0.125, 0.25);
                    GLCore.addVertex(9.0 * cos, 17.0, 9.0 * sin, 0.125, 0.375);
                    GLCore.addVertex(-9.0 * cos, 17.0, -9.0 * sin, 0.0, 0.375);
                    GLCore.addVertex(-9.0 * cos, -1.0, -9.0 * sin, 0.0, 0.25);
                } else {
                    GLCore.addVertex(-9.0 * cos, -1.0, -9.0 * sin, 0.0, 0.25);
                    GLCore.addVertex(-9.0 * cos, 17.0, -9.0 * sin, 0.0, 0.375);
                    GLCore.addVertex(9.0 * cos, 17.0, 9.0 * sin, 0.125, 0.375);
                    GLCore.addVertex(9.0 * cos, -1.0, 9.0 * sin, 0.125, 0.25);
                }
                if (a < Math.PI) {
                    GLCore.addVertex(-9.0 * sin, -1.0, 9.0 * cos, 0.125, 0.25);
                    GLCore.addVertex(-9.0 * sin, 17.0, 9.0 * cos, 0.125, 0.375);
                    GLCore.addVertex(9.0 * sin, 17.0, -9.0 * cos, 0.0, 0.375);
                    GLCore.addVertex(9.0 * sin, -1.0, -9.0 * cos, 0.0, 0.25);
                } else {
                    GLCore.addVertex(9.0 * sin, -1.0, -9.0 * cos, 0.0, 0.25);
                    GLCore.addVertex(9.0 * sin, 17.0, -9.0 * cos, 0.0, 0.375);
                    GLCore.addVertex(-9.0 * sin, 17.0, 9.0 * cos, 0.125, 0.375);
                    GLCore.addVertex(-9.0 * sin, -1.0, 9.0 * cos, 0.125, 0.25);
                }
                GLCore.draw();
            } else {
                GLCore.addVertex(-9.0, -1.0, 0.0, 0.0, 0.25);
                GLCore.addVertex(-9.0, 17.0, 0.0, 0.0, 0.375);
                GLCore.addVertex(9.0, 17.0, 0.0, 0.125, 0.375);
                GLCore.addVertex(9.0, -1.0, 0.0, 0.125, 0.25);
                GLCore.draw();
            }
            GLCore.lighting(true);
            GLCore.end();
        }
    }

    private static void doRenderHealthBar(RenderManager renderManager, Minecraft mc, EntityLivingBase living, double x, double y, double z) {
        if (living.field_70153_n != null && living.field_70153_n == mc.field_71439_g) {
            return;
        }
        if (OptionCore.LESS_VISUALS.getValue() && !(living instanceof IMob) && StaticPlayerHelper.getHealth(mc, (Entity)living, -1.0f) == StaticPlayerHelper.getMaxHealth((Entity)living)) {
            return;
        }
        GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.entities : StringNames.entitiesCustom);
        GLCore.start();
        GLCore.glDepthTest(true);
        GLCore.glCullFace(false);
        GLCore.glBlend(true);
        GLCore.blendFunc(770, 771);
        int hitPoints = (int)(StaticRenderer.getHealthFactor(mc, (Entity)living, -1.0f) * 32.0f);
        StaticRenderer.useColor(mc, (Entity)living, -1.0f);
        if (living instanceof IBossDisplayData) {
            double z0;
            double y0;
            double x0;
            double rad;
            double value;
            int i;
            GLCore.begin(5);
            float sizeMult = living.func_70631_g_() && living instanceof EntityMob ? 0.5f : 1.0f;
            for (i = 0; i <= hitPoints; ++i) {
                value = (double)(i + 32 - hitPoints) / 32.0;
                rad = Math.toRadians(renderManager.field_78735_i - 135.0f) + (value - 0.5) * Math.PI * (double)0.35f;
                x0 = x + (double)(sizeMult * living.field_70130_N) * (double)0.975f * Math.cos(rad);
                y0 = y + (double)(sizeMult * living.field_70131_O * 0.75f);
                z0 = z + (double)(sizeMult * living.field_70130_N) * (double)0.975f * Math.sin(rad);
                double uv_value = value - (double)(32 - hitPoints) / 32.0;
                GLCore.addVertex(x0, y0 + (double)0.21f, z0, 1.0 - uv_value, 0.0);
                GLCore.addVertex(x0, y0, z0, 1.0 - uv_value, 0.125);
            }
            GLCore.draw();
            GLCore.glColor(1.0f, 1.0f, 1.0f, 1.0f);
            GLCore.begin(5);
            for (i = 0; i <= 32; ++i) {
                value = (double)i / 32.0;
                rad = Math.toRadians(renderManager.field_78735_i - 135.0f) + (value - 0.5) * Math.PI * (double)0.35f;
                x0 = x + (double)(sizeMult * living.field_70130_N) * (double)0.975f * Math.cos(rad);
                y0 = y + (double)(sizeMult * living.field_70131_O * 0.75f);
                z0 = z + (double)(sizeMult * living.field_70130_N) * (double)0.975f * Math.sin(rad);
                GLCore.addVertex(x0, y0 + (double)0.21f, z0, 1.0 - value, 0.125);
                GLCore.addVertex(x0, y0, z0, 1.0 - value, 0.25);
            }
            GLCore.draw();
        } else {
            double z0;
            double y0;
            double x0;
            double rad;
            double value;
            int i;
            GLCore.begin(5);
            float sizeMult = living.func_70631_g_() && living instanceof IAnimals ? 0.5f : 1.0f;
            for (i = 0; i <= hitPoints; ++i) {
                value = (double)(i + 32 - hitPoints) / 32.0;
                rad = Math.toRadians(renderManager.field_78735_i - 135.0f) + (value - 0.5) * Math.PI * (double)0.35f;
                x0 = x + (double)(sizeMult * living.field_70130_N) * (double)0.975f * Math.cos(rad);
                y0 = y + (double)(sizeMult * living.field_70131_O * 0.75f);
                z0 = z + (double)(sizeMult * living.field_70130_N) * (double)0.975f * Math.sin(rad);
                double uv_value = value - (double)(32 - hitPoints) / 32.0;
                GLCore.addVertex(x0, y0 + (double)0.21f, z0, 1.0 - uv_value, 0.0);
                GLCore.addVertex(x0, y0, z0, 1.0 - uv_value, 0.125);
            }
            GLCore.draw();
            GLCore.glColor(1.0f, 1.0f, 1.0f, 1.0f);
            GLCore.begin(5);
            for (i = 0; i <= 32; ++i) {
                value = (double)i / 32.0;
                rad = Math.toRadians(renderManager.field_78735_i - 135.0f) + (value - 0.5) * Math.PI * (double)0.35f;
                x0 = x + (double)(sizeMult * living.field_70130_N) * (double)0.975f * Math.cos(rad);
                y0 = y + (double)(sizeMult * living.field_70131_O * 0.75f);
                z0 = z + (double)(sizeMult * living.field_70130_N) * (double)0.975f * Math.sin(rad);
                GLCore.addVertex(x0, y0 + (double)0.21f, z0, 1.0 - value, 0.125);
                GLCore.addVertex(x0, y0, z0, 1.0 - value, 0.25);
            }
            GLCore.draw();
        }
        GLCore.glCullFace(true);
        GLCore.end();
    }

    public static void doSpawnDeathParticles(Minecraft mc, Entity living) {
        World world = living.field_70170_p;
        if (living.field_70170_p.field_72995_K) {
            float[][] colors = new float[][]{{0.6039216f, 0.9960785f, 0.18039216f}, {0.003921569f, 1.0f, 1.0f}, {0.03137255f, 0.03137255f, 0.5411765f}};
            float size = living.field_70130_N * living.field_70131_O;
            int pieces = (int)Math.max(Math.min(size * 64.0f, 128.0f), 8.0f);
            for (int i = 0; i < pieces; ++i) {
                float[] color = colors[i % 3];
                double x0 = (double)living.field_70130_N * (Math.random() * 2.0 - 1.0) * 0.75;
                double y0 = (double)living.field_70131_O * Math.random();
                double z0 = (double)living.field_70130_N * (Math.random() * 2.0 - 1.0) * 0.75;
                mc.field_71452_i.func_78873_a((EntityFX)new DeathParticles(world, living.field_70165_t + x0, living.field_70163_u + y0, living.field_70161_v + z0, color[0], color[1], color[2]));
            }
        }
    }

    private static void useColor(Minecraft mc, Entity living, float time) {
        if (living instanceof EntityLivingBase) {
            HealthStep.getStep(mc, (EntityLivingBase)living, time).glColor();
        } else {
            HealthStep.GOOD.glColor();
        }
    }

    private static float getHealthFactor(Minecraft mc, Entity living, float time) {
        float normalFactor = StaticPlayerHelper.getHealth(mc, living, time) / StaticPlayerHelper.getMaxHealth(living);
        float delta = 1.0f - normalFactor;
        return normalFactor + delta * delta / 2.0f * normalFactor;
    }
}

