/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens;

import com.saomc.GLCore;
import com.saomc.resources.StringNames;
import com.saomc.screens.Elements;
import com.saomc.screens.ParentElement;
import com.saomc.screens.menu.Categories;
import com.saomc.util.ColorUtil;
import com.saomc.util.OptionCore;
import net.minecraft.client.Minecraft;

public class Alert
extends Elements {
    private ColorUtil alertColor;

    private Alert(ParentElement gui, int xPos, int yPos, int w, String string, ColorUtil color) {
        super(gui, xPos, yPos, w, 32);
        this.alertColor = color;
    }

    public Alert(ParentElement gui, int xPos, int yPos, String string, ColorUtil color) {
        this(gui, xPos, yPos, Alert.autoWidth(string), string, color);
    }

    private static int autoWidth(String string) {
        int defValue = GLCore.glStringWidth(string);
        return Math.max(0, defValue - 20);
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        if (this.visibility > 0.0f) {
            GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
            int color = this.mouseOver(cursorX, cursorY) ? this.alertColor.mediumColor(ColorUtil.DEFAULT_FONT_COLOR) : this.alertColor.rgba;
            GLCore.glColorRGBA(ColorUtil.multiplyAlpha(color, this.visibility));
            int left = this.getX(false);
            int top = this.getY(false);
            GLCore.glTexturedRect(left - 20, top, 0, 155, 20, this.height);
            GLCore.glTexturedRect(left, top, this.width, this.height, 20, 155, 40, this.height);
            GLCore.glTexturedRect(left + this.width, top, 60, 155, 20, this.height);
        }
    }

    @Override
    public boolean mouseReleased(Minecraft mc, int cursorX, int cursorY, int button) {
        return button == 0;
    }

    @Override
    public int getX(boolean relative) {
        return super.getX(relative) - this.width / 2;
    }

    @Override
    public int getY(boolean relative) {
        return super.getY(relative) - this.height / 2;
    }

    @Override
    public Categories ID() {
        return Categories.ALERT;
    }
}

