/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens;

import com.saomc.screens.Elements;
import com.saomc.screens.ParentElement;
import com.saomc.screens.buttons.Actions;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

@SideOnly(value=Side.CLIENT)
public class ContainerGUI
extends Elements {
    public final List<Elements> elements = new ArrayList<Elements>();

    public ContainerGUI(ParentElement gui, int xPos, int yPos, int w, int h) {
        super(gui, xPos, yPos, w, h);
    }

    @Override
    public void update(Minecraft mc) {
        this.focus = false;
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            this.update(mc, i, this.elements.get(i));
        }
    }

    protected void update(Minecraft mc, int index, Elements element) {
        if (element.removed()) {
            this.elements.remove(index);
            return;
        }
        element.update(mc);
        this.focus |= element.focus;
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            this.elements.get(i).draw(mc, cursorX, cursorY);
        }
    }

    @Override
    public boolean keyTyped(Minecraft mc, char ch, int key) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (!this.elements.get((int)i).focus || !this.elements.get(i).keyTyped(mc, ch, key)) continue;
            this.actionPerformed(this.elements.get(i), Actions.KEY_TYPED, key);
        }
        return super.keyTyped(mc, ch, key);
    }

    @Override
    public boolean mousePressed(Minecraft mc, int cursorX, int cursorY, int button) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size()) {
                if (this.elements.size() <= 0) break;
                i = this.elements.size() - 1;
            }
            if (!this.elements.get(i).mouseOver(cursorX, cursorY) || !this.elements.get(i).mousePressed(mc, cursorX, cursorY, button)) continue;
            this.actionPerformed(this.elements.get(i), Actions.getAction(button, true), button);
        }
        return super.mousePressed(mc, cursorX, cursorY, button);
    }

    @Override
    public boolean mouseReleased(Minecraft mc, int cursorX, int cursorY, int button) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size()) {
                if (this.elements.size() <= 0) break;
                i = this.elements.size() - 1;
            }
            if (!this.elements.get(i).mouseOver(cursorX, cursorY, button) || !this.elements.get(i).mouseReleased(mc, cursorX, cursorY, button)) continue;
            this.actionPerformed(this.elements.get(i), Actions.getAction(button, false), button);
        }
        return super.mouseReleased(mc, cursorX, cursorY, button);
    }

    @Override
    public boolean mouseWheel(Minecraft mc, int cursorX, int cursorY, int delta) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size()) {
                if (this.elements.size() <= 0) break;
                i = this.elements.size() - 1;
            }
            if (!this.elements.get(i).mouseOver(cursorX, cursorY) || !this.elements.get(i).mouseWheel(mc, cursorX, cursorY, delta)) continue;
            this.actionPerformed(this.elements.get(i), Actions.MOUSE_WHEEL, delta);
        }
        return super.mouseWheel(mc, cursorX, cursorY, delta);
    }

    @Override
    public void close(Minecraft mc) {
        this.elements.stream().forEach(el -> el.close(mc));
        this.elements.clear();
        super.close(mc);
    }
}

