/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens;

import com.saomc.GLCore;
import com.saomc.SoundCore;
import com.saomc.resources.StringNames;
import com.saomc.screens.Elements;
import com.saomc.screens.ParentElement;
import com.saomc.screens.menu.Categories;
import com.saomc.util.ColorUtil;
import com.saomc.util.IconCore;
import com.saomc.util.OptionCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;

@SideOnly(value=Side.CLIENT)
public class IconGUI
extends Elements {
    private final Categories id;
    public boolean highlight;
    public ColorUtil bgColor;
    public ColorUtil disabledMask;
    private IconCore icon;

    public IconGUI(ParentElement gui, Categories saoID, int xPos, int yPos, IconCore iconCore) {
        super(gui, xPos, yPos, 20, 20);
        this.id = saoID;
        this.icon = iconCore;
        this.highlight = false;
        this.bgColor = ColorUtil.DEFAULT_COLOR;
        this.disabledMask = ColorUtil.DISABLED_MASK;
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        if (this.visibility > 0.0f) {
            GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
            int hoverState = this.hoverState(cursorX, cursorY);
            int color0 = this.getColor(hoverState, true);
            int color1 = this.getColor(hoverState, false);
            int left = this.getX(false);
            int top = this.getY(false);
            int iconOffset = 2;
            GLCore.glBlend(true);
            GLCore.glColorRGBA(ColorUtil.multiplyAlpha(color0, this.visibility));
            GLCore.glTexturedRect(left, top, 0, 25, 20, 20);
            GLCore.glColorRGBA(ColorUtil.multiplyAlpha(color1, this.visibility));
            this.icon.glDraw(left + 2, top + 2);
            GLCore.glBlend(false);
        }
    }

    protected int getColor(int hoverState, boolean bg) {
        if (this.icon == IconCore.CONFIRM) {
            return bg ? (hoverState == 1 ? ColorUtil.CONFIRM_COLOR.rgba : (hoverState == 2 ? ColorUtil.CONFIRM_COLOR_LIGHT.rgba : ColorUtil.CONFIRM_COLOR.rgba & this.disabledMask.rgba)) : (hoverState > 0 ? ColorUtil.HOVER_FONT_COLOR.rgba : this.disabledMask.rgba);
        }
        if (this.icon == IconCore.CANCEL) {
            return bg ? (hoverState == 1 ? ColorUtil.CANCEL_COLOR.rgba : (hoverState == 2 ? ColorUtil.CANCEL_COLOR_LIGHT.rgba : ColorUtil.CANCEL_COLOR.rgba & this.disabledMask.rgba)) : (hoverState > 0 ? ColorUtil.HOVER_FONT_COLOR.rgba : this.disabledMask.rgba);
        }
        return bg ? (hoverState == 1 ? this.bgColor.rgba : (hoverState == 2 ? ColorUtil.HOVER_COLOR.rgba : this.bgColor.rgba & this.disabledMask.rgba)) : (hoverState == 1 ? ColorUtil.DEFAULT_FONT_COLOR.rgba : (hoverState == 2 ? ColorUtil.HOVER_FONT_COLOR.rgba : ColorUtil.DEFAULT_FONT_COLOR.rgba & this.disabledMask.rgba));
    }

    @Override
    public boolean mouseReleased(Minecraft mc, int cursorX, int cursorY, int button) {
        return button == 0;
    }

    @Override
    public void click(SoundHandler handler, boolean flag) {
        if (this.icon == IconCore.CONFIRM) {
            SoundCore.play(handler, "sao.confirm");
        } else {
            super.click(handler, flag);
        }
    }

    public int hoverState(int cursorX, int cursorY) {
        return this.highlight || this.mouseOver(cursorX, cursorY) ? 2 : (this.enabled ? 1 : 0);
    }

    @Override
    public Categories ID() {
        return this.id;
    }
}

