/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens;

import com.saomc.GLCore;
import com.saomc.screens.Elements;
import com.saomc.screens.ParentElement;
import com.saomc.screens.window.WindowAlign;
import com.saomc.util.ColorUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;

@SideOnly(value=Side.CLIENT)
public class LabelGUI
extends Elements {
    public String caption;
    public ColorUtil fontColor;
    public WindowAlign align;

    public LabelGUI(ParentElement gui, int xPos, int yPos, int width, String string, WindowAlign windowAlign) {
        super(gui, xPos, yPos, width, 20);
        this.caption = string;
        this.fontColor = ColorUtil.DEFAULT_FONT_COLOR;
        this.align = windowAlign;
    }

    public LabelGUI(ParentElement gui, int xPos, int yPos, String string, WindowAlign windowAlign) {
        this(gui, xPos, yPos, 200, string, windowAlign);
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        if (this.visibility > 0.0f) {
            int left = this.align.getX(this, false, GLCore.glStringWidth(this.caption)) + this.getOffsetX();
            int top = this.getY(false);
            GLCore.glString(this.caption, left, top + (this.height - GLCore.glStringHeight()) / 2, this.fontColor.multiplyAlpha(this.visibility));
        }
    }

    public int getOffsetX() {
        if (this.align == WindowAlign.LEFT) {
            return 8;
        }
        if (this.align == WindowAlign.RIGHT) {
            return -8;
        }
        return 0;
    }
}

