/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens;

import com.saomc.screens.Elements;
import com.saomc.screens.MenuGUI;
import com.saomc.screens.ParentElement;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;

@SideOnly(value=Side.CLIENT)
public class ListGUI
extends MenuGUI {
    private float scrolledValue;
    private int scrollValue;
    private int size;
    private int minSize;
    private int lastDragY;
    private int dragY;
    private boolean dragging;

    private ListGUI(ParentElement gui, int xPos, int yPos, int w, int h, int minH) {
        super(gui, xPos, yPos, w, h);
        this.fullArrow = false;
        this.scrollValue = 0;
        this.size = h;
        this.minSize = minH;
    }

    public ListGUI(ParentElement gui, int xPos, int yPos, int w, int h) {
        this(gui, xPos, yPos, w, h, 0);
    }

    @Override
    protected int getOffset(int index) {
        int a = Math.round((float)super.getOffset(index) - this.scrolledValue);
        if (this.elements.size() > 9) {
            if ((float)super.getOffset(0) - this.scrolledValue > (float)(-super.getOffset(2))) {
                if (a >= super.getOffset(8) && (float)(a = Math.round((float)(super.getOffset(0) - super.getReverseOffset(index)) - this.scrolledValue)) > (float)super.getOffset(8) - this.scrolledValue) {
                    a = Math.round((float)(super.getOffset(0) - super.getReverseOffset(index) - super.getOffset(this.elements.size())) - this.scrolledValue);
                }
            } else if ((float)super.getOffset(this.elements.size()) - this.scrolledValue < (float)super.getOffset(6) && index < this.elements.size() - 8) {
                a = Math.round((float)(super.getOffset(this.elements.size()) + super.getOffset(index)) - this.scrolledValue);
            }
        }
        return a;
    }

    @Override
    protected int getSize() {
        return Math.max(Math.min(this.size, super.getOffset(this.elements.size())), this.minSize);
    }

    @Override
    protected void update(Minecraft mc, int index, Elements element) {
        super.update(mc, index, element);
        int elementY = element.getY(false);
        int elementSize = element.height;
        int listY = this.getY(false);
        int listSize = this.getSize();
        element.visibility = elementY < listY ? Math.max(1.0f - (float)(listY - elementY) / (float)listSize, 0.0f) : (elementY + elementSize > listY + listSize ? Math.max(1.0f - (float)(elementY + elementSize - (listY + listSize)) / (float)listSize, 0.0f) : 1.0f);
        element.visibility = element.visibility < 0.6f ? 0.0f : (element.visibility *= element.visibility);
        this.scroll(0);
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        this.scrolledValue = (this.scrolledValue + (float)this.scrollValue) / 2.0f;
        super.draw(mc, cursorX, cursorY);
    }

    @Override
    public boolean mouseOver(int cursorX, int cursorY, int flag) {
        if (!super.mouseOver(cursorX, cursorY, flag)) {
            if (this.dragging) {
                this.dragY += this.scroll(cursorY - this.lastDragY);
                this.lastDragY = cursorY;
            }
            this.dragging = false;
            return false;
        }
        return true;
    }

    @Override
    public boolean mousePressed(Minecraft mc, int cursorX, int cursorY, int button) {
        if (button == 0) {
            this.dragY = 0;
            this.lastDragY = cursorY;
            this.dragging = true;
        }
        return super.mousePressed(mc, cursorX, cursorY, button);
    }

    @Override
    public void mouseMoved(Minecraft mc, int cursorX, int cursorY) {
        if (this.dragging) {
            this.dragY += this.scroll(cursorY - this.lastDragY);
            this.lastDragY = cursorY;
        }
    }

    @Override
    public boolean mouseReleased(Minecraft mc, int cursorX, int cursorY, int button) {
        boolean wasDragging = false;
        if (button == 0) {
            if (this.dragging) {
                this.dragY += this.scroll(cursorY - this.lastDragY);
                wasDragging = this.dragY > 0;
                this.lastDragY = cursorY;
            }
            this.dragging = false;
        }
        return !wasDragging && super.mouseReleased(mc, cursorX, cursorY, button);
    }

    @Override
    public boolean mouseWheel(Minecraft mc, int cursorX, int cursorY, int delta) {
        if (this.elements.size() > 0) {
            this.scroll(Math.abs(delta * 2 * this.getSize() / this.elements.size()) / delta);
        }
        return super.mouseWheel(mc, cursorX, cursorY, delta);
    }

    private int scroll(int delta) {
        int value = this.scrollValue;
        if (this.elements.size() <= 9) {
            this.scrollValue = Math.min(Math.max(this.scrollValue - delta, 0), super.getOffset(this.elements.size()) - this.getSize());
        } else {
            this.scrollValue -= delta;
            this.scrollValue %= super.getOffset(this.elements.size());
        }
        return Math.abs(value - this.scrollValue);
    }
}

