/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens;

import com.saomc.GLCore;
import com.saomc.resources.StringNames;
import com.saomc.screens.ContainerGUI;
import com.saomc.screens.Elements;
import com.saomc.screens.ParentElement;
import com.saomc.util.ColorUtil;
import com.saomc.util.OptionCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;

@SideOnly(value=Side.CLIENT)
public class MenuGUI
extends ContainerGUI {
    public boolean innerMenu = false;
    public boolean fullArrow = true;

    public MenuGUI(ParentElement gui, int xPos, int yPos, int w, int h) {
        super(gui, xPos, yPos, w, h);
    }

    protected int getOffset(int index) {
        return this.elements.stream().limit(index).mapToInt(this::getOffsetSize).sum();
    }

    int getReverseOffset(int index) {
        return this.elements.stream().skip(index).mapToInt(this::getOffsetSize).sum();
    }

    protected int getOffsetSize(Elements element) {
        return element.height;
    }

    @Override
    public void update(Minecraft mc) {
        this.height = this.getSize();
        if (this.width <= 0) {
            this.width = this.elements.stream().mapToInt(el -> el.width).max().orElse(this.width);
        }
        super.update(mc);
    }

    protected int getSize() {
        return this.getOffset(this.elements.size());
    }

    @Override
    protected void update(Minecraft mc, int index, Elements element) {
        element.y = this.getOffset(index);
        element.width = this.width - element.x;
        super.update(mc, index, element);
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        if (this.visibility > 0.0f && this.parent != null && this.height > 0) {
            if (this.x > 0) {
                GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
                GLCore.glColorRGBA(ColorUtil.DEFAULT_COLOR.multiplyAlpha(this.visibility));
                int left = this.getX(false);
                int top = this.getY(false) + 1;
                int arrowTop = super.getY(false) - this.height / 2;
                GLCore.glTexturedRect(left - 2, top, 2, this.height - 1, 40, 41, 2, 4);
                GLCore.glTexturedRect(left - 10, arrowTop + (this.height - 10) / 2, 20, 25 + (this.fullArrow ? 10 : 0), 10, 10);
            } else if (this.x < 0) {
                GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
                GLCore.glColorRGBA(ColorUtil.DEFAULT_COLOR.multiplyAlpha(this.visibility));
                int left = this.getX(false);
                int top = this.getY(false) + 1;
                int arrowTop = super.getY(false) - this.height / 2;
                GLCore.glTexturedRect(left + this.width, top, 2, this.height - 1, 40, 41, 2, 4);
                GLCore.glTexturedRect(left + this.width, arrowTop + (this.height - 10) / 2, 30, 25 + (this.fullArrow ? 10 : 0), 10, 10);
            }
        }
        super.draw(mc, cursorX, cursorY);
    }

    @Override
    public int getY(boolean relative) {
        return super.getY(relative) - (relative || this.innerMenu ? 0 : this.height / 2);
    }
}

