/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens;

import com.saomc.GLCore;
import com.saomc.screens.Elements;
import com.saomc.screens.ParentElement;
import com.saomc.util.ColorUtil;
import com.saomc.util.J8String;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;

@SideOnly(value=Side.CLIENT)
public class TextGUI
extends Elements {
    public String[] lines;
    public ColorUtil fontColor;

    public TextGUI(ParentElement gui, int xPos, int yPos, String ... strings) {
        super(gui, xPos, yPos, 0, 0);
        this.lines = strings;
        this.fontColor = ColorUtil.DEFAULT_FONT_COLOR;
    }

    public TextGUI(ParentElement gui, int xPos, int yPos, String text, int width) {
        this(gui, xPos, yPos, TextGUI.toLines(text, width));
    }

    public TextGUI(ParentElement gui, int xPos, int yPos, String text) {
        this(gui, xPos, yPos, text, 0);
    }

    private static String[] toLines(String text, int width) {
        if (width <= 0) {
            return text.split("\n");
        }
        String[] rawLines = text.split("\n");
        if (rawLines.length <= 0) {
            return rawLines;
        }
        ArrayList<String> lines = new ArrayList<String>();
        String cut = "";
        String line = rawLines[0];
        int rawIndex = 0;
        while (line != null) {
            int lastIndex;
            int size = GLCore.glStringWidth(line);
            while (size > width - 16 && (lastIndex = line.lastIndexOf(32)) != -1) {
                cut = line.substring(lastIndex + 1) + " " + cut;
                line = line.substring(0, lastIndex);
                if (rawIndex + 1 < rawLines.length) {
                    rawLines[rawIndex + 1] = cut + rawLines[rawIndex + 1];
                    cut = "";
                }
                size = GLCore.glStringWidth(line);
            }
            if (!line.matches(" *")) {
                lines.add(line);
            }
            if (cut.length() > 0) {
                line = cut;
                cut = "";
                continue;
            }
            if (++rawIndex < rawLines.length) {
                line = rawLines[rawIndex];
                continue;
            }
            line = null;
        }
        return lines.toArray(new String[lines.size()]);
    }

    @Override
    public void update(Minecraft mc) {
        int linesHeight;
        int w;
        int n = w = this.lines.length > 0 ? Stream.of(this.lines).mapToInt(GLCore::glStringWidth).max().getAsInt() + 16 : 0;
        if (w > this.width) {
            this.width = w;
        }
        if ((linesHeight = this.lines.length * GLCore.glStringHeight() + 16) > this.height) {
            this.height = linesHeight;
        }
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        if (this.visibility > 0.0f) {
            int left = this.getX(false);
            int top = this.getY(false);
            for (int i = 0; i < this.lines.length; ++i) {
                GLCore.glString(this.lines[i], left + 8, top + 8 + i * (GLCore.glStringHeight() + 1), this.fontColor.multiplyAlpha(this.visibility));
            }
        }
    }

    public final String getText() {
        return J8String.join("\n", this.lines);
    }

    public final void setText(String text) {
        this.lines = TextGUI.toLines(text, this.width);
    }
}

