/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens.ingame;

import com.saomc.GLCore;
import com.saomc.social.StaticPlayerHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

@SideOnly(value=Side.CLIENT)
public enum HealthStep {
    VERY_LOW(0.1f, -1124073217),
    LOW(0.2f, -201326337),
    VERY_DAMAGED(0.3f, -193462017),
    DAMAGED(0.4f, -188940033),
    OKAY(0.5f, -303351553),
    GOOD(1.0f, -1812709633),
    CREATIVE(-1.0f, -1288838145);

    private final float healthLimit;
    private final int color;

    private HealthStep(float limit, int argb) {
        this.healthLimit = limit;
        this.color = argb;
    }

    public static HealthStep getStep(Minecraft mc, EntityLivingBase entity, float time) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return CREATIVE;
        }
        float value = StaticPlayerHelper.getHealth(mc, (Entity)entity, time) / StaticPlayerHelper.getMaxHealth((Entity)entity);
        HealthStep step = HealthStep.first();
        while (value > step.getLimit() && step.ordinal() + 1 < HealthStep.values().length) {
            step = HealthStep.next(step);
        }
        return step;
    }

    public static HealthStep getStep(Minecraft mc, float health, float time) {
        HealthStep step = HealthStep.first();
        while (health > step.getLimit() && step.ordinal() + 1 < HealthStep.values().length) {
            step = HealthStep.next(step);
        }
        return step;
    }

    private static HealthStep first() {
        return HealthStep.values()[0];
    }

    private static HealthStep next(HealthStep step) {
        return HealthStep.values()[step.ordinal() + 1];
    }

    private float getLimit() {
        return this.healthLimit;
    }

    public final void glColor() {
        GLCore.glColorRGBA(this.color);
    }
}

