/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens.ingame;

import com.saomc.GLCore;
import com.saomc.effects.StatusEffects;
import com.saomc.resources.StringNames;
import com.saomc.screens.death.DeathScreen;
import com.saomc.screens.ingame.HealthStep;
import com.saomc.screens.menu.IngameMenuGUI;
import com.saomc.social.StaticPlayerHelper;
import com.saomc.social.party.PartyHelper;
import com.saomc.util.OptionCore;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class IngameGUI
extends GuiIngameForge {
    private final int HPXP_OFFSET_ORIG_R = 3;
    private final int HPXP_OFFSET_ORIG_D = 1;
    private final int HPXP_OFFSET_ALO_R = 0;
    private final int HPXP_OFFSET_ALO_D = 6;
    private FontRenderer fontRenderer;
    private RenderGameOverlayEvent eventParent;
    private String username;
    private int maxNameWidth;
    private int usernameBoxes;
    private int offsetUsername;
    private int width;
    private int height;
    private float time;
    private int healthBoxes;

    public IngameGUI(Minecraft mc) {
        super(mc);
    }

    public void func_73830_a(float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        this.fontRenderer = this.field_73839_d.field_71466_p;
        this.username = this.field_73839_d.field_71439_g.getDisplayName();
        this.maxNameWidth = this.fontRenderer.func_78256_a(this.username);
        this.usernameBoxes = 1 + (this.maxNameWidth + 4) / 5;
        this.offsetUsername = 18 + this.usernameBoxes * 5;
        ScaledResolution res = new ScaledResolution(this.field_73839_d, this.field_73839_d.field_71443_c, this.field_73839_d.field_71440_d);
        this.eventParent = new RenderGameOverlayEvent(partialTicks, res, mouseX, mouseY);
        this.width = res.func_78326_a();
        this.height = res.func_78328_b();
        this.time = partialTicks;
        GLCore.glBlend(true);
        super.func_73830_a(partialTicks, hasScreen, mouseX, mouseY);
        if (OptionCore.FORCE_HUD.getValue() && !this.field_73839_d.field_71442_b.func_78755_b() && this.field_73839_d.field_71451_h instanceof EntityPlayer) {
            if (renderHealth) {
                this.renderHealth(this.width, this.height);
            }
            if (renderArmor) {
                this.renderArmor(this.width, this.height);
            }
            if (renderFood) {
                this.renderFood(this.width, this.height);
            }
            if (renderHealthMount) {
                this.renderHealthMount(this.width, this.height);
            }
            if (renderAir) {
                this.renderAir(this.width, this.height);
            }
            this.field_73839_d.field_71460_t.func_78478_c();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    protected void renderCrosshairs(int width, int height) {
        if (this.pre(RenderGameOverlayEvent.ElementType.CROSSHAIRS)) {
            return;
        }
        if (OptionCore.CROSS_HAIR.getValue() && !(this.field_73839_d.field_71462_r instanceof IngameMenuGUI) && !(this.field_73839_d.field_71462_r instanceof DeathScreen)) {
            super.renderCrosshairs(width, height);
        }
        this.post(RenderGameOverlayEvent.ElementType.CROSSHAIRS);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    protected void renderArmor(int width, int height) {
        if (OptionCore.VANILLA_UI.getValue()) {
            super.renderArmor(width, height);
        } else {
            if (this.replaceEvent(RenderGameOverlayEvent.ElementType.ARMOR)) {
                return;
            }
            this.post(RenderGameOverlayEvent.ElementType.ARMOR);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    protected void renderHotbar(int width, int height, float partialTicks) {
        if (this.replaceEvent(RenderGameOverlayEvent.ElementType.HOTBAR)) {
            return;
        }
        InventoryPlayer inv = this.field_73839_d.field_71439_g.field_71071_by;
        int slotCount = 9;
        if (OptionCore.DEFAULT_HOTBAR.getValue()) {
            super.renderHotbar(width, height, partialTicks);
        } else if (OptionCore.HOR_HOTBAR.getValue()) {
            int i;
            GLCore.glBlend(true);
            GLCore.tryBlendFuncSeparate(770, 771, 1, 0);
            GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
            GLCore.glColor(1.0f, 1.0f, 1.0f, 1.0f);
            for (i = 0; i < 9; ++i) {
                GLCore.glColorRGBA(i == inv.field_70461_c ? -4561238 : -842150486);
                GLCore.glTexturedRect(width / 2 - 91 - 1 + i * 20, height - 22 - 1, this.field_73735_i, 0, 25, 20, 20);
            }
            GLCore.glColor(1.0f, 1.0f, 1.0f, 1.0f);
            GLCore.glBlend(false);
            GLCore.glRescaleNormal(true);
            RenderHelper.func_74520_c();
            for (i = 0; i < 9; ++i) {
                int x = width / 2 - 92 + i * 20 + 2;
                int z = height - 17 - 3;
                super.func_73832_a(i, x, z, partialTicks);
            }
            GLCore.glRescaleNormal(false);
            RenderHelper.func_74518_a();
        } else {
            int i;
            GLCore.glBlend(true);
            GLCore.tryBlendFuncSeparate(770, 771, 1, 0);
            GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
            GLCore.glColor(1.0f, 1.0f, 1.0f, 1.0f);
            int slotsY = (height - 198) / 2;
            for (i = 0; i < 9; ++i) {
                GLCore.glColorRGBA(i == inv.field_70461_c ? -4561238 : -842150486);
                GLCore.glTexturedRect(width - 24, slotsY + 22 * i, this.field_73735_i, 0, 25, 20, 20);
            }
            GLCore.glColor(1.0f, 1.0f, 1.0f, 1.0f);
            GLCore.glBlend(false);
            GLCore.glRescaleNormal(true);
            RenderHelper.func_74520_c();
            for (i = 0; i < 9; ++i) {
                super.func_73832_a(i, width - 22, slotsY + 2 + 22 * i, partialTicks);
            }
            RenderHelper.func_74518_a();
            GLCore.glRescaleNormal(false);
        }
        this.post(RenderGameOverlayEvent.ElementType.HOTBAR);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    protected void renderAir(int width, int height) {
        if (OptionCore.VANILLA_UI.getValue()) {
            super.renderAir(width, height);
        } else {
            if (this.replaceEvent(RenderGameOverlayEvent.ElementType.AIR)) {
                return;
            }
            this.field_73839_d.field_71424_I.func_76320_a("air");
            GLCore.glBlend(true);
            int left = width / 2 + 91;
            int top = height - right_height;
            if (this.field_73839_d.field_71439_g.func_70055_a(Material.field_151586_h)) {
                int air = this.field_73839_d.field_71439_g.func_70086_ai();
                int full = MathHelper.func_76143_f((double)((double)(air - 2) * 10.0 / 300.0));
                int partial = MathHelper.func_76143_f((double)((double)air * 10.0 / 300.0)) - full;
                for (int i = 0; i < full + partial; ++i) {
                    this.func_73729_b(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
                }
                right_height += 10;
            }
            GLCore.glBlend(false);
            this.field_73839_d.field_71424_I.func_76319_b();
            this.post(RenderGameOverlayEvent.ElementType.AIR);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    protected void func_73828_d() {
        if (OptionCore.VANILLA_UI.getValue()) {
            super.func_73828_d();
        } else {
            if (this.replaceEvent(RenderGameOverlayEvent.ElementType.BOSSHEALTH)) {
                return;
            }
            this.field_73839_d.field_71424_I.func_76320_a("bossHealth");
            if (BossStatus.field_82827_c != null && BossStatus.field_82826_b > 0) {
                GLCore.glAlphaTest(true);
                GLCore.glBlend(true);
                --BossStatus.field_82826_b;
                double scale = 1.0;
                GLCore.glColor(1.0f, 1.0f, 1.0f, 1.0f);
                GLCore.glBindTexture(StringNames.gui);
                int healthBarWidth = 234;
                double healthWidth = 216.0 * scale;
                double j = (double)(this.width / 2) - 117.0 * scale;
                int b0 = 15;
                double healthValue = (double)BossStatus.field_82828_a * healthWidth;
                GLCore.glTexturedRect((int)j, b0, this.field_73735_i, (int)(234.0 * scale), (int)(15.0 * scale), 21.0, 0.0, 234.0, 15.0);
                GLCore.glTexturedRect((int)j, b0, this.field_73735_i, (int)(234.0 * scale), (int)(5.0 * scale), 21.0, 0.0, 234.0, 5.0);
                int healthHeight = 9;
                HealthStep.getStep(this.field_73839_d, BossStatus.field_82828_a, this.time).glColor();
                int h = 9;
                int i = 0;
                while ((double)i < healthValue) {
                    GLCore.glTexturedRect((int)j + 1 + i, b0 + (int)(3.0 * scale), this.field_73735_i, 1.0, (double)h * scale, 9 - h, 15.0, (int)(1.0 * scale), h);
                    if (((double)i >= 105.0 * scale && (double)i <= 110.0 * scale || (double)i >= healthValue - (double)h) && --h <= 0) break;
                    ++i;
                }
                String s = BossStatus.field_82827_c;
                this.fontRenderer.func_78261_a(s, this.width / 2 - this.fontRenderer.func_78256_a(s) / 2, b0 - 10, 0xFFFFFF);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GLCore.glAlphaTest(false);
                GLCore.glBlend(false);
            }
            this.field_73839_d.field_71424_I.func_76319_b();
            this.post(RenderGameOverlayEvent.ElementType.BOSSHEALTH);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void renderHealth(int width, int height) {
        if (OptionCore.VANILLA_UI.getValue()) {
            super.renderHealth(width, height);
        } else {
            int i;
            int h;
            if (this.replaceEvent(RenderGameOverlayEvent.ElementType.HEALTH)) {
                return;
            }
            this.field_73839_d.field_71424_I.func_76320_a("health");
            int healthBarWidth = 234;
            int healthWidth = 216;
            int healthHeight = OptionCore.SAO_UI.getValue() ? 9 : 4;
            int healthValue = (int)(StaticPlayerHelper.getHealth(this.field_73839_d, (Entity)this.field_73839_d.field_71439_g, this.time) / StaticPlayerHelper.getMaxHealth((Entity)this.field_73839_d.field_71439_g) * 216.0f);
            int stepOne = 69;
            int stepTwo = 141;
            int stepThree = 213;
            GLCore.glAlphaTest(true);
            GLCore.glBlend(true);
            GLCore.glColor(1.0f, 1.0f, 1.0f, 0.75f);
            GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
            GLCore.glTexturedRect(2, 2, this.field_73735_i, 0, 0, 16, 15);
            GLCore.glTexturedRect(18, 2, this.field_73735_i, this.usernameBoxes * 5, 15.0, 16.0, 0.0, 5.0, 15.0);
            GLCore.glString(this.fontRenderer, this.username, 18, 3 + (15 - this.fontRenderer.field_78288_b) / 2, -1, true);
            GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
            GLCore.glTexturedRect(this.offsetUsername, 2, this.field_73735_i, 21, 0, 234, 15);
            HealthStep.getStep(this.field_73839_d, (EntityLivingBase)this.field_73839_d.field_71439_g, this.time).glColor();
            if (OptionCore.SAO_UI.getValue()) {
                h = healthHeight;
                for (int i2 = 0; i2 < healthValue; ++i2) {
                    GLCore.glTexturedRect(this.offsetUsername + 1 + i2, 5, this.field_73735_i, healthHeight - h, 15, 1, h);
                    if ((i2 < 105 || i2 > 110) && i2 < healthValue - h || --h > 0) {
                        continue;
                    }
                    break;
                }
            } else {
                h = healthValue <= 12 ? 12 - healthValue : 0;
                int o = healthHeight;
                for (i = 0; i < healthValue; ++i) {
                    GLCore.glTexturedRect(this.offsetUsername + 4 + i, 6 + (healthHeight - o), this.field_73735_i, h, 236 + (healthHeight - o), 1, o);
                    if (healthValue < 216 && i >= healthValue - 3) {
                        --o;
                    }
                    if (healthValue <= 12 ? ++h > 12 : (i >= stepOne && i <= stepOne + 3 || i >= stepTwo && i <= stepTwo + 3 || i >= stepThree) && ++h > 12) break;
                }
                if (healthValue >= stepTwo && healthValue < stepThree) {
                    GLCore.glTexturedRect(this.offsetUsername + healthValue, 6, this.field_73735_i, 11, 245, 7, 4);
                }
                if (healthValue >= stepOne && healthValue < stepTwo + 4) {
                    GLCore.glTexturedRect(this.offsetUsername + healthValue, 6, this.field_73735_i, 4, 245, 7, 4);
                }
                if (healthValue < stepOne + 4 && healthValue > 0) {
                    GLCore.glTexturedRect(this.offsetUsername + healthValue + 2, 6, this.field_73735_i, 0, 245, 4, 4);
                    for (i = 0; i < healthValue - 2; ++i) {
                        GLCore.glTexturedRect(this.offsetUsername + i + 4, 6, this.field_73735_i, 0, 245, 4, 4);
                    }
                }
            }
            this.field_73839_d.field_71424_I.func_76319_b();
            this.post(RenderGameOverlayEvent.ElementType.HEALTH);
            this.renderFood(216, healthHeight, this.offsetUsername, stepOne, stepTwo, stepThree);
            if (!OptionCore.REMOVE_HPXP.getValue()) {
                String absorb;
                String string = absorb = OptionCore.ALT_ABSORB_POS.getValue() ? "" : " ";
                if (this.field_73839_d.field_71439_g.func_110139_bj() > 0.0f) {
                    absorb = absorb + "(+" + (int)Math.ceil(this.field_73839_d.field_71439_g.func_110139_bj());
                    absorb = absorb + ')';
                    absorb = absorb + (OptionCore.ALT_ABSORB_POS.getValue() ? Character.valueOf(' ') : "");
                }
                String healthStr = String.valueOf((OptionCore.ALT_ABSORB_POS.getValue() ? absorb : "") + (int)Math.ceil(StaticPlayerHelper.getHealth(this.field_73839_d, (Entity)this.field_73839_d.field_71439_g, this.time))) + (OptionCore.ALT_ABSORB_POS.getValue() ? "" : absorb) + " / " + String.valueOf((int)Math.ceil(StaticPlayerHelper.getMaxHealth((Entity)this.field_73839_d.field_71439_g)));
                int healthStrWidth = this.fontRenderer.func_78256_a(healthStr);
                int absStart = healthStr.indexOf(40);
                String[] strs = absStart >= 0 ? new String[]{healthStr.substring(0, absStart), healthStr.substring(absStart, healthStr.indexOf(41) + 1), healthStr.substring(healthStr.indexOf(41) + 1)} : new String[]{"", "", healthStr};
                this.healthBoxes = (healthStrWidth + 4) / 5;
                int offsetR = OptionCore.SAO_UI.getValue() ? 3 : 0;
                int offsetD = OptionCore.SAO_UI.getValue() ? 1 : 6;
                GLCore.glColor(1.0f, 1.0f, 1.0f, 0.95f);
                GLCore.glTexturedRect(this.offsetUsername + 113 + offsetR, 13 + offsetD, this.field_73735_i, 60, 15, 5, 13);
                GLCore.glTexturedRect(this.offsetUsername + 118 + offsetR, 13 + offsetD, this.field_73735_i, this.healthBoxes * 5, 13.0, 66.0, 15.0, 5.0, 13.0);
                GLCore.glTexturedRect(this.offsetUsername + 118 + offsetR + this.healthBoxes * 5, 13 + offsetD, this.field_73735_i, 70, 15, 5, 13);
                GLCore.glString(strs[0], this.offsetUsername + 118 + offsetR, 16 + offsetD, -1, true);
                GLCore.glString(strs[1], this.offsetUsername + 118 + offsetR + this.fontRenderer.func_78256_a(strs[0]), 16 + offsetD, -11141121, true);
                GLCore.glString(strs[2], this.offsetUsername + 118 + offsetR + this.fontRenderer.func_78256_a(strs[0] + strs[1]), 16 + offsetD, -1, true);
            }
            GLCore.glColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.field_73839_d.field_71424_I.func_76320_a("potioneffects");
            int offsetForEffects = this.offsetUsername + 234 - 4;
            List<StatusEffects> effects = StatusEffects.getEffects((EntityLivingBase)this.field_73839_d.field_71439_g);
            GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
            for (i = 0; i < effects.size(); ++i) {
                effects.get(i).glDraw(offsetForEffects + i * 11, 2, this.field_73735_i);
            }
            this.field_73839_d.field_71424_I.func_76319_b();
            if (PartyHelper.instance().isEffective()) {
                this.field_73839_d.field_71424_I.func_76320_a("party");
                List<EntityPlayer> players = StaticPlayerHelper.listOnlinePlayers(this.field_73839_d);
                if (players.contains(this.field_73839_d.field_71439_g)) {
                    players.remove(this.field_73839_d.field_71439_g);
                }
                GLCore.glAlphaTest(true);
                GLCore.glBlend(true);
                int index = 0;
                int baseY = 35;
                int h2 = 15;
                for (EntityPlayer player : players) {
                    String playerName = player.getDisplayName();
                    if (!PartyHelper.instance().isMember(playerName)) continue;
                    GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
                    GLCore.glTexturedRect(2, 35 + index * 15, this.field_73735_i, 85, 15, 10, 13);
                    GLCore.glTexturedRect(13, 35 + index * 15, this.field_73735_i, 80, 15, 5, 13);
                    if (playerName.length() > 5) {
                        playerName = playerName.substring(0, 5);
                    }
                    int nameBoxes = 6;
                    GLCore.glTexturedRect(18, 35 + index * 15, this.field_73735_i, 30.0, 13.0, 65.0, 15.0, 5.0, 13.0);
                    int offset = 48;
                    GLCore.glTexturedRect(offset, 35 + index * 15, this.field_73735_i, 40, 28, 100, 13);
                    int hpWidth = 97;
                    int hpHeight = 3;
                    int hpValue = (int)(StaticPlayerHelper.getHealth(this.field_73839_d, (Entity)player, this.time) / StaticPlayerHelper.getMaxHealth((Entity)player) * 97.0f);
                    HealthStep.getStep(this.field_73839_d, (EntityLivingBase)player, this.time).glColor();
                    int hp = 3;
                    for (int j = 0; j < hpValue; ++j) {
                        GLCore.glTexturedRect(offset + 1 + j, 40 + index * 15, this.field_73735_i, 3 - hp, 15, 1, hp);
                        if (j >= hpValue - hp && --hp <= 0) break;
                    }
                    GLCore.glColor(1.0f, 1.0f, 1.0f, 1.0f);
                    GLCore.glTexturedRect(offset += 100, 35 + index * 15, this.field_73735_i, 70, 15, 5, 13);
                    GLCore.glString(playerName, 18, 36 + index * 15 + (13 - this.fontRenderer.field_78288_b) / 2, -1);
                    ++index;
                }
                this.field_73839_d.field_71424_I.func_76319_b();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void renderFood(int width, int height) {
        if (OptionCore.VANILLA_UI.getValue()) {
            super.renderFood(width, height);
        }
    }

    private void renderFood(int healthWidth, int healthHeight, int offsetUsername, int stepOne, int stepTwo, int stepThree) {
        int i;
        if (this.replaceEvent(RenderGameOverlayEvent.ElementType.FOOD)) {
            return;
        }
        this.field_73839_d.field_71424_I.func_76320_a("food");
        int foodValue = (int)(StaticPlayerHelper.getHungerFract(this.field_73839_d, (Entity)this.field_73839_d.field_71439_g, this.time) * (float)healthWidth);
        int h = foodValue < 12 ? 12 - foodValue : 0;
        int o = healthHeight;
        GLCore.glColorRGBA(0x8EE1E8);
        for (i = 0; i < foodValue; ++i) {
            GLCore.glTexturedRect(offsetUsername + i + 4, 9, this.field_73735_i, h, 240, 1, o);
            if (foodValue < healthWidth && i >= foodValue - 3) {
                --o;
            }
            if (foodValue <= 12 ? ++h > 12 : (i >= stepOne && i <= stepOne + 3 || i >= stepTwo && i <= stepTwo + 3 || i >= stepThree) && ++h > 12) break;
        }
        if (foodValue >= stepTwo && foodValue < stepThree) {
            GLCore.glTexturedRect(offsetUsername + foodValue, 9, this.field_73735_i, 11, 249, 7, 4);
        }
        if (foodValue >= stepOne && foodValue < stepTwo + 4) {
            GLCore.glTexturedRect(offsetUsername + foodValue, 9, this.field_73735_i, 4, 249, 7, 4);
        }
        if (foodValue < stepOne + 4 && foodValue > 0) {
            GLCore.glTexturedRect(offsetUsername + foodValue + 2, 9, this.field_73735_i, 0, 249, 4, 4);
            for (i = 0; i < foodValue - 2; ++i) {
                GLCore.glTexturedRect(offsetUsername + i + 4, 9, this.field_73735_i, 0, 249, 4, 4);
            }
        }
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.FOOD);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    protected void renderExperience(int width, int height) {
        if (OptionCore.VANILLA_UI.getValue()) {
            super.renderExperience(width, height);
        } else {
            if (this.replaceEvent(RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
                return;
            }
            if (OptionCore.REMOVE_HPXP.getValue()) {
                return;
            }
            if (!OptionCore.FORCE_HUD.getValue() && !this.field_73839_d.field_71442_b.func_78755_b()) {
                return;
            }
            this.field_73839_d.field_71424_I.func_76320_a("expLevel");
            int offsetR = OptionCore.SAO_UI.getValue() ? 3 : 0;
            int offsetD = OptionCore.SAO_UI.getValue() ? 1 : 6;
            int offsetHealth = this.offsetUsername + 113 + (this.healthBoxes + 2) * 5 + offsetR;
            String levelStr = StatCollector.func_74838_a((String)"displayLvShort") + ": " + String.valueOf(this.field_73839_d.field_71439_g.field_71068_ca);
            int levelStrWidth = this.fontRenderer.func_78256_a(levelStr);
            int levelBoxes = (levelStrWidth + 4) / 5;
            GLCore.glBlend(true);
            GLCore.blendFunc(770, 771);
            GLCore.glColor(1.0f, 1.0f, 1.0f, 1.0f);
            GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
            GLCore.glTexturedRect(offsetHealth, 13 + offsetD, this.field_73735_i, 5.0, 13.0, 66.0, 15.0, 2.0, 13.0);
            GLCore.glTexturedRect(offsetHealth + 5, 13 + offsetD, this.field_73735_i, levelBoxes * 5, 13.0, 66.0, 15.0, 5.0, 13.0);
            GLCore.glTexturedRect(offsetHealth + (1 + levelBoxes) * 5, 13 + offsetD, this.field_73735_i, 5.0, 13.0, 78.0, 15.0, 3.0, 13.0);
            GLCore.glString(levelStr, offsetHealth + 5, 16 + offsetD, -1, true);
            this.field_73839_d.field_71424_I.func_76319_b();
            this.post(RenderGameOverlayEvent.ElementType.EXPERIENCE);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    protected void renderJumpBar(int width, int height) {
        if (OptionCore.VANILLA_UI.getValue()) {
            super.renderJumpBar(width, height);
        } else {
            if (this.replaceEvent(RenderGameOverlayEvent.ElementType.JUMPBAR)) {
                return;
            }
            this.renderExperience(width, height);
            super.renderJumpBar(width, height);
            this.post(RenderGameOverlayEvent.ElementType.JUMPBAR);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    protected void renderHealthMount(int width, int height) {
        if (OptionCore.VANILLA_UI.getValue()) {
            super.renderHealthMount(width, height);
        } else {
            EntityPlayer player = (EntityPlayer)this.field_73839_d.field_71451_h;
            Entity tmp = player.field_70154_o;
            if (!(tmp instanceof EntityLivingBase)) {
                return;
            }
            if (this.replaceEvent(RenderGameOverlayEvent.ElementType.HEALTHMOUNT)) {
                return;
            }
            this.post(RenderGameOverlayEvent.ElementType.HEALTHMOUNT);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    protected void renderHUDText(int width, int height) {
        if (OptionCore.VANILLA_UI.getValue() || OptionCore.DEFAULT_DEBUG.getValue()) {
            super.renderHUDText(width, height);
        } else {
            RenderGameOverlayEvent.Text event;
            this.field_73839_d.field_71424_I.func_76320_a("forgeHudText");
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            ArrayList<String> left = new ArrayList<String>();
            ArrayList<String> right = new ArrayList<String>();
            if (this.field_73839_d.func_71355_q()) {
                long time = this.field_73839_d.field_71441_e.func_82737_E();
                if (time >= 120500L) {
                    right.add(I18n.func_135052_a((String)"demo.demoExpired", (Object[])new Object[0]));
                } else {
                    right.add(I18n.func_135052_a((String)"demo.remainingTime", (Object[])new Object[]{StringUtils.func_76337_a((int)((int)(120500L - time)))}));
                }
            }
            if (this.field_73839_d.field_71474_y.field_74330_P) {
                this.field_73839_d.field_71424_I.func_76320_a("debug");
                GL11.glPushMatrix();
                left.add(null);
                left.add(null);
                left.add(null);
                right.add(null);
                right.add(null);
                right.add(null);
                left.add("Sword Art Online UI 1.7.10-1.6.0-Dev1");
                left.add("Minecraft 1.7.10 (" + this.field_73839_d.field_71426_K + ")");
                left.add(this.field_73839_d.func_71393_m());
                left.add(this.field_73839_d.func_71408_n());
                left.add(this.field_73839_d.func_71374_p());
                left.add(this.field_73839_d.func_71388_o());
                left.add(null);
                long max = Runtime.getRuntime().maxMemory();
                long total = Runtime.getRuntime().totalMemory();
                long free = Runtime.getRuntime().freeMemory();
                long used = total - free;
                right.add("Used memory: " + used * 100L / max + "% (" + used / 1024L / 1024L + "MB) of " + max / 1024L / 1024L + "MB");
                right.add("Allocated memory: " + total * 100L / max + "% (" + total / 1024L / 1024L + "MB)");
                int x = MathHelper.func_76128_c((double)this.field_73839_d.field_71439_g.field_70165_t);
                int y = MathHelper.func_76128_c((double)this.field_73839_d.field_71439_g.field_70163_u);
                int z = MathHelper.func_76128_c((double)this.field_73839_d.field_71439_g.field_70161_v);
                float yaw = this.field_73839_d.field_71439_g.field_70177_z;
                int heading = MathHelper.func_76128_c((double)((double)(this.field_73839_d.field_71439_g.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                left.add(String.format("x: %.5f (%d) // c: %d (%d)", this.field_73839_d.field_71439_g.field_70165_t, x, x >> 4, x & 0xF));
                left.add(String.format("y: %.3f (feet pos, %.3f eyes pos)", this.field_73839_d.field_71439_g.field_70121_D.field_72338_b, this.field_73839_d.field_71439_g.field_70163_u));
                left.add(String.format("z: %.5f (%d) // c: %d (%d)", this.field_73839_d.field_71439_g.field_70161_v, z, z >> 4, z & 0xF));
                left.add(String.format("f: %d (%s) / %f", heading, Direction.field_82373_c[heading], Float.valueOf(MathHelper.func_76142_g((float)yaw))));
                if (this.field_73839_d.field_71441_e != null && this.field_73839_d.field_71441_e.func_72899_e(x, y, z)) {
                    Chunk chunk = this.field_73839_d.field_71441_e.func_72938_d(x, z);
                    left.add(String.format("lc: %d b: %s bl: %d sl: %d rl: %d", chunk.func_76625_h() + 15, chunk.func_76591_a((int)(x & 0xF), (int)(z & 0xF), (WorldChunkManager)this.field_73839_d.field_71441_e.func_72959_q()).field_76791_y, chunk.func_76614_a(EnumSkyBlock.Block, x & 0xF, y, z & 0xF), chunk.func_76614_a(EnumSkyBlock.Sky, x & 0xF, y, z & 0xF), chunk.func_76629_c(x & 0xF, y, z & 0xF, 0)));
                } else {
                    left.add(null);
                }
                left.add(String.format("ws: %.3f, fs: %.3f, g: %b, fl: %d", Float.valueOf(this.field_73839_d.field_71439_g.field_71075_bZ.func_75094_b()), Float.valueOf(this.field_73839_d.field_71439_g.field_71075_bZ.func_75093_a()), this.field_73839_d.field_71439_g.field_70122_E, this.field_73839_d.field_71441_e.func_72976_f(x, z)));
                if (this.field_73839_d.field_71460_t != null && this.field_73839_d.field_71460_t.func_147702_a()) {
                    left.add(String.format("shader: %s", this.field_73839_d.field_71460_t.func_147706_e().func_148022_b()));
                }
                right.add(null);
                right.addAll(FMLCommonHandler.instance().getBrandings(false).stream().collect(Collectors.toList()));
                GL11.glPopMatrix();
                this.field_73839_d.field_71424_I.func_76319_b();
                this.post(RenderGameOverlayEvent.ElementType.DEBUG);
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)(event = new RenderGameOverlayEvent.Text(this.eventParent, left, right)))) {
                int top = 20;
                for (String msg : left) {
                    if (msg == null) continue;
                    IngameGUI.func_73734_a((int)1, (int)(top - 1), (int)(2 + this.fontRenderer.func_78256_a(msg) + 1), (int)(top + this.fontRenderer.field_78288_b - 1), (int)-1873784752);
                    this.fontRenderer.func_78276_b(msg, 2, top, 0xE0E0E0);
                    top += this.fontRenderer.field_78288_b;
                }
                top = 2;
                for (String msg : right) {
                    if (msg == null) continue;
                    int w = this.fontRenderer.func_78256_a(msg);
                    int slotsY = (height - 198) / 2;
                    int leftL = width - (OptionCore.HOR_HOTBAR.getValue() || top < slotsY - this.fontRenderer.field_78288_b - 2 ? 2 : 26) - w;
                    IngameGUI.func_73734_a((int)(leftL - 1), (int)(top - 1), (int)(leftL + w + 1), (int)(top + this.fontRenderer.field_78288_b - 1), (int)-1873784752);
                    this.fontRenderer.func_78276_b(msg, leftL, top, 0xE0E0E0);
                    top += this.fontRenderer.field_78288_b;
                }
            }
            this.field_73839_d.field_71424_I.func_76319_b();
            this.post(RenderGameOverlayEvent.ElementType.TEXT);
        }
    }

    private boolean replaceEvent(RenderGameOverlayEvent.ElementType el) {
        if (this.eventParent.type == el && this.eventParent.isCanceled()) {
            this.eventParent.setCanceled(false);
            this.eventParent.setResult(Event.Result.ALLOW);
            this.pre(el);
            return true;
        }
        return false;
    }

    private boolean pre(RenderGameOverlayEvent.ElementType type) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Pre(this.eventParent, type));
    }

    private void post(RenderGameOverlayEvent.ElementType type) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(this.eventParent, type));
    }
}

