/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens.inventory;

import baubles.api.BaublesApi;
import baubles.api.IBauble;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemExpBottle;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;

@SideOnly(value=Side.CLIENT)
public enum InventoryCore {
    EQUIPMENT((stack, state) -> {
        Item item = stack.func_77973_b();
        return item instanceof ItemArmor || item instanceof ItemBlock && ((ItemBlock)item).field_150939_a instanceof BlockPumpkin;
    }),
    WEAPONS((stack, state) -> stack.func_77973_b() instanceof ItemSword),
    BOWS((stack, state) -> stack.func_77973_b() instanceof ItemBow),
    PICKAXE((stack, state) -> stack.func_77973_b() instanceof ItemPickaxe),
    AXE((stack, state) -> stack.func_77973_b() instanceof ItemAxe),
    SHOVEL((stack, state) -> stack.func_77973_b() instanceof ItemSpade),
    COMPATTOOLS((stack, state) -> {
        Item item = stack.func_77973_b();
        return item instanceof ItemTool || item instanceof ItemBow || item instanceof ItemSword;
    }),
    ACCESSORY((stack, state) -> InventoryCore.isBaublesLoaded() && stack.func_77973_b() instanceof IBauble),
    CONSUMABLES((stack, state) -> {
        Item item = stack.func_77973_b();
        return item instanceof ItemExpBottle || item instanceof ItemPotion || item instanceof ItemFood;
    }),
    ITEMS((stack, state) -> !state || !EQUIPMENT.isFine(stack, state));

    private final ItemFilter itemFilter;

    private InventoryCore(ItemFilter filter) {
        this.itemFilter = filter;
    }

    public final boolean isFine(ItemStack stack, boolean state) {
        return stack != null && this.itemFilter.filter(stack, state);
    }

    public static IInventory getBaubles(EntityPlayer player) {
        if (!InventoryCore.isBaublesLoaded()) {
            return null;
        }
        return BaublesApi.getBaubles((EntityPlayer)player);
    }

    public static boolean isBaublesLoaded() {
        return Loader.isModLoaded((String)"Baubles");
    }

    @FunctionalInterface
    private static interface ItemFilter {
        public boolean filter(ItemStack var1, boolean var2);
    }
}

