/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens.inventory;

import com.saomc.screens.Elements;
import com.saomc.screens.ListGUI;
import com.saomc.screens.ParentElement;
import com.saomc.screens.inventory.InventoryCore;
import com.saomc.screens.menu.EmptySlot;
import com.saomc.screens.menu.Slots;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

@SideOnly(value=Side.CLIENT)
public class InventoryGUI
extends ListGUI {
    public final Container slots;
    public final InventoryCore filter;
    private boolean opened;

    public InventoryGUI(ParentElement gui, int xPos, int yPos, int w, int h, Container containerSlots, InventoryCore inventory) {
        super(gui, xPos, yPos, w, h);
        this.slots = containerSlots;
        this.filter = inventory;
        this.opened = false;
    }

    @Override
    public void update(Minecraft mc) {
        if (!this.opened) {
            mc.field_71439_g.field_71070_bA = this.slots;
            this.opened = true;
        }
        super.update(mc);
        for (int i = 0; i < this.slots.field_75151_b.size(); ++i) {
            Slot slot = this.slots.func_75139_a(i);
            if (slot == null) continue;
            boolean state = this.equipped(slot.field_75222_d);
            ItemStack stack = slot.func_75211_c();
            boolean found = false;
            for (int j = this.elements.size() - 1; j >= 0; --j) {
                Slots gui;
                if (j >= this.elements.size() || !(this.elements.get(j) instanceof Slots) || (gui = (Slots)this.elements.get(j)).getSlotNumber() != slot.field_75222_d) continue;
                gui.refreshSlot(slot);
                if (gui.removed()) continue;
                if (this.filter.isFine(gui.getStack(), state)) {
                    found = true;
                    continue;
                }
                gui.remove();
            }
            if (found || stack == null || !this.filter.isFine(stack, state)) continue;
            if (state) {
                this.elements.add(0, new Slots(this, 0, this.getOffset(this.elements.size()), slot));
                continue;
            }
            this.elements.add(new Slots(this, 0, this.getOffset(this.elements.size()), slot));
        }
        if (this.elements.isEmpty()) {
            this.elements.add(new EmptySlot(this, 0, this.getOffset(this.elements.size())));
        } else {
            Slots slot = (Slots)this.elements.get(this.elements.size() - 1);
            if (slot.getSlotNumber() == -1) {
                slot.remove();
            }
        }
        this.slots.func_75142_b();
    }

    private boolean equipped(int number) {
        boolean state = this.filter.equals((Object)InventoryCore.EQUIPMENT) ? number >= 5 && number < 9 : number >= 36 && number < 45;
        return state;
    }

    @Override
    protected void update(Minecraft mc, int index, Elements element) {
        super.update(mc, index, element);
        if (element instanceof Slots) {
            Slots slot = (Slots)element;
            int number = slot.getSlotNumber();
            slot.highlight = number >= 5 && number < 9 || number >= 36 && number < 45;
        }
    }

    public void handleMouseClick(Minecraft mc, Slot slot, int slotNumber, int flag, int method) {
        if (slot != null) {
            slotNumber = slot.field_75222_d;
        }
        mc.field_71442_b.func_78753_a(this.slots.field_75152_c, slotNumber, flag, method, (EntityPlayer)mc.field_71439_g);
    }

    public void handleMouseClick(Minecraft mc, int windowID, Slot slot, int slotNumber, int flag, int method) {
        if (slot != null) {
            slotNumber = slot.field_75222_d;
        }
        mc.field_71442_b.func_78753_a(windowID, slotNumber, flag, method, (EntityPlayer)mc.field_71439_g);
    }

    @Override
    public void close(Minecraft mc) {
        super.close(mc);
        if (mc.field_71439_g != null) {
            this.slots.func_75134_a((EntityPlayer)mc.field_71439_g);
        }
    }
}

