/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens.menu;

import baubles.api.BaublesApi;
import com.saomc.SoundCore;
import com.saomc.events.ConfigHandler;
import com.saomc.events.FriendsHandler;
import com.saomc.screens.ContainerGUI;
import com.saomc.screens.Elements;
import com.saomc.screens.IconGUI;
import com.saomc.screens.LabelGUI;
import com.saomc.screens.ListGUI;
import com.saomc.screens.MenuGUI;
import com.saomc.screens.ParentElement;
import com.saomc.screens.TextGUI;
import com.saomc.screens.buttons.Actions;
import com.saomc.screens.buttons.ButtonGUI;
import com.saomc.screens.buttons.ButtonState;
import com.saomc.screens.buttons.OptionButton;
import com.saomc.screens.buttons.SkillButton;
import com.saomc.screens.ingame.IngameGUI;
import com.saomc.screens.inventory.InventoryCore;
import com.saomc.screens.inventory.InventoryGUI;
import com.saomc.screens.menu.Categories;
import com.saomc.screens.menu.EmptySlot;
import com.saomc.screens.menu.Panel;
import com.saomc.screens.menu.Slots;
import com.saomc.screens.window.ScreenGUI;
import com.saomc.screens.window.SubWindow;
import com.saomc.screens.window.WindowAlign;
import com.saomc.screens.window.WindowView;
import com.saomc.screens.window.ui.AchievementList;
import com.saomc.social.StaticPlayerHelper;
import com.saomc.social.friends.FriendCore;
import com.saomc.social.friends.FriendList;
import com.saomc.social.party.PartyHandler;
import com.saomc.social.party.PartyHelper;
import com.saomc.util.ColorUtil;
import com.saomc.util.IconCore;
import com.saomc.util.J8String;
import com.saomc.util.JString;
import com.saomc.util.OptionCore;
import com.saomc.util.Skills;
import com.saomc.util.Strings;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class IngameMenuGUI
extends ScreenGUI {
    private final List<Map.Entry<Categories, MenuGUI>> menus;
    private final Strings[] infoData = new Strings[2];
    private final GuiInventory parentInv;
    public World world;
    private int flowY;
    private int flowX;
    private int jumpX;
    private OptionCore openOptCat = null;
    private MenuGUI sub;
    private Panel info;
    private LabelGUI infoCaption;
    private TextGUI infoText;
    private boolean playedSound;

    public IngameMenuGUI(GuiInventory vanillaGUI) {
        this.menus = new ArrayList<Map.Entry<Categories, MenuGUI>>();
        this.parentInv = vanillaGUI;
        this.info = null;
    }

    @Override
    protected void init() {
        super.init();
        this.menus.clear();
        IconGUI action1 = new IconGUI((ParentElement)this, Categories.PROFILE, 0, 0, IconCore.PROFILE);
        this.elements.add(action1);
        IconGUI action2 = new IconGUI((ParentElement)action1, Categories.SOCIAL, 0, 24, IconCore.SOCIAL);
        this.elements.add(action2);
        IconGUI action = new IconGUI((ParentElement)action2, Categories.MESSAGE, 0, 24, IconCore.MESSAGE);
        this.elements.add(action);
        action = new IconGUI((ParentElement)action, Categories.NAVIGATION, 0, 24, IconCore.NAVIGATION);
        this.elements.add(action);
        action = new IconGUI((ParentElement)action, Categories.SETTINGS, 0, 24, IconCore.SETTINGS);
        this.elements.add(action);
        if (this.parentInv != null) {
            this.openMenu(action1, action1.ID());
        }
        this.flowY = -this.field_146295_m;
    }

    @Override
    public void func_73863_a(int cursorX, int cursorY, float f) {
        super.func_73863_a(cursorX, cursorY, f);
        if (!this.playedSound) {
            SoundCore.play(this.field_146297_k, "sao.orb.dropdown");
            this.playedSound = true;
        }
    }

    @Override
    public int getX(boolean relative) {
        return super.getX(relative) + this.field_146294_l * 2 / 5 + (this.flowX - this.jumpX) / 2;
    }

    @Override
    public int getY(boolean relative) {
        return super.getY(relative) + this.flowY;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.flowY < this.field_146295_m / 2) {
            this.flowY = (this.flowY + this.field_146295_m / 2 - 32) / 2;
        }
        this.flowX /= 2;
        if (this.infoData[0] != null && this.infoData[1] != null) {
            this.updateInfo(this.infoData[0].toString(), this.infoData[1].toString());
        }
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        SoundCore.play(this.field_146297_k, "sao.dialog.close");
    }

    @Override
    public void actionPerformed(Elements element, Actions action, int data) {
        Categories id = element.ID();
        if (id.isMenu()) {
            if (this.isMenuOpen(id)) {
                element.click(this.field_146297_k.func_147118_V(), false);
                this.closeMenu(element, id);
            } else {
                element.click(this.field_146297_k.func_147118_V(), true);
                this.openMenu(element, id);
            }
        } else if (id != Categories.NONE) {
            element.click(this.field_146297_k.func_147118_V(), false);
            this.action(element, id, action, data);
        }
    }

    private boolean isMenuOpen(Categories id) {
        return this.menus.stream().anyMatch(entry -> entry.getKey() == id);
    }

    private void action(Elements element, Categories id, Actions action, int data) {
        if (id == Categories.MENU) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiIngameMenu());
        } else if (id == Categories.SLOT && element instanceof Slots && element.parent instanceof InventoryGUI) {
            Slots slot = (Slots)element;
            InventoryGUI inventory = (InventoryGUI)element.parent;
            InventoryCore type = inventory.filter;
            Container container = inventory.slots;
            ItemStack stack = slot.getStack();
            if (stack != null) {
                if (action == Actions.LEFT_RELEASED) {
                    Slot current = this.findSwapSlot(container, slot.getSlot(), type);
                    if (type == InventoryCore.ACCESSORY) {
                        if (InventoryCore.isBaublesLoaded() && current != null && current.field_75222_d != slot.getSlotNumber()) {
                            IInventory inventoryBauble = BaublesApi.getBaubles((EntityPlayer)this.field_146297_k.field_71439_g);
                            inventory.handleMouseClick(this.field_146297_k, slot.getSlot(), slot.getSlotNumber(), 0, 0);
                            inventory.handleMouseClick(this.field_146297_k, current, current.field_75222_d, 0, 0);
                            inventory.handleMouseClick(this.field_146297_k, slot.getSlot(), slot.getSlotNumber(), 0, 0);
                        }
                    } else if (current != null && current.field_75222_d != slot.getSlotNumber()) {
                        inventory.handleMouseClick(this.field_146297_k, slot.getSlot(), slot.getSlotNumber(), 0, 0);
                        inventory.handleMouseClick(this.field_146297_k, current, current.field_75222_d, 0, 0);
                        inventory.handleMouseClick(this.field_146297_k, slot.getSlot(), slot.getSlotNumber(), 0, 0);
                    }
                } else if (action == Actions.RIGHT_RELEASED) {
                    inventory.handleMouseClick(this.field_146297_k, slot.getSlot(), slot.getSlotNumber(), 1, 4);
                } else if (action == Actions.MIDDLE_RELEASED || action == Actions.KEY_TYPED && data == this.field_146297_k.field_71474_y.field_74322_I.func_151463_i()) {
                    JString caption = null;
                    StringBuilder text = new StringBuilder();
                    for (Object line : stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, false)) {
                        if (caption != null) {
                            text.append(line).append('\n');
                            continue;
                        }
                        caption = new JString(line);
                    }
                    this.setInfo(caption, new JString(text.toString()));
                } else if (action == Actions.KEY_TYPED && data == this.field_146297_k.field_71474_y.field_74316_C.func_151463_i()) {
                    inventory.handleMouseClick(this.field_146297_k, slot.getSlot(), slot.getSlotNumber(), 0, 4);
                }
            }
        } else if (id == Categories.SKILL && element instanceof SkillButton) {
            ((SkillButton)element).action(this.field_146297_k, this.parentInv);
        } else if (id == Categories.INVITE_PLAYER && element instanceof ButtonGUI) {
            String name = ((ButtonGUI)element).caption;
            PartyHelper.instance().invite(this.field_146297_k, name);
        } else if (id == Categories.DISSOLVE) {
            element.enabled = false;
            boolean isLeader = PartyHelper.instance().isLeader(StaticPlayerHelper.getName(this.field_146297_k));
            String title = isLeader ? ConfigHandler._PARTY_DISSOLVING_TITLE : ConfigHandler._PARTY_LEAVING_TITLE;
            String text = isLeader ? ConfigHandler._PARTY_DISSOLVING_TEXT : ConfigHandler._PARTY_LEAVING_TEXT;
            this.field_146297_k.func_147108_a((GuiScreen)WindowView.viewConfirm(title, text, (element1, action1, data1) -> {
                Categories id1 = element1.ID();
                if (id1 == Categories.CONFIRM) {
                    PartyHelper.instance().sendDissolve(this.field_146297_k);
                }
                this.field_146297_k.func_147108_a(null);
                this.field_146297_k.func_71381_h();
            }));
        } else if (id != Categories.MESSAGE || !(this.field_146297_k.field_71456_v instanceof IngameGUI)) {
            if (id == Categories.MESSAGE_BOX && element.parent instanceof MenuGUI && ((MenuGUI)element.parent).parent instanceof FriendCore) {
                String username = ((FriendCore)((MenuGUI)element.parent).parent).caption;
                String format = I18n.func_135052_a((String)"commands.message.usage", (Object[])new Object[0]);
                String cmd = format.substring(0, format.indexOf(32));
                String message = J8String.join(" ", cmd, username, "");
                this.field_146297_k.func_147108_a((GuiScreen)new GuiChat(message));
            } else if (id == Categories.QUEST && element instanceof AchievementList) {
                AchievementList quest = (AchievementList)element;
                Achievement ach0 = quest.getAchievement();
                this.setInfo(new JString(quest.caption), new JString(ach0.func_75989_e()));
            } else if (id == Categories.OPTION && element instanceof OptionButton) {
                OptionButton button = (OptionButton)element;
                if (button.getOption() == OptionCore.VANILLA_OPTIONS) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiOptions((GuiScreen)this, this.field_146297_k.field_71474_y));
                } else if (button.getOption().isRestricted()) {
                    this.reloadList(element, id);
                    button.action();
                } else {
                    button.action();
                }
            } else if (id == Categories.LOGOUT && OptionCore.LOGOUT.getValue()) {
                element.enabled = false;
                this.field_146297_k.field_71441_e.func_72882_A();
                this.field_146297_k.func_71403_a(null);
                this.field_146297_k.func_147108_a((GuiScreen)new GuiMainMenu());
            }
        }
    }

    private Slot findSwapSlot(Container container, Slot swap, InventoryCore type) {
        if (type == InventoryCore.EQUIPMENT) {
            if (swap.field_75222_d < 9) {
                return this.findEmptySlot(container, 9);
            }
            for (int i = 5; i < 9; ++i) {
                if (!container.func_75139_a(i).func_75214_a(swap.func_75211_c())) continue;
                return container.func_75139_a(i);
            }
            return null;
        }
        if (type == InventoryCore.WEAPONS) {
            return swap.field_75222_d >= 36 ? this.findEmptySlot(container, 9) : container.func_75139_a(36);
        }
        if (type == InventoryCore.BOWS) {
            return swap.field_75222_d >= 37 ? this.findEmptySlot(container, 9) : container.func_75139_a(37);
        }
        if (type == InventoryCore.PICKAXE) {
            return swap.field_75222_d >= 38 ? this.findEmptySlot(container, 9) : container.func_75139_a(38);
        }
        if (type == InventoryCore.AXE) {
            return swap.field_75222_d >= 39 ? this.findEmptySlot(container, 9) : container.func_75139_a(39);
        }
        if (type == InventoryCore.SHOVEL) {
            return swap.field_75222_d >= 40 ? this.findEmptySlot(container, 9) : container.func_75139_a(40);
        }
        if (type == InventoryCore.ACCESSORY) {
            IInventory baubles = InventoryCore.getBaubles((EntityPlayer)this.field_146297_k.field_71439_g);
            if (baubles != null) {
                if (Objects.equals(swap.field_75224_c, baubles)) {
                    return this.findEmptySlot(container, 9);
                }
                for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                    if (!baubles.func_94041_b(i, swap.func_75211_c())) continue;
                    return container.func_75139_a(i);
                }
            }
            return null;
        }
        if (type == InventoryCore.CONSUMABLES) {
            return swap.field_75222_d >= 41 ? this.findEmptySlot(container, 9) : container.func_75139_a(41);
        }
        if (type == InventoryCore.ITEMS) {
            if (swap.field_75222_d >= 42) {
                return this.findEmptySlot(container, 9);
            }
            Slot slot = this.findEmptySlot(container, 42);
            if (slot == null) {
                return this.currentSlot(container);
            }
            return slot;
        }
        return null;
    }

    private Slot currentSlot(Container container) {
        return container.func_75147_a((IInventory)this.field_146297_k.field_71439_g.field_71071_by, this.field_146297_k.field_71439_g.field_71071_by.field_70461_c);
    }

    @Optional.Method(modid="Baubles")
    private Slot currentBaubleSlot(Container container) {
        return container.func_75147_a(BaublesApi.getBaubles((EntityPlayer)this.field_146297_k.field_71439_g), this.field_146297_k.field_71439_g.field_71071_by.field_70461_c);
    }

    private Slot findEmptySlot(Container container, int startIndex) {
        Optional<Object> optSlot = container.field_75151_b.stream().skip(startIndex - 1).filter(obj -> !((Slot)obj).func_75216_d()).findFirst();
        return optSlot.orElse(null);
    }

    private void updateInfo(String caption, String text) {
        if (this.info != null) {
            if (this.infoCaption == null) {
                this.infoCaption = new LabelGUI(this.info, 15, 0, this.info.width - 15, caption, WindowAlign.LEFT);
                this.info.elements.add(this.infoCaption);
                this.infoCaption.fontColor = ColorUtil.DEFAULT_BOX_FONT_COLOR;
            } else {
                this.infoCaption.caption = caption;
            }
            if (this.infoText == null) {
                this.infoText = new TextGUI((ParentElement)this.info, 15, 0, text, this.info.width - 15);
                this.info.elements.add(this.infoText);
                this.infoText.fontColor = ColorUtil.DEFAULT_BOX_FONT_COLOR;
            } else {
                this.infoText.setText(text);
            }
        }
    }

    private void setInfo(Strings caption, Strings text) {
        this.infoData[0] = caption;
        this.infoData[1] = text;
        this.updateInfo(this.infoData[0] != null ? this.infoData[0].toString() : "", this.infoData[1] != null ? this.infoData[1].toString() : "");
    }

    private void openMenu(Elements element, Categories id) {
        Strings[] position;
        EntityPlayer player;
        MenuGUI mnu;
        int menuOffsetX = element.width + 14;
        int menuOffsetY = element.height / 2;
        MenuGUI menu = null;
        MenuGUI subMenu = this.sub;
        if (id == Categories.PROFILE) {
            menu = new MenuGUI(element, menuOffsetX, menuOffsetY, 100, 60);
            menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.EQUIPMENT, 0, 0, StatCollector.func_74838_a((String)"guiEquipment"), IconCore.EQUIPMENT));
            menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.ITEMS, 0, 0, StatCollector.func_74838_a((String)"guiItems"), IconCore.ITEMS));
            menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.SKILLS, 0, 0, StatCollector.func_74838_a((String)"guiSkills"), IconCore.SKILLS));
            this.sub = SubWindow.createMainProfileSub(this.field_146297_k, element, -189, menuOffsetY);
            this.info = SubWindow.addInfo(this.sub);
            Strings[] profile = SubWindow.addProfileContent(this.field_146297_k);
            this.setInfo(profile[0], profile[1]);
        } else if (id == Categories.SOCIAL) {
            this.setInfo(null, null);
            menu = new MenuGUI(element, menuOffsetX, menuOffsetY, 100, 60);
            menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.GUILD, 0, 0, StatCollector.func_74838_a((String)"guiGuild"), IconCore.GUILD));
            menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.PARTY, 0, 0, StatCollector.func_74838_a((String)"guiParty"), IconCore.PARTY));
            menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.FRIENDS, 0, 0, StatCollector.func_74838_a((String)"guiFriends"), IconCore.FRIEND));
            this.sub = SubWindow.createSocialSub(this.field_146297_k, element, -189, menuOffsetY);
            this.info = SubWindow.addInfo(this.sub);
            this.infoCaption = null;
            this.infoText = null;
        } else if (id == Categories.MESSAGE) {
            this.setInfo(null, null);
            menu = new MenuGUI(element, menuOffsetX, menuOffsetY, 100, 60);
            menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.MESSAGE_BOX, 0, 0, StatCollector.func_74838_a((String)"guiMessageBox"), IconCore.MESSAGE));
            this.sub = SubWindow.createSocialSub(this.field_146297_k, element, -189, menuOffsetY);
            this.info = SubWindow.addInfo(this.sub);
            this.infoCaption = null;
            this.infoText = null;
        } else if (id == Categories.NAVIGATION) {
            this.setInfo(null, null);
            menu = new MenuGUI(element, menuOffsetX, menuOffsetY, 100, 60);
            menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.QUESTS, 0, 0, StatCollector.func_74838_a((String)"guiQuest"), IconCore.QUEST));
            if (OptionCore.DEBUG_MODE.getValue()) {
                menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.FIELD_MAP, 0, 0, StatCollector.func_74838_a((String)"guiFieldMap"), IconCore.FIELD_MAP));
            }
            if (OptionCore.DEBUG_MODE.getValue()) {
                menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.DUNGEON_MAP, 0, 0, StatCollector.func_74838_a((String)"guiDungMap"), IconCore.DUNGEON_MAP));
            }
            this.sub = SubWindow.createNavigationSub(this.field_146297_k, element, -189, menuOffsetY);
            this.info = SubWindow.addInfo(this.sub);
        } else if (id == Categories.SETTINGS) {
            menu = new MenuGUI(element, menuOffsetX, menuOffsetY, 100, 60);
            menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.OPTIONS, 0, 0, StatCollector.func_74838_a((String)"guiOption"), IconCore.OPTION));
            menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.MENU, 0, 0, StatCollector.func_74838_a((String)"guiMenu"), IconCore.HELP));
            menu.elements.add(new ButtonState((ParentElement)menu, Categories.LOGOUT, 0, 0, OptionCore.LOGOUT.getValue() ? StatCollector.func_74838_a((String)"guiLogout") : "", IconCore.LOGOUT, (mc1, button) -> {
                if (OptionCore.LOGOUT.getValue()) {
                    if (button.caption.length() == 0) {
                        button.caption = "Logout";
                    }
                } else if (button.caption.length() > 0) {
                    button.caption = "";
                }
                return button.enabled;
            }));
        } else if (id == Categories.EQUIPMENT) {
            menu = new MenuGUI(element, menuOffsetX, menuOffsetY, 100, 60);
            if (InventoryCore.WEAPONS != null || InventoryCore.BOWS != null || InventoryCore.PICKAXE != null || InventoryCore.AXE != null || InventoryCore.SHOVEL != null) {
                menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.TOOLS, 0, 0, StatCollector.func_74838_a((String)"guiTools"), IconCore.EQUIPMENT));
            }
            menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.ARMOR, 0, 0, StatCollector.func_74838_a((String)"guiEquipped"), IconCore.ARMOR));
            if (InventoryCore.isBaublesLoaded()) {
                menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.ACCESSORY, 0, 0, StatCollector.func_74838_a((String)"guiAccessory"), IconCore.ACCESSORY));
            }
            menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.CONSUMABLES, 0, 0, StatCollector.func_74838_a((String)"guiConsumable"), IconCore.ITEMS));
        } else if (id == Categories.ITEMS) {
            menu = new InventoryGUI(element, menuOffsetX, menuOffsetY, 150, 100, this.field_146297_k.field_71439_g.field_71069_bz, InventoryCore.ITEMS);
        } else if (id == Categories.SKILLS) {
            mnu = menu = new ListGUI(element, menuOffsetX, menuOffsetY, 100, 60);
            Stream.of(Skills.values()).forEach(skill -> mnu.elements.add(new SkillButton(mnu, 0, 0, (Skills)((Object)skill))));
        } else if (id == Categories.TOOLS) {
            if (OptionCore.COMPACT_INVENTORY.getValue()) {
                menu = new InventoryGUI(element, menuOffsetX, menuOffsetY, 150, 100, this.field_146297_k.field_71439_g.field_71069_bz, InventoryCore.COMPATTOOLS);
            } else {
                menu = new MenuGUI(element, menuOffsetX, menuOffsetY, 100, 60);
                if (this.field_146297_k.field_71439_g.field_71069_bz.func_75138_a().stream().filter(st -> st != null).anyMatch(st -> InventoryCore.WEAPONS.isFine((ItemStack)st, true))) {
                    menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.WEAPONS, 0, 0, StatCollector.func_74838_a((String)"guiWeapons"), IconCore.EQUIPMENT));
                }
                if (this.field_146297_k.field_71439_g.field_71069_bz.func_75138_a().stream().filter(st -> st != null).anyMatch(st -> InventoryCore.BOWS.isFine((ItemStack)st, true))) {
                    menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.BOWS, 0, 0, StatCollector.func_74838_a((String)"guiBows"), IconCore.EQUIPMENT));
                }
                if (this.field_146297_k.field_71439_g.field_71069_bz.func_75138_a().stream().filter(st -> st != null).anyMatch(st -> InventoryCore.PICKAXE.isFine((ItemStack)st, true))) {
                    menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.PICKAXE, 0, 0, StatCollector.func_74838_a((String)"guiPickaxes"), IconCore.EQUIPMENT));
                }
                if (this.field_146297_k.field_71439_g.field_71069_bz.func_75138_a().stream().filter(st -> st != null).anyMatch(st -> InventoryCore.AXE.isFine((ItemStack)st, true))) {
                    menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.AXE, 0, 0, StatCollector.func_74838_a((String)"guiAxes"), IconCore.EQUIPMENT));
                }
                if (this.field_146297_k.field_71439_g.field_71069_bz.func_75138_a().stream().filter(st -> st != null).anyMatch(st -> InventoryCore.SHOVEL.isFine((ItemStack)st, true))) {
                    menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.SHOVEL, 0, 0, StatCollector.func_74838_a((String)"guiShovels"), IconCore.EQUIPMENT));
                }
                if (menu.elements.isEmpty()) {
                    menu.elements.add(new EmptySlot(menu, 0, 0));
                }
            }
        } else if (id == Categories.WEAPONS) {
            menu = new InventoryGUI(element, menuOffsetX, menuOffsetY, 150, 100, this.field_146297_k.field_71439_g.field_71069_bz, InventoryCore.WEAPONS);
        } else if (id == Categories.BOWS) {
            menu = new InventoryGUI(element, menuOffsetX, menuOffsetY, 150, 100, this.field_146297_k.field_71439_g.field_71069_bz, InventoryCore.BOWS);
        } else if (id == Categories.PICKAXE) {
            menu = new InventoryGUI(element, menuOffsetX, menuOffsetY, 150, 100, this.field_146297_k.field_71439_g.field_71069_bz, InventoryCore.PICKAXE);
        } else if (id == Categories.AXE) {
            menu = new InventoryGUI(element, menuOffsetX, menuOffsetY, 150, 100, this.field_146297_k.field_71439_g.field_71069_bz, InventoryCore.AXE);
        } else if (id == Categories.SHOVEL) {
            menu = new InventoryGUI(element, menuOffsetX, menuOffsetY, 150, 100, this.field_146297_k.field_71439_g.field_71069_bz, InventoryCore.SHOVEL);
        } else if (id == Categories.ARMOR) {
            menu = new InventoryGUI(element, menuOffsetX, menuOffsetY, 150, 100, this.field_146297_k.field_71439_g.field_71069_bz, InventoryCore.EQUIPMENT);
        } else if (id == Categories.ACCESSORY) {
            if (InventoryCore.isBaublesLoaded()) {
                menu = new InventoryGUI(element, menuOffsetX, menuOffsetY, 150, 100, this.field_146297_k.field_71439_g.field_71069_bz, InventoryCore.ACCESSORY);
            } else {
                menu.elements.add(new EmptySlot(menu, 0, 0));
            }
        } else if (id == Categories.CONSUMABLES) {
            menu = new InventoryGUI(element, menuOffsetX, menuOffsetY, 150, 100, this.field_146297_k.field_71439_g.field_71069_bz, InventoryCore.CONSUMABLES);
        } else if (id == Categories.PARTY) {
            menu = new MenuGUI(element, menuOffsetX, menuOffsetY, 100, 60);
            menu.elements.add(new PartyHandler((ParentElement)menu, Categories.INVITE_LIST, 0, 0, StatCollector.func_74838_a((String)"guiInvite"), IconCore.INVITE));
            menu.elements.add(new PartyHandler((ParentElement)menu, Categories.DISSOLVE, 0, 0, StatCollector.func_74838_a((String)"guiDissolve"), IconCore.CANCEL));
            this.sub = SubWindow.resetPartySub(this.field_146297_k, this.sub);
            this.info = SubWindow.addInfo(this.sub);
        } else if (id == Categories.FRIENDS) {
            this.setInfo(null, null);
            menu = new FriendList(this.field_146297_k, element, menuOffsetX, menuOffsetY, 100, 100);
            this.sub = SubWindow.resetFriendsSub(this.field_146297_k, this.sub);
            this.info = SubWindow.addInfo(this.sub);
            this.infoCaption = null;
            this.infoText = null;
        } else if (id == Categories.INVITE_LIST) {
            mnu = menu = new ListGUI(element, menuOffsetX, menuOffsetY, 100, 60);
            if (StaticPlayerHelper.listOnlinePlayers(this.field_146297_k) != null) {
                StaticPlayerHelper.listOnlinePlayers(this.field_146297_k, true, 5.0).stream().map(StaticPlayerHelper::getName).forEach(name -> {
                    ButtonState button = new ButtonState((ParentElement)mnu, Categories.INVITE_PLAYER, 0, 0, (String)name, IconCore.INVITE, (mc1, button1) -> !PartyHelper.instance().isMember(button1.caption));
                    button.enabled = !PartyHelper.instance().isMember((String)name);
                    mnu.elements.add(button);
                });
            }
        } else if (id == Categories.FRIEND && element instanceof FriendCore) {
            this.setInfo(null, null);
            if (((FriendCore)element).highlight) {
                System.out.println("Add friends menu request");
                menu = new MenuGUI(element, menuOffsetX, menuOffsetY, 100, 60);
                menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.POSITION_CHECK, 0, 0, StatCollector.func_74838_a((String)"guiPositionCheck"), IconCore.FIELD_MAP));
                menu.elements.add(new ButtonGUI((ParentElement)menu, Categories.OTHER_PROFILE, 0, 0, StatCollector.func_74838_a((String)"guiProfile"), IconCore.PARTY));
            } else {
                menu = null;
                System.out.println("Add friend request");
                FriendsHandler.instance().addFriendRequests(this.field_146297_k, ((FriendCore)element).caption);
            }
        } else if (id == Categories.OTHER_PROFILE && element.parent instanceof MenuGUI && ((MenuGUI)element.parent).parent instanceof FriendCore) {
            menu = null;
            player = StaticPlayerHelper.findOnlinePlayer(this.field_146297_k, ((FriendCore)((MenuGUI)element.parent).parent).caption);
            if (player != null) {
                this.sub = SubWindow.resetProfileSub(this.field_146297_k, this.sub, player);
                this.info = SubWindow.addInfo(this.sub);
                this.infoCaption = null;
                this.infoText = null;
                Strings[] profile = SubWindow.addProfileContent(player);
                this.setInfo(profile[0], profile[1]);
            } else {
                this.setInfo(null, null);
            }
        } else if (id == Categories.POSITION_CHECK && element.parent instanceof MenuGUI && ((MenuGUI)element.parent).parent instanceof FriendCore) {
            menu = null;
            player = StaticPlayerHelper.findOnlinePlayer(this.field_146297_k, ((FriendCore)((MenuGUI)element.parent).parent).caption);
            if (player != null) {
                this.sub = SubWindow.resetCheckPositionSub(this.field_146297_k, this.sub, player, 1, null);
                this.info = SubWindow.addInfo(this.sub);
                Strings[] position2 = SubWindow.addPositionContent(player, (EntityPlayer)this.field_146297_k.field_71439_g);
                this.setInfo(position2[0], position2[1]);
            } else {
                this.setInfo(null, null);
            }
        } else if (id == Categories.QUESTS) {
            this.setInfo(null, null);
            menu = null;
            this.sub = SubWindow.resetQuestsSub(this.field_146297_k, this.sub, (EntityPlayer)this.field_146297_k.field_71439_g);
            this.info = SubWindow.addInfo(this.sub);
        } else if (id == Categories.FIELD_MAP) {
            menu = null;
            this.sub = SubWindow.resetCheckPositionSub(this.field_146297_k, this.sub, (EntityPlayer)this.field_146297_k.field_71439_g, 4, '-' + StatCollector.func_74838_a((String)"guiFieldMap") + '-');
            this.info = SubWindow.addInfo(this.sub);
            position = SubWindow.addPositionContent((EntityPlayer)this.field_146297_k.field_71439_g, (EntityPlayer)this.field_146297_k.field_71439_g);
            this.setInfo(position[0], position[1]);
        } else if (id == Categories.DUNGEON_MAP) {
            this.setInfo(null, null);
            menu = null;
            this.sub = SubWindow.resetCheckPositionSub(this.field_146297_k, this.sub, (EntityPlayer)this.field_146297_k.field_71439_g, 1, '-' + StatCollector.func_74838_a((String)"guiDungMap") + '-');
            this.info = SubWindow.addInfo(this.sub);
            position = SubWindow.addPositionContent((EntityPlayer)this.field_146297_k.field_71439_g, (EntityPlayer)this.field_146297_k.field_71439_g);
            this.setInfo(position[0], position[1]);
        } else if (id == Categories.OPTIONS) {
            mnu = menu = new ListGUI(element, menuOffsetX, menuOffsetY, 130, 100);
            Stream.of(OptionCore.values()).filter(opt -> opt.category == null).forEach(option -> mnu.elements.add(new OptionButton(mnu, 0, 0, (OptionCore)((Object)option))));
        } else if (id == Categories.OPT_CAT) {
            this.openOptCat = ((OptionButton)element).getOption();
            mnu = menu = new ListGUI(element, menuOffsetX, menuOffsetY, 130, 100);
            Stream.of(OptionCore.values()).filter(opt -> opt.category == this.openOptCat).forEach(option -> mnu.elements.add(new OptionButton(mnu, 0, 0, (OptionCore)((Object)option))));
        }
        if (this.sub != subMenu && subMenu != null) {
            this.menus.removeIf(entry -> entry.getValue() == subMenu);
            this.elements.remove(subMenu);
        }
        if (menu != null) {
            List<Elements> list = element.parent != null && element.parent instanceof ContainerGUI ? ((ContainerGUI)element.parent).elements : this.elements;
            for (Elements element0 : list) {
                if (element0.ID() == id) {
                    if (element0 instanceof ButtonGUI) {
                        if (id == Categories.OPT_CAT) {
                            OptionCore curr = this.openOptCat;
                            OptionCore comp = OptionCore.fromString(((ButtonGUI)element0).caption);
                            while (curr == comp) {
                                ((ButtonGUI)element0).highlight = curr == this.openOptCat;
                                curr = curr.category;
                            }
                            continue;
                        }
                        ((ButtonGUI)element0).highlight = true;
                        continue;
                    }
                    if (!(element0 instanceof IconGUI)) continue;
                    ((IconGUI)element0).highlight = true;
                    continue;
                }
                element0.enabled = false;
            }
            this.openMenu(id, menu);
            if (this.sub != subMenu && this.sub != null) {
                this.openMenu(id, this.sub);
            }
        }
    }

    private void moveX(int mode, MenuGUI menu) {
        int value = menu.x > 0 ? menu.x + menu.width : menu.x;
        this.jumpX += mode * value;
        this.flowX += mode * value;
    }

    private void openMenu(final Categories id, final MenuGUI menu) {
        this.moveX(1, menu);
        this.menus.add(new Map.Entry<Categories, MenuGUI>(){

            @Override
            public MenuGUI setValue(MenuGUI none) {
                return null;
            }

            @Override
            public MenuGUI getValue() {
                return menu;
            }

            @Override
            public Categories getKey() {
                return id;
            }
        });
        this.elements.add(menu);
    }

    private void closeMenu(Elements element, Categories id) {
        for (int i = this.menus.size() - 1; i >= 0; --i) {
            Map.Entry<Categories, MenuGUI> entry = this.menus.get(i);
            if (id == Categories.MENU || !entry.getKey().hasParent(id) && entry.getKey() != id) continue;
            if (entry.getValue().elements.contains(this.info)) {
                this.info = null;
                this.infoCaption = null;
                this.infoText = null;
            }
            if (entry.getValue() == this.sub) {
                this.sub = null;
            }
            this.moveX(-1, entry.getValue());
            this.elements.remove(entry.getValue());
            this.menus.remove(i);
        }
        if (id != Categories.MENU && element != null) {
            List<Elements> list = element.parent != null && element.parent instanceof ContainerGUI ? ((ContainerGUI)element.parent).elements : this.elements;
            for (Elements element0 : list) {
                if (element0.ID() == id) {
                    if (element0 instanceof ButtonGUI) {
                        ((ButtonGUI)element0).highlight = false;
                        continue;
                    }
                    if (!(element0 instanceof IconGUI)) continue;
                    ((IconGUI)element0).highlight = false;
                    continue;
                }
                element0.enabled = true;
            }
        }
    }

    private void reloadList(Elements element, Categories id) {
        if (element != null) {
            List<Elements> list = element.parent != null && element.parent instanceof ContainerGUI ? ((ContainerGUI)element.parent).elements : this.elements;
            for (Elements element0 : list) {
                if (element0.ID() == id) {
                    if (!((ButtonGUI)element0).highlight || ((OptionButton)element).getOption().getValue()) continue;
                    ((ButtonGUI)element0).highlight = false;
                    continue;
                }
                element0.enabled = true;
            }
        }
    }
}

