/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens.menu;

import com.saomc.GLCore;
import com.saomc.screens.ParentElement;
import com.saomc.screens.buttons.ButtonGUI;
import com.saomc.screens.inventory.InventoryCore;
import com.saomc.screens.menu.Categories;
import com.saomc.util.ColorUtil;
import com.saomc.util.IconCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class Slots
extends ButtonGUI {
    private static final String UNKNOWN = "???";
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private Slot buttonSlot;
    protected static RenderItem itemRender = new RenderItem();

    public Slots(ParentElement gui, int xPos, int yPos, int w, int h, Slot slot) {
        super(gui, Categories.SLOT, xPos, yPos, w, h);
        this.buttonSlot = slot;
        this.caption = this.getCaption();
        this.icon = this.getIcon();
    }

    public Slots(ParentElement gui, int xPos, int yPos, int w, Slot slot) {
        this(gui, xPos, yPos, w, 20, slot);
    }

    public Slots(ParentElement gui, int xPos, int yPos, Slot slot) {
        this(gui, xPos, yPos, 150, slot);
    }

    public static IconCore getIcon(ItemStack stack) {
        if (stack != null) {
            if (InventoryCore.WEAPONS.isFine(stack, false)) {
                return IconCore.EQUIPMENT;
            }
            if (InventoryCore.EQUIPMENT.isFine(stack, false)) {
                return IconCore.ARMOR;
            }
            if (InventoryCore.ACCESSORY.isFine(stack, false)) {
                return IconCore.ACCESSORY;
            }
            return IconCore.ITEMS;
        }
        return IconCore.HELP;
    }

    protected IconCore getIcon() {
        return Slots.getIcon(this.buttonSlot.func_75211_c());
    }

    protected String getCaption() {
        return this.buttonSlot.func_75216_d() && this.buttonSlot.func_75211_c().func_77973_b() != null ? this.buttonSlot.func_75211_c().func_82833_r() : UNKNOWN;
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        if (this.visibility > 0.0f && this.enabled) {
            int left = this.getX(false);
            int top = this.getY(false);
            int iconOffset = (this.height - 16) / 2;
            ItemStack stack = this.getStack();
            if (stack != null) {
                GLCore.glString("x" + stack.field_77994_a, left + this.width + 2, top + this.height - 16, ColorUtil.multiplyAlpha(this.getColor(this.hoverState(cursorX, cursorY), false), this.visibility), true);
                this.drawSlot(mc, stack, left + iconOffset, top + iconOffset);
            }
        }
    }

    private void drawSlot(Minecraft mc, ItemStack stack, int x, int y) {
        RenderHelper.func_74520_c();
        itemRender.renderItemIntoGUI(mc.field_71466_p, mc.func_110434_K(), stack, x, y, false);
        RenderHelper.func_74518_a();
        if (stack.func_77948_v()) {
            this.renderEffectSlot(mc, x - 1, y - 1);
        } else {
            GLCore.glBlend(true);
            GLCore.glAlphaTest(true);
        }
    }

    private void renderEffectSlot(Minecraft mc, int x, int y) {
        GLCore.glDepthFunc(514);
        GLCore.depthMask(false);
        mc.func_110434_K().func_110577_a(RES_ITEM_GLINT);
        GLCore.glAlphaTest(true);
        GLCore.glBlend(true);
        GLCore.glColor(0.5f, 0.25f, 0.8f, 1.0f);
        this.renderGlintSlot(x, y, 150, 20);
        GLCore.tryBlendFuncSeparate(770, 771, 1, 0);
        GLCore.depthMask(true);
        GLCore.glDepthFunc(515);
    }

    private void renderGlintSlot(int x, int y, int width, int height) {
        for (int j1 = 0; j1 < 2; ++j1) {
            GLCore.tryBlendFuncSeparate(772, 1, 0, 0);
            float f = 0.00390625f;
            float f1 = 0.00390625f;
            float f2 = (float)(Minecraft.func_71386_F() % (long)(3000 + j1 * 1873)) / (3000.0f + (float)(j1 * 1873)) * 256.0f;
            float f3 = 0.0f;
            float f4 = 4.0f;
            if (j1 == 1) {
                f4 = -1.0f;
            }
            GLCore.begin();
            GLCore.addVertex(x, y + height, Slots.itemRender.field_77023_b, (f2 + (float)height * f4) * f, (f3 + (float)height) * f1);
            GLCore.addVertex(x + width, y + height, Slots.itemRender.field_77023_b, (f2 + (float)width + (float)height * f4) * f, (f3 + (float)height) * f1);
            GLCore.addVertex(x + width, y, Slots.itemRender.field_77023_b, (f2 + (float)width) * f, (f3 + 0.0f) * f1);
            GLCore.addVertex(x, y, Slots.itemRender.field_77023_b, (f2 + 0.0f) * f, (f3 + 0.0f) * f1);
            GLCore.draw();
        }
    }

    public void refreshSlot(Slot slot) {
        if (slot != null) {
            this.buttonSlot = slot;
            this.caption = this.getCaption();
            this.icon = this.getIcon();
        }
        if (this.isEmpty()) {
            this.remove();
        }
    }

    protected boolean isEmpty() {
        return !this.buttonSlot.func_75216_d();
    }

    public Slot getSlot() {
        return this.buttonSlot;
    }

    public int getSlotNumber() {
        return this.buttonSlot.field_75222_d;
    }

    public ItemStack getStack() {
        return this.buttonSlot.func_75211_c();
    }

    @Override
    protected int getColor(int hoverState, boolean bg) {
        return super.getColor(hoverState, bg);
    }

    @Override
    public boolean keyTyped(Minecraft mc, char ch, int key) {
        return true;
    }

    @Override
    public boolean mouseOver(int cursorX, int cursorY, int flag) {
        this.focus = super.mouseOver(cursorX, cursorY, flag);
        return this.focus;
    }

    @Override
    public boolean mouseReleased(Minecraft mc, int cursorX, int cursorY, int button) {
        return super.mouseReleased(mc, cursorX, cursorY, button) || button == 1 || button == 2;
    }
}

