/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens.window;

import com.saomc.GLCore;
import com.saomc.colorstates.CursorStatus;
import com.saomc.resources.StringNames;
import com.saomc.screens.Elements;
import com.saomc.screens.ParentElement;
import com.saomc.screens.buttons.Actions;
import com.saomc.util.ColorUtil;
import com.saomc.util.OptionCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class ScreenGUI
extends GuiScreen
implements ParentElement {
    private static final float ROTATION_FACTOR = 0.25f;
    protected static CursorStatus CURSOR_STATUS = CursorStatus.SHOW;
    protected final List<Elements> elements = new ArrayList<Elements>();
    private final Cursor emptyCursor;
    private int mouseX;
    private int mouseY;
    private int mouseDown;
    private float mouseDownValue;
    private float[] rotationYaw;
    private float[] rotationPitch;
    private boolean cursorHidden = false;
    private boolean lockCursor = false;

    protected ScreenGUI() {
        Cursor cursor = null;
        try {
            cursor = new Cursor(1, 1, 0, 0, 1, BufferUtils.createIntBuffer((int)1), null);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        finally {
            this.emptyCursor = cursor;
        }
    }

    public void func_73866_w_() {
        if (CURSOR_STATUS != CursorStatus.DEFAULT) {
            this.hideCursor();
        }
        super.func_73866_w_();
        this.elements.clear();
        this.init();
    }

    protected void init() {
        if (this.field_146297_k.field_71439_g != null) {
            this.rotationYaw = new float[]{this.field_146297_k.field_71439_g.field_70177_z};
            this.rotationPitch = new float[]{this.field_146297_k.field_71439_g.field_70125_A};
        }
    }

    private int getCursorX() {
        if (OptionCore.CURSOR_TOGGLE.getValue()) {
            return this.lockCursor ? 0 : (this.field_146294_l / 2 - this.mouseX) / 2;
        }
        return !GuiScreen.func_146271_m() ? (this.field_146294_l / 2 - this.mouseX) / 2 : 0;
    }

    private int getCursorY() {
        if (OptionCore.CURSOR_TOGGLE.getValue()) {
            return this.lockCursor ? 0 : (this.field_146295_m / 2 - this.mouseY) / 2;
        }
        return !GuiScreen.func_146271_m() ? (this.field_146295_m / 2 - this.mouseY) / 2 : 0;
    }

    @Override
    public int getX(boolean relative) {
        return this.getCursorX();
    }

    @Override
    public int getY(boolean relative) {
        return this.getCursorY();
    }

    public void func_73876_c() {
        if (this.elements == null) {
            return;
        }
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (this.elements.get(i).removed()) {
                this.elements.get(i).close(this.field_146297_k);
                this.elements.remove(i);
                continue;
            }
            this.elements.get(i).update(this.field_146297_k);
        }
    }

    public void func_73863_a(int cursorX, int cursorY, float f) {
        if (this.elements == null) {
            return;
        }
        for (Elements el : this.elements) {
            if (el != null) continue;
            return;
        }
        this.mouseX = cursorX;
        this.mouseY = cursorY;
        if (this.field_146297_k.field_71439_g != null) {
            this.field_146297_k.field_71439_g.field_70177_z = this.rotationYaw[0] - (float)this.getCursorX() * 0.25f;
            this.field_146297_k.field_71439_g.field_70125_A = this.rotationPitch[0] - (float)this.getCursorY() * 0.25f;
        }
        super.func_73863_a(cursorX, cursorY, f);
        GLCore.glStartUI(this.field_146297_k);
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            this.elements.get(i).draw(this.field_146297_k, cursorX, cursorY);
        }
        if (CURSOR_STATUS == CursorStatus.SHOW) {
            GLCore.glBlend(true);
            GLCore.tryBlendFuncSeparate(770, 771, 1, 0);
            GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
            if (this.mouseDown != 0) {
                float fval = f * 0.1f;
                this.mouseDownValue = this.mouseDownValue + fval < 1.0f ? (this.mouseDownValue += fval) : 1.0f;
                GLCore.glColorRGBA(ColorUtil.CURSOR_COLOR.multiplyAlpha(this.mouseDownValue));
                GLCore.glTexturedRect(cursorX - 7, cursorY - 7, 35, 115, 15, 15);
                GLCore.glColorRGBA(ColorUtil.DEFAULT_COLOR);
            } else {
                this.mouseDownValue = 0.0f;
                GLCore.glColorRGBA(ColorUtil.CURSOR_COLOR);
            }
            GLCore.glTexturedRect(cursorX - 7, cursorY - 7, 20, 115, 15, 15);
        }
        GLCore.glEndUI(this.field_146297_k);
    }

    protected void func_73869_a(char ch, int key) {
        if (OptionCore.CURSOR_TOGGLE.getValue() && GuiScreen.func_146271_m()) {
            this.lockCursor = !this.lockCursor;
        }
        super.func_73869_a(ch, key);
        this.elements.stream().filter(element -> element.focus && element.keyTyped(this.field_146297_k, ch, key)).forEach(element -> this.actionPerformed((Elements)element, Actions.KEY_TYPED, key));
    }

    protected void func_73864_a(int cursorX, int cursorY, int button) {
        super.func_73864_a(cursorX, cursorY, button);
        this.mouseDown |= 1 << button;
        boolean clickedElement = false;
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size()) {
                if (this.elements.size() <= 0) break;
                i = this.elements.size() - 1;
            }
            if (!this.elements.get(i).mouseOver(cursorX, cursorY)) continue;
            if (this.elements.get(i).mousePressed(this.field_146297_k, cursorX, cursorY, button)) {
                this.actionPerformed(this.elements.get(i), Actions.getAction(button, true), button);
            }
            clickedElement = true;
        }
        if (!clickedElement) {
            this.backgroundClicked(cursorX, cursorY, button);
        }
    }

    protected void func_146286_b(int cursorX, int cursorY, int button) {
        super.func_146286_b(cursorX, cursorY, button);
        this.mouseDown &= ~(1 << button);
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size()) {
                if (this.elements.size() <= 0) break;
                i = this.elements.size() - 1;
            }
            if (!this.elements.get(i).mouseOver(cursorX, cursorY, button) || !this.elements.get(i).mouseReleased(this.field_146297_k, cursorX, cursorY, button)) continue;
            this.actionPerformed(this.elements.get(i), Actions.getAction(button, false), button);
        }
    }

    protected void backgroundClicked(int cursorX, int cursorY, int button) {
    }

    private void mouseWheel(int cursorX, int cursorY, int delta) {
        this.elements.stream().filter(element -> element.mouseOver(cursorX, cursorY) && element.mouseWheel(this.field_146297_k, cursorX, cursorY, delta)).forEach(element -> this.actionPerformed((Elements)element, Actions.MOUSE_WHEEL, delta));
    }

    @Override
    public void actionPerformed(Elements element, Actions action, int data) {
        element.click(this.field_146297_k.func_147118_V(), false);
    }

    public void func_146274_d() {
        super.func_146274_d();
        if (Mouse.hasWheel()) {
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            int delta = Mouse.getEventDWheel();
            if (delta != 0) {
                this.mouseWheel(x, y, delta);
            }
        }
    }

    public boolean func_73868_f() {
        return OptionCore.GUI_PAUSE.getValue();
    }

    public void func_146281_b() {
        this.showCursor();
        this.close();
    }

    protected void close() {
        this.elements.stream().forEach(el -> el.close(this.field_146297_k));
        this.elements.clear();
    }

    protected void hideCursor() {
        if (!this.cursorHidden) {
            this.toggleHideCursor();
        }
    }

    protected void showCursor() {
        if (this.cursorHidden) {
            this.toggleHideCursor();
        }
    }

    protected void toggleHideCursor() {
        this.cursorHidden = !this.cursorHidden;
        try {
            Mouse.setNativeCursor((Cursor)(this.cursorHidden ? this.emptyCursor : null));
        }
        catch (LWJGLException lWJGLException) {
            // empty catch block
        }
    }
}

