/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens.window;

import com.saomc.events.FriendsHandler;
import com.saomc.screens.Elements;
import com.saomc.screens.IconGUI;
import com.saomc.screens.LabelGUI;
import com.saomc.screens.MenuGUI;
import com.saomc.screens.ParentElement;
import com.saomc.screens.TextGUI;
import com.saomc.screens.VLine;
import com.saomc.screens.menu.Categories;
import com.saomc.screens.menu.Panel;
import com.saomc.screens.window.WindowAlign;
import com.saomc.screens.window.ui.AchievementList;
import com.saomc.screens.window.ui.CharacterView;
import com.saomc.screens.window.ui.MapView;
import com.saomc.social.StaticPlayerHelper;
import com.saomc.social.party.PartyHelper;
import com.saomc.util.ColorUtil;
import com.saomc.util.IconCore;
import com.saomc.util.JString;
import com.saomc.util.PlayerString;
import com.saomc.util.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.util.StatCollector;

@SideOnly(value=Side.CLIENT)
public final class SubWindow {
    private SubWindow() {
    }

    private static MenuGUI resetSub(Minecraft mc, MenuGUI sub) {
        sub.elements.clear();
        sub.elements.add(new LabelGUI(sub, 0, 0, sub.width, StaticPlayerHelper.getName(mc), WindowAlign.CENTER));
        sub.elements.add(new VLine(sub, 0, 0, 150));
        return sub;
    }

    private static MenuGUI createSub(Minecraft mc, Elements element, int x, int y) {
        return SubWindow.resetSub(mc, new Panel(element, x, y, 175, 240));
    }

    public static MenuGUI createSocialSub(Minecraft mc, Elements element, int x, int y) {
        MenuGUI sub = SubWindow.createSub(mc, element, x, y);
        String[] party = PartyHelper.instance().listMembers();
        return party != null ? SubWindow.setPartySub(mc, sub) : SubWindow.setFriendsSub(mc, sub);
    }

    public static MenuGUI createNavigationSub(Minecraft mc, Elements element, int x, int y) {
        return SubWindow.setQuestsSub(mc, SubWindow.createSub(mc, element, x, y), (EntityPlayer)mc.field_71439_g);
    }

    public static MenuGUI createMainProfileSub(Minecraft mc, Elements element, int x, int y) {
        return SubWindow.resetProfileSub(mc, new Panel(element, x, y, 175, 240), (EntityPlayer)mc.field_71439_g);
    }

    public static MenuGUI resetFriendsSub(Minecraft mc, MenuGUI sub) {
        return SubWindow.setFriendsSub(mc, SubWindow.resetSub(mc, sub));
    }

    public static MenuGUI resetPartySub(Minecraft mc, MenuGUI sub) {
        return SubWindow.setPartySub(mc, SubWindow.resetSub(mc, sub));
    }

    public static MenuGUI resetProfileSub(Minecraft mc, MenuGUI sub, EntityPlayer player) {
        sub.elements.clear();
        sub.elements.add(new LabelGUI(sub, 0, 0, sub.width, StaticPlayerHelper.getName(player), WindowAlign.CENTER));
        sub.elements.add(new VLine(sub, 0, 0, 150));
        return SubWindow.setProfileSub(mc, sub, player);
    }

    public static MenuGUI resetCheckPositionSub(Minecraft mc, MenuGUI sub, EntityPlayer player, int zoom, String title) {
        sub.elements.clear();
        sub.elements.add(new LabelGUI(sub, 0, 0, sub.width, StaticPlayerHelper.getName(player), WindowAlign.CENTER));
        sub.elements.add(new VLine(sub, 0, 0, 150));
        return SubWindow.setCheckPositionSub(mc, sub, player, zoom, title);
    }

    public static MenuGUI resetQuestsSub(Minecraft mc, MenuGUI sub, EntityPlayer player) {
        sub.elements.clear();
        sub.elements.add(new LabelGUI(sub, 0, 0, sub.width, StaticPlayerHelper.getName(player), WindowAlign.CENTER));
        sub.elements.add(new VLine(sub, 0, 0, 150));
        return SubWindow.setQuestsSub(mc, sub, player);
    }

    private static MenuGUI setEmptySub(Minecraft mc, MenuGUI sub) {
        sub.elements.add(new TextGUI((ParentElement)sub, 0, 0, new String[4]));
        IconGUI icon = new IconGUI((ParentElement)sub, Categories.NONE, sub.width / 2 - 10, 0, IconCore.NONE);
        icon.bgColor = ColorUtil.DEFAULT_FONT_COLOR;
        icon.disabledMask = ColorUtil.DEFAULT_COLOR;
        icon.enabled = false;
        sub.elements.add(icon);
        sub.elements.add(new TextGUI((ParentElement)sub, 0, 0, new String[4]));
        return sub;
    }

    private static MenuGUI setFriendsSub(Minecraft mc, MenuGUI sub) {
        String[] friends = FriendsHandler.instance().listFriends();
        boolean[] online = StaticPlayerHelper.isOnline(mc, friends);
        int onlineCount = 0;
        for (boolean value : online) {
            if (!value) continue;
            ++onlineCount;
        }
        if (onlineCount > 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < friends.length; ++i) {
                if (!online[i]) continue;
                builder.append(" - ").append(friends[i]).append('\n');
            }
            sub.elements.add(new LabelGUI((ParentElement)sub, 0, 0, '-' + StatCollector.func_74838_a((String)"guiFriends") + '-', WindowAlign.CENTER));
            sub.elements.add(new TextGUI((ParentElement)sub, 0, 0, builder.toString()));
        } else {
            SubWindow.setEmptySub(mc, sub);
        }
        return sub;
    }

    private static MenuGUI setPartySub(Minecraft mc, MenuGUI sub) {
        String[] party = PartyHelper.instance().listMembers();
        if (party != null) {
            boolean[] online = StaticPlayerHelper.isOnline(mc, party);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < party.length; ++i) {
                if (!online[i]) continue;
                builder.append(" - ").append(party[i]).append('\n');
            }
            sub.elements.add(new LabelGUI((ParentElement)sub, 0, 0, '-' + StatCollector.func_74838_a((String)"guiParty") + '-', WindowAlign.CENTER));
            sub.elements.add(new TextGUI((ParentElement)sub, 0, 0, builder.toString()));
        } else {
            SubWindow.setEmptySub(mc, sub);
        }
        return sub;
    }

    public static MenuGUI setProfileSub(Minecraft mc, MenuGUI sub, EntityPlayer player) {
        if (player != null) {
            sub.elements.add(new CharacterView(sub, 0, 0, sub.width, 150, player));
        } else {
            SubWindow.setEmptySub(mc, sub);
        }
        return sub;
    }

    private static MenuGUI setCheckPositionSub(Minecraft mc, MenuGUI sub, EntityPlayer player, int zoom, String title) {
        if (player != null) {
            MapView map = new MapView((ParentElement)sub, 0, 0, 4, player);
            map.zoom = zoom;
            if (title != null) {
                sub.elements.add(new LabelGUI(sub, 0, 0, sub.width, title, WindowAlign.CENTER));
            }
            sub.elements.add(map);
        } else {
            SubWindow.setEmptySub(mc, sub);
        }
        return sub;
    }

    private static MenuGUI setQuestsSub(Minecraft mc, MenuGUI sub, EntityPlayer player) {
        sub.elements.add(new LabelGUI(sub, 0, 0, sub.width, '-' + StatCollector.func_74838_a((String)"guiQuestList") + '-', WindowAlign.CENTER));
        MenuGUI questList = new MenuGUI(sub, 0, 0, sub.width, 150);
        questList.innerMenu = true;
        StatFileWriter stats = mc.field_71439_g.func_146107_m();
        if (stats != null) {
            List ach = net.minecraft.stats.AchievementList.field_76007_e;
            ach.stream().filter(obj0 -> obj0 instanceof Achievement).map(obj0 -> (Achievement)obj0).filter(ach0 -> ach0.func_75967_d() && !stats.func_77443_a(ach0) && stats.func_77442_b(ach0)).forEach(ach0 -> questList.elements.add(new AchievementList((ParentElement)questList, 0, 0, questList.width, (Achievement)ach0)));
        }
        sub.elements.add(questList);
        return sub;
    }

    public static Panel addInfo(MenuGUI sub) {
        Panel info = new Panel(sub, 0, 0, sub.width, 0);
        info.bgColor = ColorUtil.DEFAULT_BOX_COLOR;
        info.innerMenu = true;
        sub.elements.add(info);
        return info;
    }

    public static Strings[] addProfileContent(Minecraft mc) {
        return SubWindow.addProfileContent((EntityPlayer)mc.field_71439_g);
    }

    public static Strings[] addProfileContent(EntityPlayer player) {
        return new Strings[]{new JString(StatCollector.func_74838_a((String)"guiProfile")), new PlayerString(player)};
    }

    public static Strings[] addPositionContent(EntityPlayer player, EntityPlayer search) {
        StringBuilder floor = new StringBuilder(StatCollector.func_74838_a((String)"guiFloor") + ' ');
        StringBuilder builder = new StringBuilder();
        if (player != null) {
            floor.append(1 - player.field_71093_bK);
            builder.append("X: ").append((int)player.field_70165_t).append(", ");
            builder.append("Y: ").append((int)player.field_70163_u).append(", ");
            builder.append("Z: ").append((int)player.field_70161_v).append('\n');
            if (player != search) {
                builder.append(StatCollector.func_74838_a((String)"guiDistance")).append(' ');
                builder.append((double)((int)(Math.sqrt(player.func_70068_e((Entity)search)) * 1000.0)) / 1000.0);
                builder.append('\n');
            }
        } else {
            floor.append("0");
        }
        return new Strings[]{new JString(floor.toString()), new JString(builder.toString())};
    }
}

