/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens.window;

import com.saomc.GLCore;
import com.saomc.resources.StringNames;
import com.saomc.screens.Elements;
import com.saomc.screens.LabelGUI;
import com.saomc.screens.MenuGUI;
import com.saomc.screens.ParentElement;
import com.saomc.screens.window.WindowAlign;
import com.saomc.util.ColorUtil;
import com.saomc.util.OptionCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;

@SideOnly(value=Side.CLIENT)
public class Window
extends MenuGUI {
    private final LabelGUI titleLable;

    public Window(ParentElement gui, int xPos, int yPos, int w, int h, String title) {
        super(gui, xPos, yPos, w, h);
        this.titleLable = new LabelGUI((ParentElement)this, 0, 0, title, WindowAlign.CENTER);
        this.elements.add(this.titleLable);
        if (this.titleLable.width > this.width) {
            this.width = this.titleLable.width;
        }
    }

    public final String getTitle() {
        return this.titleLable.caption;
    }

    public final void setTitle(String title) {
        this.titleLable.caption = title;
    }

    @Override
    protected int getSize() {
        return Math.max(super.getSize(), 20) + 20;
    }

    @Override
    protected int getOffsetSize(Elements element) {
        return element.visibility > 0.0f ? super.getOffsetSize(element) : 0;
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        if (this.visibility > 0.0f) {
            GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
            GLCore.glColorRGBA(ColorUtil.DEFAULT_COLOR.multiplyAlpha(this.visibility));
            int left = this.getX(false);
            int top = this.getY(false);
            int topBox = this.getBoxSize(false);
            int bottomBox = this.getBoxSize(true);
            int width2 = this.width / 2;
            int size = this.height - (topBox + bottomBox);
            GLCore.glTexturedRect(left, top, width2, topBox, 0, 65, width2, 20);
            GLCore.glTexturedRect(left + width2, top, width2, topBox, 200 - width2, 65, width2, 20);
            if (size > 0) {
                int borderSize = Math.min(size / 2, 10);
                GLCore.glTexturedRect(left, top + topBox, 0, 85, width2, borderSize);
                GLCore.glTexturedRect(left + width2, top + topBox, 200 - width2, 85, width2, borderSize);
                if ((size + 1) / 2 > 10) {
                    GLCore.glTexturedRect(left, top + topBox + borderSize, this.width, size - borderSize * 2, 0, 95, 200, 10);
                }
                GLCore.glTexturedRect(left, top + topBox + size - borderSize, 0, 115 - borderSize, width2, borderSize);
                GLCore.glTexturedRect(left + width2, top + topBox + size - borderSize, 200 - width2, 115 - borderSize, width2, borderSize);
            }
            GLCore.glTexturedRect(left, top + size + topBox, width2, bottomBox, 0, 65, width2, 20);
            GLCore.glTexturedRect(left + width2, top + size + topBox, width2, bottomBox, 200 - width2, 65, width2, 20);
        }
        super.draw(mc, cursorX, cursorY);
    }

    @Override
    public int getY(boolean relative) {
        return super.getY(relative) + (relative ? 0 : this.height / 2);
    }

    protected int getBoxSize(boolean bottom) {
        return 20;
    }
}

