/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens.window;

import com.saomc.screens.buttons.ActionHandler;
import com.saomc.screens.buttons.ConfirmGUI;
import com.saomc.screens.window.MessageGUI;
import com.saomc.screens.window.ScreenGUI;
import com.saomc.screens.window.Window;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class WindowView
extends ScreenGUI {
    private final int windowWidth;
    private final int windowHeight;

    private WindowView(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
    }

    public static WindowView viewMessage(final String username, final String message) {
        return new WindowView(200, 40){

            @Override
            protected Window createWindow(int width, int height) {
                return new MessageGUI(this, 0, 0, width, height, message, username);
            }
        };
    }

    public static WindowView viewConfirm(final String title, final String message, final ActionHandler handler) {
        return new WindowView(200, 60){

            @Override
            protected Window createWindow(int width, int height) {
                return new ConfirmGUI(this, 0, 0, width, height, title, message, handler);
            }
        };
    }

    @Override
    protected void init() {
        super.init();
        this.elements.add(this.createWindow(this.windowWidth, this.windowHeight));
    }

    protected abstract Window createWindow(int var1, int var2);

    public final Window getWindow() {
        return (Window)this.elements.get(0);
    }

    @Override
    public int getX(boolean relative) {
        return super.getX(relative) + (this.field_146294_l - this.windowWidth) / 2;
    }

    @Override
    public int getY(boolean relative) {
        return super.getY(relative) + (this.field_146295_m - this.windowHeight) / 2;
    }

    @Override
    public void func_73863_a(int cursorX, int cursorY, float f) {
        this.func_146276_q_();
        super.func_73863_a(cursorX, cursorY, f);
    }

    @Override
    protected void backgroundClicked(int cursorX, int cursorY, int button) {
    }
}

