/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.screens.window.ui;

import com.saomc.GLCore;
import com.saomc.resources.StringNames;
import com.saomc.screens.Elements;
import com.saomc.screens.ParentElement;
import com.saomc.util.ColorUtil;
import com.saomc.util.OptionCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class MapView
extends Elements {
    public static final int MAP_SIZE = 16;
    public static final int MAP_DATA_SIZE = 33;
    private final EntityPlayer character;
    public int zoom;
    public int scan;
    private int[][] map;
    private long medium;
    private int min;
    private int max;

    public MapView(ParentElement gui, int xPos, int yPos, int size, EntityPlayer player) {
        super(gui, xPos, yPos, 33 * size, 33 * size + 16);
        this.character = player;
        this.map = null;
        this.scan = 16;
        this.zoom = 1;
    }

    public final void scanMap() {
        if (this.character != null && this.character.field_70170_p != null) {
            int j;
            int i;
            this.map = new int[33][33];
            this.medium = 0L;
            this.min = this.character.field_70170_p.func_72940_L();
            this.max = 0;
            int originY = (int)(this.character.field_70163_u - 1.0);
            int count = 0;
            for (i = -16; i <= 16; ++i) {
                for (j = -16; j <= 16; ++j) {
                    int x = (int)((Math.round(this.character.field_70165_t) / (long)this.zoom + (long)i) * (long)this.zoom);
                    int z = (int)((Math.round(this.character.field_70161_v) / (long)this.zoom + (long)j) * (long)this.zoom);
                    int endScan = 0;
                    int y = 0;
                    while (originY + y >= this.character.field_70170_p.func_72940_L() || this.character.field_70170_p.func_147437_c(x, originY + y, z) == this.character.field_70170_p.func_147437_c(x, originY + (y + 1), z)) {
                        endScan |= 1;
                        if (originY - y > 0 && this.character.field_70170_p.func_147437_c(x, originY - y, z) != this.character.field_70170_p.func_147437_c(x, originY - (y + 1), z)) {
                            y *= -1;
                            break;
                        }
                        endScan |= 2;
                        if (++y < this.scan) continue;
                    }
                    if (y == this.scan) {
                        this.map[16 + i][16 + j] = -endScan;
                        continue;
                    }
                    this.map[16 + i][16 + j] = originY + y;
                    this.medium += (long)this.map[16 + i][16 + j];
                    ++count;
                    if (this.map[16 + i][16 + j] < this.min) {
                        this.min = this.map[16 + i][16 + j];
                    }
                    if (this.map[16 + i][16 + j] <= this.max) continue;
                    this.max = this.map[16 + i][16 + j];
                }
            }
            for (i = -16; i <= 16; ++i) {
                for (j = -16; j <= 16; ++j) {
                    if (this.map[16 + i][16 + j] >= 0) continue;
                    this.map[16 + i][16 + j] = this.map[16 + i][16 + j] == -2 ? this.min : this.max;
                    this.medium += (long)this.map[16 + i][16 + j];
                    ++count;
                }
            }
            if (count > 0) {
                this.medium /= (long)count;
            }
        } else {
            this.map = null;
        }
    }

    @Override
    public void update(Minecraft mc) {
        int zoom_factor;
        super.update(mc);
        if (mc.field_71439_g != this.character && (zoom_factor = (int)(this.character.func_70068_e((Entity)mc.field_71439_g) / 1089.0)) > this.zoom) {
            this.zoom = zoom_factor;
        }
        if (this.map == null) {
            this.scanMap();
        }
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        if (this.visibility > 0.0f && this.map != null) {
            int left = this.getX(false) + this.width / 2;
            int top = this.getY(false) + this.height / 2;
            int size = (this.width / this.map.length + (this.height - 16) / this.map.length) / 2;
            if (size > 0) {
                GL11.glEnable((int)3042);
                GL11.glDisable((int)3553);
                GL11.glBlendFunc((int)770, (int)771);
                int direction = Math.round(mc.field_71439_g.field_70177_z / 90.0f) % 4;
                for (int i = -16; i <= 16; ++i) {
                    for (int j = -16; j <= 16; ++j) {
                        int z;
                        int x;
                        if (direction == 0) {
                            x = -i;
                            z = -j;
                        } else if (direction == 1) {
                            x = j;
                            z = -i;
                        } else if (direction == 2) {
                            x = i;
                            z = j;
                        } else {
                            x = -j;
                            z = i;
                        }
                        int y = (int)((long)this.map[16 + x][16 + z] - this.medium);
                        float valueY = y < 0 && this.medium != (long)this.min ? (float)y / (float)(this.medium - (long)this.min) : (y >= 0 && this.medium != (long)this.max ? (float)y / (float)((long)this.max - this.medium) : (float)y);
                        float blue = (1.0f + valueY) / 2.0f;
                        GLCore.glColor(0.0f, 0.0f, blue, this.visibility);
                        GLCore.glRect(left + i * size, top + j * size, size, size);
                    }
                }
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3042);
                GLCore.glBindTexture(OptionCore.SAO_UI.getValue() ? StringNames.gui : StringNames.guiCustom);
                if (mc.field_71439_g != this.character) {
                    int y;
                    int x;
                    GLCore.glColorRGBA(ColorUtil.CANCEL_COLOR.multiplyAlpha(this.visibility));
                    GLCore.glTexturedRect(left - size, top - size, size * 2, size * 2, 0, 25, 20, 20);
                    int offsetX = (int)((this.character.field_70161_v - mc.field_71439_g.field_70161_v) / (double)this.zoom);
                    int offsetY = (int)((this.character.field_70165_t - mc.field_71439_g.field_70165_t) / (double)this.zoom);
                    switch (direction) {
                        case 0: {
                            x = offsetY;
                            y = offsetX;
                            break;
                        }
                        case 1: {
                            x = offsetX;
                            y = -offsetY;
                            break;
                        }
                        case 2: {
                            x = -offsetY;
                            y = -offsetX;
                            break;
                        }
                        default: {
                            x = -offsetX;
                            y = offsetY;
                        }
                    }
                    if (Math.abs(x) < 16 && Math.abs(y) < 16) {
                        GLCore.glColorRGBA(ColorUtil.HOVER_COLOR.multiplyAlpha(this.visibility));
                        GLCore.glTexturedRect(left - size + x * size, top - size + y * size, size * 2, size * 2, 0, 25, 20, 20);
                    }
                } else {
                    GLCore.glColorRGBA(ColorUtil.HOVER_COLOR.multiplyAlpha(this.visibility));
                    GLCore.glTexturedRect(left - size, top - size, size * 2, size * 2, 0, 25, 20, 20);
                }
            }
        }
    }
}

