/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.social;

import com.google.common.collect.Lists;
import com.saomc.util.OptionCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;

public class StaticPlayerHelper {
    public static final float HEALTH_ANIMATION_FACTOR = 0.075f;
    public static final float HEALTH_FRAME_FACTOR = 36.0f;
    public static Map<UUID, Float> healthSmooth = new HashMap<UUID, Float>();
    public static Map<UUID, Float> hungerSmooth = new HashMap<UUID, Float>();
    public static final double MAX_RANGE = 512.0;

    public static List<EntityPlayer> listOnlinePlayers(Minecraft mc, boolean search, double range) {
        if (!search) {
            range = 512.0;
        }
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(mc.field_71439_g.field_70165_t - range), (double)(mc.field_71439_g.field_70163_u - range), (double)(mc.field_71439_g.field_70161_v - range), (double)(mc.field_71439_g.field_70165_t + range), (double)(mc.field_71439_g.field_70163_u + range), (double)(mc.field_71439_g.field_70161_v + range));
        return mc.field_71441_e.func_72872_a(EntityPlayer.class, box);
    }

    public static List<EntityPlayer> listOnlinePlayers(Minecraft mc) {
        ArrayList arraylist = Lists.newArrayList();
        mc.field_71441_e.field_72996_f.stream().filter(ent -> EntityPlayer.class.isAssignableFrom(ent.getClass())).forEach(ent -> arraylist.add((EntityPlayer)ent));
        return arraylist;
    }

    public static EntityPlayer findOnlinePlayer(Minecraft mc, String username) {
        return StaticPlayerHelper.listOnlinePlayers(mc).stream().filter(player -> StaticPlayerHelper.getName(player).equals(username)).findAny().orElse(null);
    }

    public static boolean[] isOnline(Minecraft mc, String[] names) {
        List<EntityPlayer> players = StaticPlayerHelper.listOnlinePlayers(mc);
        boolean[] online = new boolean[names.length];
        for (int i = 0; i < names.length; ++i) {
            int index = i;
            online[i] = players.stream().anyMatch(player -> StaticPlayerHelper.getName(player).equals(names[index]));
        }
        return online;
    }

    public static boolean isOnline(Minecraft mc, String name) {
        return StaticPlayerHelper.isOnline(mc, new String[]{name})[0];
    }

    public static String getName(EntityPlayer player) {
        return player == null ? "" : player.func_146103_bH().getName();
    }

    public static String getName(Minecraft mc) {
        return StaticPlayerHelper.getName((EntityPlayer)mc.field_71439_g);
    }

    public static String unformatName(String name) {
        int index = name.indexOf("\u00ef\u00bf\u00bd");
        while (index != -1) {
            name = index + 1 < name.length() ? name.replace(name.substring(index, index + 2), "") : name.replace("\u00ef\u00bf\u00bd", "");
            index = name.indexOf("\u00ef\u00bf\u00bd");
        }
        return name;
    }

    public static float getHealth(Minecraft mc, Entity entity, float time) {
        if (OptionCore.SMOOTH_HEALTH.getValue()) {
            float healthReal;
            UUID uuid = entity.func_110124_au();
            if (entity instanceof EntityLivingBase) {
                healthReal = ((EntityLivingBase)entity).func_110143_aJ();
            } else {
                float f = healthReal = entity.field_70128_L ? 0.0f : 1.0f;
            }
            if (healthSmooth.containsKey(uuid)) {
                float healthValue = healthSmooth.get(uuid).floatValue();
                if (healthReal <= 0.0f && entity instanceof EntityLivingBase) {
                    float value = (float)(18 - ((EntityLivingBase)entity).field_70725_aQ) / 18.0f;
                    if (value <= 0.0f) {
                        healthSmooth.remove(uuid);
                    }
                    return healthValue * value;
                }
                healthValue = Math.round(healthValue * 10.0f) != Math.round(healthReal * 10.0f) ? (healthValue += (healthReal - healthValue) * (StaticPlayerHelper.gameTimeDelay(mc, time) * 0.075f)) : healthReal;
                healthSmooth.put(uuid, Float.valueOf(healthValue));
                return healthValue;
            }
            healthSmooth.put(uuid, Float.valueOf(healthReal));
            return healthReal;
        }
        return entity instanceof EntityLivingBase ? ((EntityLivingBase)entity).func_110143_aJ() : (entity.field_70128_L ? 0.0f : 1.0f);
    }

    public static float getMaxHealth(Entity entity) {
        return entity instanceof EntityLivingBase ? ((EntityLivingBase)entity).func_110138_aP() : 1.0f;
    }

    public static float getHungerFract(Minecraft mc, Entity entity, float time) {
        if (!(entity instanceof EntityPlayer)) {
            return 1.0f;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (OptionCore.SMOOTH_HEALTH.getValue()) {
            UUID uuid = entity.func_110124_au();
            float hunger = player.func_71024_bL().func_75116_a();
            if (hungerSmooth.containsKey(uuid)) {
                float hungerValue = hungerSmooth.get(uuid).floatValue();
                if (hunger <= 0.0f) {
                    float value = (float)(18 - player.field_70725_aQ) / 18.0f;
                    if (value <= 0.0f) {
                        hungerSmooth.remove(uuid);
                    }
                    return hungerValue * value;
                }
                hungerValue = Math.round(hungerValue * 10.0f) != Math.round(hunger * 10.0f) ? (hungerValue += (hunger - hungerValue) * (StaticPlayerHelper.gameTimeDelay(mc, time) * 0.075f)) : hunger;
                hungerSmooth.put(uuid, Float.valueOf(hungerValue));
                return hungerValue / 20.0f;
            }
            hungerSmooth.put(uuid, Float.valueOf(hunger));
            return hunger / 20.0f;
        }
        return (float)player.func_71024_bL().func_75116_a() / 20.0f;
    }

    private static float gameTimeDelay(Minecraft mc, float time) {
        return time >= 0.0f ? time : 36.0f / (float)StaticPlayerHelper.gameFPS(mc);
    }

    public static boolean isCreative(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d;
    }

    private static int gameFPS(Minecraft mc) {
        return mc.func_90020_K();
    }
}

