/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.social.friends;

import com.saomc.events.FriendsHandler;
import com.saomc.screens.ParentElement;
import com.saomc.screens.buttons.ButtonGUI;
import com.saomc.screens.menu.Categories;
import com.saomc.social.StaticPlayerHelper;
import com.saomc.util.IconCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

@SideOnly(value=Side.CLIENT)
public class FriendCore
extends ButtonGUI {
    private EntityPlayer friend;

    public FriendCore(ParentElement gui, int xPos, int yPos, int w, int h, String name) {
        super(gui, Categories.FRIEND, xPos, yPos, w, h, name, IconCore.NONE);
        this.enabled = false;
    }

    public FriendCore(ParentElement gui, int xPos, int yPos, int w, String name) {
        this(gui, xPos, yPos, w, 20, name);
    }

    public FriendCore(ParentElement gui, int xPos, int yPos, String name) {
        this(gui, xPos, yPos, 100, name);
    }

    @Override
    public void update(Minecraft mc) {
        EntityPlayer player = this.getPlayer(mc);
        boolean bl = this.enabled = player != null;
        if (this.enabled && FriendsHandler.instance().isFriend(player)) {
            this.highlight = true;
            this.icon = IconCore.NONE;
        } else {
            this.highlight = false;
            this.icon = IconCore.INVITE;
        }
        super.update(mc);
    }

    public final EntityPlayer getPlayer(Minecraft mc) {
        if (this.friend == null || this.friend.field_70128_L || !this.friend.func_70089_S()) {
            this.friend = this.findPlayer(mc);
        }
        return this.friend;
    }

    public final EntityPlayer findPlayer(Minecraft mc) {
        List<EntityPlayer> players = StaticPlayerHelper.listOnlinePlayers(mc);
        for (EntityPlayer player : players) {
            if (!StaticPlayerHelper.getName(player).equals(this.caption)) continue;
            return player;
        }
        return null;
    }
}

