/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.social.party;

import com.saomc.SAOCore;
import com.saomc.commands.Command;
import com.saomc.commands.CommandType;
import com.saomc.events.ConfigHandler;
import com.saomc.screens.buttons.ConfirmGUI;
import com.saomc.screens.menu.Categories;
import com.saomc.screens.window.Window;
import com.saomc.screens.window.WindowView;
import com.saomc.social.StaticPlayerHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class PartyHelper {
    private static PartyHelper instance = new PartyHelper();
    private List<String> invited = new ArrayList<String>();
    private String[] party;

    private PartyHelper() {
    }

    public static PartyHelper instance() {
        return instance;
    }

    public void receiveInvite(Minecraft mc, String username, String ... args) {
        if (this.party == null || this.party.length <= 1) {
            GuiScreen keepScreen = mc.field_71462_r;
            boolean ingameFocus = mc.field_71415_G;
            String text = StatCollector.func_74837_a((String)ConfigHandler._PARTY_INVITATION_TEXT, (Object[])new Object[]{username});
            mc.func_147108_a((GuiScreen)WindowView.viewConfirm(ConfigHandler._PARTY_INVITATION_TITLE, text, (element, action, data) -> {
                Categories id = element.ID();
                if (id == Categories.CONFIRM) {
                    if (args.length > 0) {
                        this.party = new String[args.length + 1];
                        System.arraycopy(args, 0, this.party, 0, args.length);
                        this.party[this.party.length - 1] = StaticPlayerHelper.getName(mc);
                    } else {
                        this.party = null;
                    }
                    mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"ptJoin", (Object[])new Object[]{username})));
                    new Command(CommandType.CONFIRM_INVITE_PARTY, username, new String[0]).send(mc);
                } else {
                    new Command(CommandType.CANCEL_INVITE_PARTY, username, new String[0]).send(mc);
                }
                mc.func_147108_a(keepScreen);
                if (ingameFocus) {
                    mc.func_71381_h();
                } else {
                    mc.func_71364_i();
                }
            }));
            if (ingameFocus) {
                mc.func_71364_i();
            }
        }
    }

    public String[] listMembers() {
        return this.party;
    }

    public boolean isMember(String username) {
        return username.equals(StaticPlayerHelper.getName(Minecraft.func_71410_x())) || this.hasParty() && Stream.of(this.party).anyMatch(member -> member.equals(username));
    }

    public boolean isLeader(String username) {
        return this.hasParty() && this.party[0].equals(username);
    }

    private void addPlayer(Minecraft mc, String username) {
        this.create(mc);
        if (!this.isMember(username)) {
            String[] resized = new String[this.party.length + 1];
            System.arraycopy(this.party, 0, resized, 0, this.party.length);
            resized[this.party.length] = username;
            this.party = resized;
            if (this.isLeader(StaticPlayerHelper.getName(mc))) {
                Stream.of(this.party).filter(pl -> !pl.equals(StaticPlayerHelper.getName(mc))).forEach(member -> new Command(CommandType.UPDATE_PARTY, (String)member, '+' + username).send(mc));
                Stream.of(this.party).filter(pl -> !pl.equals(StaticPlayerHelper.getName(mc))).forEach(member -> new Command(CommandType.UPDATE_PARTY, username, '+' + member).send(mc));
            }
            mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"ptJoin", (Object[])new Object[]{username})));
        }
    }

    private void removePlayer(Minecraft mc, String username) {
        if (this.isMember(username)) {
            String[] resized = new String[this.party.length - 1];
            int index = 0;
            for (String member2 : this.party) {
                if (member2.equals(username)) continue;
                resized[index++] = member2;
            }
            if (resized.length > 1) {
                this.party = resized;
                if (this.isLeader(StaticPlayerHelper.getName(mc))) {
                    Stream.of(this.party).filter(pl -> !pl.equals(StaticPlayerHelper.getName(mc))).forEach(member -> new Command(CommandType.UPDATE_PARTY, (String)member, '-' + username).send(mc));
                }
            } else {
                this.party = null;
            }
            mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"ptLeft", (Object[])new Object[]{username})));
        }
    }

    public void receiveUpdate(Minecraft mc, String username, String[] args) {
        if (this.isLeader(username)) {
            for (String a : args) {
                if (a.charAt(0) == '+') {
                    this.addPlayer(mc, a.substring(1));
                    continue;
                }
                if (a.charAt(0) != '-') continue;
                this.removePlayer(mc, a.substring(1));
            }
        }
    }

    public void create(Minecraft mc) {
        if (this.hasParty()) {
            return;
        }
        this.party = new String[]{StaticPlayerHelper.getName(mc)};
    }

    public void invite(Minecraft mc, String username) {
        if (!this.isMember(username)) {
            this.invited.add(username);
            new Command(CommandType.INVITE_TO_PARTY, username, this.hasParty() ? this.party[0] : StaticPlayerHelper.getName(mc)).send(mc);
        }
    }

    public void sendDissolve(Minecraft mc) {
        if (this.hasParty()) {
            if (this.isLeader(StaticPlayerHelper.getName(mc))) {
                Stream.of(this.party).skip(1L).forEach(member -> new Command(CommandType.DISSOLVE_PARTY, (String)member, new String[0]).send(mc));
                mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"ptDissolve")));
            } else {
                new Command(CommandType.DISSOLVE_PARTY, this.party[0], new String[0]).send(mc);
                mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"ptLeave")));
            }
        }
        this.party = null;
    }

    public void receiveDissolve(Minecraft mc, String username) {
        if (this.isLeader(StaticPlayerHelper.getName(mc))) {
            this.removePlayer(mc, username);
        } else if (this.isLeader(username)) {
            Window window = SAOCore.getWindow(mc);
            if (window != null && window.getTitle().equals(ConfigHandler._PARTY_INVITATION_TITLE) && window instanceof ConfirmGUI) {
                ((ConfirmGUI)window).cancel();
            }
            this.party = null;
            mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"ptLeave")));
        }
    }

    public void receiveConfirmation(Minecraft mc, String username, String ... args) {
        this.create(mc);
        if (this.isLeader(StaticPlayerHelper.getName(mc)) && !this.isMember(username) && this.invited.contains(username)) {
            this.addPlayer(mc, username);
            this.invited.remove(username);
        } else {
            new Command(CommandType.DISSOLVE_PARTY, username, new String[0]).send(mc);
        }
    }

    public boolean hasParty() {
        return this.party != null;
    }

    public boolean shouldHighlight(Categories id) {
        return id.equals((Object)Categories.DISSOLVE) ? this.isEffective() : id.equals((Object)Categories.INVITE_LIST) && (!this.isEffective() || this.isLeader(StaticPlayerHelper.getName(Minecraft.func_71410_x())));
    }

    public boolean isEffective() {
        return this.hasParty() && this.party.length > 1;
    }
}

