/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.util;

import com.saomc.GLCore;
import com.saomc.events.ConfigHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.util.StatCollector;

@SideOnly(value=Side.CLIENT)
public enum OptionCore {
    VANILLA_OPTIONS(StatCollector.func_74838_a((String)"guiOptions"), false, false, null, false),
    UI(StatCollector.func_74838_a((String)"optCatUI"), false, true, null, false),
    THEME(StatCollector.func_74838_a((String)"optTheme"), false, true, null, false),
    HEALTH_OPTIONS(StatCollector.func_74838_a((String)"optCatHealth"), false, true, null, false),
    HOTBAR_OPTIONS(StatCollector.func_74838_a((String)"optCatHotBar"), false, true, null, false),
    EFFECTS(StatCollector.func_74838_a((String)"optCatEffects"), false, true, null, false),
    MISC(StatCollector.func_74838_a((String)"optCatMisc"), false, true, null, false),
    UI_ONLY(StatCollector.func_74838_a((String)"optionUIOnly"), false, false, UI, false),
    DEFAULT_INVENTORY(StatCollector.func_74838_a((String)"optionDefaultInv"), true, false, UI, false),
    DEFAULT_DEATH_SCREEN(StatCollector.func_74838_a((String)"optionDefaultDeath"), false, false, UI, false),
    DEFAULT_DEBUG(StatCollector.func_74838_a((String)"optionDefaultDebug"), false, false, UI, false),
    FORCE_HUD(StatCollector.func_74838_a((String)"optionForceHud"), false, false, UI, false),
    LOGOUT(StatCollector.func_74838_a((String)"optionLogout"), false, false, UI, false),
    GUI_PAUSE(StatCollector.func_74838_a((String)"optionGuiPause"), true, false, UI, false),
    VANILLA_UI(StatCollector.func_74838_a((String)"optionDefaultUI"), false, false, THEME, true),
    ALO_UI(StatCollector.func_74838_a((String)"optionALOUI"), false, false, THEME, true),
    SAO_UI(StatCollector.func_74838_a((String)"optionSAOUI"), true, false, THEME, true),
    SMOOTH_HEALTH(StatCollector.func_74838_a((String)"optionSmoothHealth"), true, false, HEALTH_OPTIONS, false),
    HEALTH_BARS(StatCollector.func_74838_a((String)"optionHealthBars"), true, false, HEALTH_OPTIONS, false),
    REMOVE_HPXP(StatCollector.func_74838_a((String)"optionLightHud"), false, false, HEALTH_OPTIONS, false),
    ALT_ABSORB_POS(StatCollector.func_74838_a((String)"optionAltAbsorbPos"), false, false, HEALTH_OPTIONS, false),
    DEFAULT_HOTBAR(StatCollector.func_74838_a((String)"optionDefaultHotbar"), false, false, HOTBAR_OPTIONS, true),
    HOR_HOTBAR(StatCollector.func_74838_a((String)"optionHorHotbar"), false, false, HOTBAR_OPTIONS, true),
    VER_HOTBAR(StatCollector.func_74838_a((String)"optionVerHotbar"), false, false, HOTBAR_OPTIONS, true),
    CURSOR_TOGGLE(StatCollector.func_74838_a((String)"optionCursorToggle"), true, false, EFFECTS, false),
    COLOR_CURSOR(StatCollector.func_74838_a((String)"optionColorCursor"), true, false, EFFECTS, false),
    SPINNING_CRYSTALS(StatCollector.func_74838_a((String)"optionSpinning"), true, false, EFFECTS, false),
    PARTICLES(StatCollector.func_74838_a((String)"optionParticles"), true, false, EFFECTS, false),
    LESS_VISUALS(StatCollector.func_74838_a((String)"optionLessVis"), false, false, EFFECTS, false),
    SOUND_EFFECTS(StatCollector.func_74838_a((String)"optionSounds"), true, false, EFFECTS, false),
    CROSS_HAIR(StatCollector.func_74838_a((String)"optionCrossHair"), false, false, MISC, false),
    AGGRO_SYSTEM(StatCollector.func_74838_a((String)"optionAggro"), true, false, MISC, false),
    CLIENT_CHAT_PACKETS(StatCollector.func_74838_a((String)"optionCliChatPacks"), true, false, MISC, false),
    MOUNT_STAT_VIEW(StatCollector.func_74838_a((String)"optionMountStatView"), true, false, MISC, false),
    CUSTOM_FONT(StatCollector.func_74838_a((String)"optionCustomFont"), false, false, MISC, false),
    DEBUG_MODE(StatCollector.func_74838_a((String)"optionDebugMode"), false, false, MISC, false),
    COMPACT_INVENTORY(StatCollector.func_74838_a((String)"optionCompatInv"), false, false, MISC, false),
    DISABLE_TICKS(StatCollector.func_74838_a((String)"optionDisableTicks"), false, false, MISC, false);

    public final String name;
    public final boolean isCategory;
    public final OptionCore category;
    private boolean value;
    private boolean restricted;

    private OptionCore(String optionName, boolean defaultValue, boolean isCat, OptionCore category, boolean onlyOne) {
        this.name = optionName;
        this.value = defaultValue;
        this.isCategory = isCat;
        this.category = category;
        this.restricted = onlyOne;
    }

    public static OptionCore fromString(String str) {
        return Stream.of(OptionCore.values()).filter(option -> option.toString().equals(str)).findAny().orElse(null);
    }

    public final String toString() {
        return this.name;
    }

    public boolean flip() {
        this.value = !this.getValue();
        ConfigHandler.setOption(this);
        if (this == CUSTOM_FONT) {
            GLCore.setFont(Minecraft.func_71410_x(), this.value);
        }
        return this.value;
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public OptionCore getCategory() {
        return this.category;
    }

    public void disable() {
        if (this.value) {
            this.flip();
        }
    }

    public void enable() {
        if (!this.value) {
            this.flip();
        }
    }
}

