/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.util;

import com.saomc.util.OptionCore;
import com.saomc.util.Strings;
import java.text.DecimalFormat;
import java.util.Collection;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;

public final class PlayerString
implements Strings {
    private final EntityPlayer player;

    public PlayerString(EntityPlayer entityPlayer) {
        this.player = entityPlayer;
    }

    private static float attr(double attributeValue) {
        return (float)((int)(attributeValue * 1000.0)) / 1000.0f;
    }

    @Override
    public final String toString() {
        StringBuilder builder = new StringBuilder();
        EntityLivingBase mount = (EntityLivingBase)this.player.field_70154_o;
        if (this.player.func_70115_ae() && OptionCore.MOUNT_STAT_VIEW.getValue()) {
            String name = ((EntityLiving)mount).func_94057_bL();
            double maxHealth = PlayerString.attr(mount.func_110138_aP());
            double health = PlayerString.attr(mount.func_110143_aJ());
            double resistance = PlayerString.attr(mount.func_70658_aO());
            double speed = PlayerString.attr(mount.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            DecimalFormat df3 = new DecimalFormat("0.000");
            DecimalFormat df1 = new DecimalFormat("0.0");
            String speedFormated = df3.format(speed);
            health *= 10.0;
            health += 0.5;
            String healthFormated = df1.format(health /= 10.0);
            builder.append(StatCollector.func_74838_a((String)"displayName")).append(": ").append(name).append('\n');
            builder.append(StatCollector.func_74838_a((String)"displayHpLong")).append(": ").append(healthFormated).append("/").append(maxHealth).append('\n');
            builder.append(StatCollector.func_74838_a((String)"displayResLong")).append(": ").append(resistance).append('\n');
            builder.append(StatCollector.func_74838_a((String)"displaySpdLong")).append(": ").append(speedFormated).append('\n');
            if (mount instanceof EntityHorse) {
                double jump = ((EntityHorse)mount).func_110215_cj();
                String jumpFormated = df3.format(jump);
                builder.append(StatCollector.func_74838_a((String)"displayJmpLong")).append(": ").append(jumpFormated).append('\n');
            }
        } else {
            int level = this.player.field_71068_ca;
            int experience = (int)(this.player.field_71106_cc * 100.0f);
            float health = PlayerString.attr(this.player.func_110143_aJ());
            float maxHealth = PlayerString.attr(this.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e());
            float attackDamage = PlayerString.attr(this.player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            float itemDamage = 0.0f;
            if (this.player.func_71045_bC() != null && this.player.func_71045_bC().func_111283_C().get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()) != null) {
                Collection itemAttackDamage = this.player.func_71045_bC().func_111283_C().get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
                itemDamage = (float)((double)itemDamage + itemAttackDamage.stream().filter(value -> value instanceof AttributeModifier).map(value -> (AttributeModifier)value).filter(mod -> mod.func_111166_b().equals("Weapon modifier")).mapToDouble(AttributeModifier::func_111164_d).sum());
            }
            float strength = PlayerString.attr(attackDamage + itemDamage);
            float agility = PlayerString.attr(this.player.func_70689_ay()) * 10.0f;
            float resistance = PlayerString.attr(this.player.func_70658_aO());
            builder.append(StatCollector.func_74838_a((String)"displayLvLong")).append(": ").append(level).append('\n');
            builder.append(StatCollector.func_74838_a((String)"displayXpLong")).append(": ").append(experience).append("%\n");
            builder.append(StatCollector.func_74838_a((String)"displayHpLong")).append(": ").append(health).append("/").append(maxHealth).append('\n');
            builder.append(StatCollector.func_74838_a((String)"displayStrLong")).append(": ").append(strength).append('\n');
            builder.append(StatCollector.func_74838_a((String)"displayDexLong")).append(": ").append(agility).append('\n');
            builder.append(StatCollector.func_74838_a((String)"displayResLong")).append(": ").append(resistance).append("\n");
        }
        return builder.toString();
    }
}

