/*
 * Decompiled with CFR 0.152.
 */
package com.saomc.util;

import com.google.common.collect.Lists;
import com.saomc.events.ConfigHandler;
import com.saomc.util.LogCore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

public class UpdateChecker
extends Thread {
    private static boolean hasChecked;
    private static boolean hasUpdate;
    private static final String curseURL = "http://minecraft.curseforge.com/projects/sao-ui/files";
    private static final String changelogURL = "https://raw.githubusercontent.com/Tencao/SAO-UI---1.7.10/master/Changelog.txt";
    private static List<String> changes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpURLConnection connection = null;
        BufferedReader reader = null;
        if (!hasChecked) {
            try {
                connection = (HttpURLConnection)new URL(changelogURL).openConnection();
                connection.connect();
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String line = reader.readLine();
                if (line == null) {
                    LogCore.logFatal("Update check failed!");
                    throw new IOException("No data from github changelog!");
                }
                changes = Lists.newArrayList();
                String latestVersion = line.substring(11);
                latestVersion = latestVersion.trim();
                if (ConfigHandler.getLastVersion().equals(latestVersion) && ConfigHandler.ignoreVersion()) {
                    hasChecked = true;
                    return;
                }
                if (!ConfigHandler.getLastVersion().equals(latestVersion)) {
                    ConfigHandler.saveVersion(latestVersion);
                    if (ConfigHandler.ignoreVersion()) {
                        ConfigHandler.setIgnoreVersion(false);
                    }
                }
                changes.add("A new update has been found\n \nChangelog:");
                while ((line = reader.readLine()) != null && !line.startsWith("###Version")) {
                    if (line.isEmpty()) continue;
                    line = line.substring(1).trim();
                    changes.add(line);
                }
                changes.add("\n \n To download, visit http://minecraft.curseforge.com/projects/sao-ui/files");
                if (!"1.7.10-1.6.0-Dev1".equals(latestVersion)) {
                    hasUpdate = true;
                }
            }
            catch (Exception e) {
                LogCore.logFatal("Caught exception in Update Checker thread!");
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        LogCore.logFatal("Caught exception in Update Checker");
                        e.printStackTrace();
                    }
                }
                if (connection != null) {
                    connection.disconnect();
                }
                hasChecked = true;
            }
        }
    }

    public static boolean hasChecked() {
        return hasChecked;
    }

    public static boolean hasUpdate() {
        return hasUpdate;
    }

    public static List<String> fetchChangeLog() {
        return changes;
    }
}

