/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.colour_mixer;

import java.awt.Color;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.colour_mixer.GuiDialogAddPalette;
import moe.plushie.armourers_workshop.client.gui.colour_mixer.GuiDialogConfirm;
import moe.plushie.armourers_workshop.client.gui.colour_mixer.GuiDialogRename;
import moe.plushie.armourers_workshop.client.gui.controls.AbstractGuiDialog;
import moe.plushie.armourers_workshop.client.gui.controls.GuiColourSelector;
import moe.plushie.armourers_workshop.client.gui.controls.GuiDropDownList;
import moe.plushie.armourers_workshop.client.gui.controls.GuiHSBSlider;
import moe.plushie.armourers_workshop.client.gui.controls.GuiHelp;
import moe.plushie.armourers_workshop.client.gui.controls.GuiIconButton;
import moe.plushie.armourers_workshop.client.gui.controls.IDialogCallback;
import moe.plushie.armourers_workshop.client.gui.controls.ModGuiContainer;
import moe.plushie.armourers_workshop.client.gui.controls.ModGuiControl;
import moe.plushie.armourers_workshop.client.palette.Palette;
import moe.plushie.armourers_workshop.common.data.type.Rectangle_I_2D;
import moe.plushie.armourers_workshop.common.inventory.ContainerColourMixer;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiColourUpdate;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.painting.PaintingHelper;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityColourMixer;
import moe.plushie.armourers_workshop.proxies.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiColourMixer
extends ModGuiContainer<ContainerColourMixer>
implements GuiHSBSlider.IHSBSliderCallback,
GuiDropDownList.IDropDownListCallback,
IDialogCallback,
ModGuiControl.IScreenSize {
    private TileEntityColourMixer tileEntityColourMixer;
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("armourers_workshop:textures/gui/colour_mixer/colour-mixer.png");
    private static final ResourceLocation CUBE_TEXTURE = new ResourceLocation("armourers_workshop".toLowerCase(), "textures/armour/cube.png");
    private static final ResourceLocation TEXTURE_BUTTONS = new ResourceLocation("armourers_workshop:textures/gui/_controls/buttons.png");
    private static String activePalette = ClientProxy.getPaletteManager().getFirstPaletteName();
    private Color colour;
    private GuiHSBSlider[] slidersHSB;
    private GuiTextField colourHex;
    private GuiColourSelector colourSelector;
    private GuiDropDownList colourFamilyList;
    private GuiDropDownList paintTypeDropDown;
    private GuiIconButton buttonPaletteAdd;
    private GuiIconButton buttonPaletteRemove;
    private GuiIconButton buttonPaletteRename;

    public GuiColourMixer(InventoryPlayer invPlayer, TileEntityColourMixer tileEntityColourMixer) {
        super(new ContainerColourMixer(invPlayer, tileEntityColourMixer));
        this.tileEntityColourMixer = tileEntityColourMixer;
        this.field_146999_f = 256;
        this.field_147000_g = 240;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.colour = new Color(this.tileEntityColourMixer.getColour(0));
        float[] hsbvals = Color.RGBtoHSB(this.colour.getRed(), this.colour.getGreen(), this.colour.getBlue(), null);
        this.slidersHSB = new GuiHSBSlider[3];
        this.slidersHSB[0] = new GuiHSBSlider(0, this.field_147003_i + 5, this.field_147009_r + 30, 150, 10, this, GuiHSBSlider.HSBSliderType.HUE, hsbvals[0], hsbvals[0], hsbvals[2]);
        this.slidersHSB[1] = new GuiHSBSlider(1, this.field_147003_i + 5, this.field_147009_r + 55, 150, 10, this, GuiHSBSlider.HSBSliderType.SATURATION, hsbvals[1], hsbvals[0], hsbvals[2]);
        this.slidersHSB[2] = new GuiHSBSlider(2, this.field_147003_i + 5, this.field_147009_r + 80, 150, 10, this, GuiHSBSlider.HSBSliderType.BRIGHTNESS, hsbvals[2], hsbvals[0], hsbvals[2]);
        this.field_146292_n.add(this.slidersHSB[0]);
        this.field_146292_n.add(this.slidersHSB[1]);
        this.field_146292_n.add(this.slidersHSB[2]);
        this.colourHex = new GuiTextField(-1, this.field_146289_q, this.field_147003_i + 5, this.field_147009_r + 105, 50, 10);
        this.colourHex.func_146203_f(7);
        this.updateHexTextbox();
        this.colourSelector = new GuiColourSelector(3, this.field_147003_i + 166, this.field_147009_r + 80, 82, 42, 10, 10, 8, 4, GUI_TEXTURE);
        this.field_146292_n.add(this.colourSelector);
        this.colourFamilyList = new GuiDropDownList(4, this.field_147003_i + 164, this.field_147009_r + 60, 86, "", this);
        this.colourFamilyList.setMaxDisplayCount(16);
        this.colourFamilyList.setScissor(true);
        this.updateDropDownPalettes();
        this.colourSelector.setPalette(ClientProxy.getPaletteManager().getPalette(activePalette));
        this.field_146292_n.add(this.colourFamilyList);
        this.paintTypeDropDown = new GuiDropDownList(5, this.field_147003_i + 164, this.field_147009_r + 30, 86, "", this);
        this.paintTypeDropDown.setMaxDisplayCount(10);
        this.updatePaintTypeDropDown();
        this.field_146292_n.add(this.paintTypeDropDown);
        this.buttonPaletteAdd = new GuiIconButton((GuiScreen)this, -1, this.field_147003_i + 230, this.field_147009_r + 124, 20, 20, GuiHelper.getLocalizedControlName(this.getName(), "button.add_palette", new Object[0]), TEXTURE_BUTTONS);
        this.buttonPaletteAdd.setDrawButtonBackground(false).setIconLocation(208, 176, 16, 16);
        this.field_146292_n.add(this.buttonPaletteAdd);
        this.buttonPaletteRemove = new GuiIconButton((GuiScreen)this, -1, this.field_147003_i + 230 - 18, this.field_147009_r + 124, 20, 20, GuiHelper.getLocalizedControlName(this.getName(), "button.remove_palette", new Object[0]), TEXTURE_BUTTONS);
        this.buttonPaletteRemove.setDrawButtonBackground(false).setIconLocation(208, 160, 16, 16);
        this.field_146292_n.add(this.buttonPaletteRemove);
        this.buttonPaletteRename = new GuiIconButton((GuiScreen)this, -1, this.field_147003_i + 230 - 36, this.field_147009_r + 124, 20, 20, GuiHelper.getLocalizedControlName(this.getName(), "button.rename_palette", new Object[0]), TEXTURE_BUTTONS);
        this.buttonPaletteRename.setDrawButtonBackground(false).setIconLocation(208, 192, 16, 16);
        this.field_146292_n.add(this.buttonPaletteRename);
        GuiHelp guiHelp = new GuiHelp(this, 0, this.field_147003_i + 240 - 54, this.field_147009_r + 129, GuiHelper.getLocalizedControlName(this.getName(), "help.palette", new Object[0]));
        this.field_146292_n.add(guiHelp);
    }

    private void updateDropDownPalettes() {
        Palette[] palettes = ClientProxy.getPaletteManager().getPalettes();
        this.colourFamilyList.clearList();
        for (int i = 0; i < palettes.length; ++i) {
            this.colourFamilyList.addListItem(palettes[i].getName());
            if (!palettes[i].getName().equals(activePalette)) continue;
            this.colourFamilyList.setListSelectedIndex(i);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        ClientProxy.getPaletteManager().save();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.colourFamilyList.drawForeground(this.field_146297_k, mouseX, mouseY, partialTicks);
        this.paintTypeDropDown.drawForeground(this.field_146297_k, mouseX, mouseY, partialTicks);
    }

    private void checkForColourUpdates() {
        if (this.tileEntityColourMixer.getHasItemUpdateAndReset()) {
            this.colour = new Color(this.tileEntityColourMixer.getColour(0));
            this.updateSliders();
            this.updatePaintTypeDropDown();
        }
    }

    private void updatePaintTypeDropDown() {
        int paintCount = 0;
        this.paintTypeDropDown.clearList();
        for (IPaintType paintType : PaintTypeRegistry.getInstance().getRegisteredTypes()) {
            if (paintType == PaintTypeRegistry.PAINT_TYPE_TEXTURE) {
                this.paintTypeDropDown.addListItem(paintType.getLocalizedName(), "", true);
            } else {
                this.paintTypeDropDown.addListItem(paintType.getLocalizedName());
            }
            if (paintType == this.tileEntityColourMixer.getPaintType(0)) {
                this.paintTypeDropDown.setListSelectedIndex(paintCount);
            }
            ++paintCount;
        }
    }

    private void updateSliders() {
        float[] hsbvals = Color.RGBtoHSB(this.colour.getRed(), this.colour.getGreen(), this.colour.getBlue(), null);
        this.slidersHSB[0].setValue(hsbvals[0]);
        this.slidersHSB[1].setValue(hsbvals[1]);
        this.slidersHSB[2].setValue(hsbvals[2]);
    }

    private void updateHexTextbox() {
        if (!this.colourHex.func_146206_l()) {
            this.colourHex.func_146180_a(String.format("#%02x%02x%02x", this.colour.getRed(), this.colour.getGreen(), this.colour.getBlue()));
        }
    }

    public void updatePaletteColour(Palette palette, int index) {
        palette.setColour(index, this.colour.getRGB());
        ClientProxy.getPaletteManager().markDirty();
    }

    protected void func_146284_a(GuiButton button) {
        Palette palette;
        if (button.field_146127_k == 3) {
            if (!GuiColourMixer.func_146272_n()) {
                this.colour = this.colourSelector.getSelectedColour();
                this.updateHexTextbox();
                this.updateSliders();
            } else if (!this.colourSelector.getPalette().isLocked()) {
                this.updatePaletteColour(this.colourSelector.getPalette(), this.colourSelector.getColourIndex());
            }
        }
        if (button == this.buttonPaletteAdd) {
            this.openDialog(new GuiDialogAddPalette((GuiScreen)this, this.getName() + ".dialog.add_palette", this));
        }
        if (button == this.buttonPaletteRemove && (palette = ClientProxy.getPaletteManager().getPalette(activePalette)) != null && !palette.isLocked()) {
            this.openDialog(new GuiDialogConfirm((GuiScreen)this, this.getName() + ".dialog.remove_palette", this, I18n.func_135052_a((String)("inventory.armourers_workshop:" + this.getName() + ".dialog.remove_palette.message"), (Object[])new Object[]{activePalette})));
        }
        if (button == this.buttonPaletteRename && (palette = ClientProxy.getPaletteManager().getPalette(activePalette)) != null && !palette.isLocked()) {
            this.openDialog(new GuiDialogRename((GuiScreen)this, this.getName() + ".dialog.rename_palette", this, activePalette));
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (this.colourFamilyList.getIsDroppedDown()) {
            this.colourFamilyList.func_146116_c(this.field_146297_k, mouseX, mouseY);
            return;
        }
        if (this.paintTypeDropDown.getIsDroppedDown()) {
            this.paintTypeDropDown.func_146116_c(this.field_146297_k, mouseX, mouseY);
            return;
        }
        super.func_73864_a(mouseX, mouseY, button);
        this.colourHex.func_146192_a(mouseX, mouseY, button);
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.colourFamilyList.getIsDroppedDown()) {
            this.colourFamilyList.func_146118_a(mouseX, mouseY);
            return;
        }
        if (this.paintTypeDropDown.getIsDroppedDown()) {
            this.paintTypeDropDown.func_146118_a(mouseX, mouseY);
            return;
        }
        super.func_146286_b(mouseX, mouseY, state);
        if (state != 0) {
            return;
        }
        this.updateColour();
    }

    private void updateColour() {
        Color colourOld = new Color(this.tileEntityColourMixer.getColour(0));
        IPaintType paintType = this.getDropDownPaintType();
        if (this.colour.equals(colourOld) && paintType == this.tileEntityColourMixer.getPaintType(0)) {
            return;
        }
        MessageClientGuiColourUpdate message = new MessageClientGuiColourUpdate(this.colour.getRGB(), false, paintType);
        PacketHandler.networkWrapper.sendToServer((IMessage)message);
    }

    private IPaintType getDropDownPaintType() {
        return PaintTypeRegistry.getInstance().getRegisteredTypes().get(this.paintTypeDropDown.getListSelectedIndex());
    }

    @Override
    protected void func_73869_a(char key, int keyCode) throws IOException {
        if (!this.colourHex.func_146201_a(key, keyCode)) {
            super.func_73869_a(key, keyCode);
        } else {
            Color newColour;
            String text = this.colourHex.func_146179_b();
            if (this.isValidHex(text) && !(newColour = Color.decode(text)).equals(this.colour)) {
                this.colour = newColour;
                this.updateSliders();
                this.updateColour();
            }
        }
    }

    private boolean isValidHex(String colorStr) {
        String hexPatten = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";
        Pattern pattern = Pattern.compile(hexPatten);
        Matcher matcher = pattern.matcher(colorStr);
        return matcher.matches();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GuiHelper.renderLocalizedGuiName(this.field_146289_q, this.field_146999_f, this.tileEntityColourMixer.func_70005_c_());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 48, this.field_147000_g - 96 + 2, 0x404040);
        String labelHue = GuiHelper.getLocalizedControlName(this.tileEntityColourMixer.func_70005_c_(), "label.hue", new Object[0]);
        String labelSaturation = GuiHelper.getLocalizedControlName(this.tileEntityColourMixer.func_70005_c_(), "label.saturation", new Object[0]);
        String labelBrightness = GuiHelper.getLocalizedControlName(this.tileEntityColourMixer.func_70005_c_(), "label.brightness", new Object[0]);
        String labelHex = GuiHelper.getLocalizedControlName(this.tileEntityColourMixer.func_70005_c_(), "label.hex", new Object[0]);
        String labelPresets = GuiHelper.getLocalizedControlName(this.tileEntityColourMixer.func_70005_c_(), "label.presets", new Object[0]);
        String labelPaintType = GuiHelper.getLocalizedControlName(this.tileEntityColourMixer.func_70005_c_(), "label.paintType", new Object[0]);
        this.field_146289_q.func_78276_b(labelHue + ":", 5, 21, 0x404040);
        this.field_146289_q.func_78276_b(labelSaturation + ":", 5, 46, 0x404040);
        this.field_146289_q.func_78276_b(labelBrightness + ":", 5, 71, 0x404040);
        this.field_146289_q.func_78276_b(labelHex + ":", 5, 94, 0x404040);
        this.field_146289_q.func_78276_b(labelPresets + ":", 165, 51, 0x404040);
        this.field_146289_q.func_78276_b(labelPaintType + ":", 165, 21, 0x404040);
        if (!this.colourFamilyList.getIsDroppedDown()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
            for (int i = 0; i < this.field_146292_n.size(); ++i) {
                GuiButton button = (GuiButton)this.field_146292_n.get(i);
                if (button instanceof GuiHelp) {
                    ((GuiHelp)button).drawRollover(this.field_146297_k, mouseX, mouseY);
                }
                if (!(button instanceof GuiIconButton)) continue;
                ((GuiIconButton)button).drawRollover(this.field_146297_k, mouseX, mouseY);
            }
            GlStateManager.func_179121_F();
        }
    }

    protected void func_146976_a(float partialTicks, int x, int y) {
        this.checkForColourUpdates();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.func_179123_a();
        GL11.glEnable((int)2884);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        double f = PaintingHelper.getPaintTextureOffset();
        double paintScale = 0.00390625;
        GlStateManager.func_179137_b((double)((double)this.getDropDownPaintType().getU() * paintScale), (double)(f / 256.0), (double)0.0);
        this.field_146297_k.field_71446_o.func_110577_a(CUBE_TEXTURE);
        float red = (float)this.colour.getRed() / 255.0f;
        float green = (float)this.colour.getGreen() / 255.0f;
        float blue = (float)this.colour.getBlue() / 255.0f;
        if (this.getDropDownPaintType() != PaintTypeRegistry.PAINT_TYPE_RAINBOW) {
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
        }
        GuiColourMixer.func_152125_a((int)(this.field_147003_i + 108), (int)(this.field_147009_r + 102), (float)0.0f, (float)0.0f, (int)1, (int)1, (int)13, (int)13, (float)256.0f, (float)256.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179117_G();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179099_b();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.colourHex.func_146194_f();
    }

    @Override
    public void valueUpdated(GuiHSBSlider source, double sliderValue) {
        float[] hsbvals = new float[]{(float)this.slidersHSB[0].getValue(), (float)this.slidersHSB[1].getValue(), (float)this.slidersHSB[2].getValue()};
        hsbvals[source.getType().ordinal()] = (float)sliderValue;
        this.colour = Color.getHSBColor(hsbvals[0], hsbvals[1], hsbvals[2]);
        this.updateHexTextbox();
        if (source.getType() == GuiHSBSlider.HSBSliderType.HUE) {
            this.slidersHSB[1].setHue((float)source.getValue());
        }
        if (source.getType() == GuiHSBSlider.HSBSliderType.BRIGHTNESS) {
            this.slidersHSB[1].setBrightness((float)source.getValue());
        }
    }

    @Override
    public void onDropDownListChanged(GuiDropDownList dropDownList) {
        if (dropDownList == this.colourFamilyList) {
            GuiDropDownList.DropDownListItem listItem = dropDownList.getListSelectedItem();
            this.colourSelector.setPalette(null);
            if (listItem != null) {
                Palette palette = ClientProxy.getPaletteManager().getPalette(listItem.displayText);
                if (palette != null) {
                    activePalette = palette.getName();
                    this.colourSelector.setPalette(palette);
                }
            } else {
                activePalette = null;
            }
        }
        if (dropDownList == this.paintTypeDropDown) {
            this.updateColour();
        }
    }

    @Override
    public String getName() {
        return this.tileEntityColourMixer.func_70005_c_();
    }

    @Override
    public void dialogResult(AbstractGuiDialog dialog, IDialogCallback.DialogResult result) {
        if (result == IDialogCallback.DialogResult.OK) {
            String newName;
            Palette palette;
            String newName2;
            if (dialog instanceof GuiDialogAddPalette && !StringUtils.func_151246_b((String)(newName2 = ((GuiDialogAddPalette)dialog).getNewName())) && ClientProxy.getPaletteManager().getPalette(newName2) == null) {
                ClientProxy.getPaletteManager().addPalette(newName2);
                ClientProxy.getPaletteManager().markDirty();
                activePalette = newName2;
                this.updateDropDownPalettes();
                this.onDropDownListChanged(this.colourFamilyList);
            }
            if (dialog instanceof GuiDialogConfirm && (palette = ClientProxy.getPaletteManager().getPalette(activePalette)) != null && !palette.isLocked()) {
                ClientProxy.getPaletteManager().deletePalette(activePalette);
                ClientProxy.getPaletteManager().markDirty();
                activePalette = ClientProxy.getPaletteManager().getFirstPaletteName();
                this.updateDropDownPalettes();
                this.onDropDownListChanged(this.colourFamilyList);
            }
            if (dialog instanceof GuiDialogRename && (palette = ClientProxy.getPaletteManager().getPalette(activePalette)) != null && !palette.isLocked() && !StringUtils.func_151246_b((String)(newName = ((GuiDialogRename)dialog).getNewName())) && ClientProxy.getPaletteManager().getPalette(newName) == null) {
                ClientProxy.getPaletteManager().renamePalette(activePalette, newName);
                ClientProxy.getPaletteManager().markDirty();
                activePalette = newName;
                this.updateDropDownPalettes();
                this.onDropDownListChanged(this.colourFamilyList);
            }
        }
        this.closeDialog();
    }

    @Override
    public Rectangle_I_2D getSize() {
        return new Rectangle_I_2D(0, 0, this.field_146294_l, this.field_146295_m);
    }
}

