/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.controls;

import java.io.IOException;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiIconButton;
import moe.plushie.armourers_workshop.client.gui.controls.GuiSlotHandler;
import moe.plushie.armourers_workshop.client.gui.controls.IDialogCallback;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractGuiDialog
extends Gui
implements IDialogCallback {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("armourers_workshop:textures/gui/common.png");
    protected final GuiScreen parent;
    protected final String name;
    protected final IDialogCallback callback;
    protected final Minecraft mc;
    protected final FontRenderer fontRenderer;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected ArrayList<GuiButton> buttonList;
    private GuiButton selectedButton;
    protected AbstractGuiDialog dialog;
    int oldMouseX;
    int oldMouseY;
    protected GuiSlotHandler slotHandler;

    public AbstractGuiDialog(GuiScreen parent, String name, IDialogCallback callback, int width, int height) {
        this.parent = parent;
        this.name = name;
        this.callback = callback;
        this.mc = Minecraft.func_71410_x();
        this.fontRenderer = this.mc.field_71466_p;
        this.width = width;
        this.height = height;
        this.buttonList = new ArrayList();
        if (parent instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)parent;
            this.slotHandler = new GuiSlotHandler(guiContainer);
        }
    }

    public void initGui() {
        this.x = (this.parent.field_146294_l - this.width) / 2;
        this.y = (this.parent.field_146295_m - this.height) / 2;
        if (this.isDialogOpen()) {
            this.dialog.initGui();
        }
        if (this.slotHandler != null) {
            this.slotHandler.initGui();
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isDialogOpen()) {
            this.dialog.mouseClicked(mouseX, mouseY, button);
        } else {
            if (mouseX < this.x | mouseX >= this.x + this.width | mouseY < this.y | mouseY >= this.y + this.height) {
                // empty if block
            }
            if (this.slotHandler != null) {
                try {
                    this.updateSlots(false);
                    this.slotHandler.mouseClicked(mouseX, mouseY, button);
                    this.updateSlots(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (button == 0) {
                for (int i = 0; i < this.buttonList.size(); ++i) {
                    GuiButton guiButton = this.buttonList.get(i);
                    if (!guiButton.func_146116_c(this.mc, mouseX, mouseY)) continue;
                    this.selectedButton = guiButton;
                    guiButton.func_146113_a(this.mc.func_147118_V());
                    this.actionPerformed(guiButton);
                }
            }
        }
    }

    protected void actionPerformed(GuiButton button) {
    }

    public void mouseMovedOrUp(int mouseX, int mouseY, int button) {
        if (this.isDialogOpen()) {
            this.dialog.mouseMovedOrUp(mouseX, mouseY, button);
        } else {
            if (this.slotHandler != null) {
                this.updateSlots(false);
                this.slotHandler.mouseReleased(mouseX, mouseY, button);
                this.updateSlots(true);
            }
            if (this.selectedButton != null && button == 0) {
                this.selectedButton.func_146118_a(mouseX, mouseY);
                this.selectedButton = null;
            }
        }
    }

    public void mouseClickMove(int mouseX, int mouseY, int lastButtonClicked, long timeSinceMouseClick) {
        if (this.isDialogOpen()) {
            this.dialog.mouseClickMove(mouseX, mouseY, lastButtonClicked, timeSinceMouseClick);
        } else if (this.slotHandler != null) {
            this.updateSlots(false);
            this.slotHandler.mouseClickMove(mouseX, mouseY, lastButtonClicked, timeSinceMouseClick);
            this.updateSlots(true);
        }
    }

    public void returnDialogResult(IDialogCallback.DialogResult result) {
        if (this.callback != null) {
            this.callback.dialogResult(this, result);
        }
    }

    public boolean keyTyped(char c, int keycode) {
        if (this.isDialogOpen()) {
            return this.dialog.keyTyped(c, keycode);
        }
        if (keycode == 1 || keycode == this.mc.field_71474_y.field_151445_Q.func_151463_i()) {
            this.returnDialogResult(IDialogCallback.DialogResult.CANCEL);
            return true;
        }
        return false;
    }

    protected void drawParentCoverBackground() {
        this.func_73733_a(0, 0, this.parent.field_146294_l, this.parent.field_146295_m, -1072689136, -804253680);
    }

    protected void drawbuttons(int mouseX, int mouseY, float partialTickTime) {
        int i;
        for (i = 0; i < this.buttonList.size(); ++i) {
            this.buttonList.get(i).func_191745_a(this.mc, mouseX, mouseY, partialTickTime);
        }
        for (i = 0; i < this.buttonList.size(); ++i) {
            if (!(this.buttonList.get(i) instanceof GuiIconButton)) continue;
            ((GuiIconButton)this.buttonList.get(i)).drawRollover(this.mc, mouseX, mouseY);
        }
    }

    public void drawFull(int mouseX, int mouseY, float partialTickTime) {
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.drawBackground(mouseX, mouseY, partialTickTime);
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.x, (float)this.y, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        this.drawForeground(mouseX, mouseY, partialTickTime);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        if (this.isDialogOpen()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            this.dialog.drawFull(this.oldMouseX, this.oldMouseY, 0.0f);
        }
    }

    protected void updateSlots(boolean restore) {
    }

    public void drawItems(int mouseX, int mouseY, float partialTickTime) {
        if (this.slotHandler != null) {
            GuiContainer guiContainer = (GuiContainer)this.parent;
            for (int i1 = 0; i1 < guiContainer.field_147002_h.field_75151_b.size(); ++i1) {
                Slot slot = (Slot)guiContainer.field_147002_h.field_75151_b.get(i1);
                if (slot.func_111238_b()) {
                    this.slotHandler.drawSlot(slot);
                }
                if (!this.slotHandler.isMouseOverSlot(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
                this.slotHandler.hoveredSlot = slot;
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                int j1 = slot.field_75223_e;
                int k1 = slot.field_75221_f;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.func_73733_a(j1, k1, j1 + 16, k1 + 16, -2130706433, -2130706433);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
        }
    }

    public void draw(int mouseX, int mouseY, float partialTickTime) {
        RenderHelper.func_74520_c();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)32826);
        GlStateManager.func_179123_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
        if (this.isDialogOpen()) {
            mouseY = 0;
            mouseX = 0;
        }
        this.drawBackground(mouseX, mouseY, partialTickTime);
        GlStateManager.func_179109_b((float)(-this.x), (float)(-this.y), (float)0.0f);
        this.drawForeground(mouseX, mouseY, partialTickTime);
        if (this.isDialogOpen()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
            ModLogger.log(mouseX);
            this.dialog.drawFull(this.oldMouseX, this.oldMouseY, 0.0f);
            GL11.glTranslatef((float)(-this.x), (float)(-this.y), (float)0.0f);
        }
        GL11.glPopAttrib();
        GlStateManager.func_179099_b();
    }

    public void drawBackground(int mouseX, int mouseY, float partialTickTime) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179097_i();
        GL11.glDisable((int)2929);
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        this.drawParentCoverBackground();
        int textureWidth = 128;
        int textureHeight = 128;
        int borderSize = 4;
        this.mc.field_71446_o.func_110577_a(TEXTURE);
        GuiUtils.drawContinuousTexturedBox((int)this.x, (int)this.y, (int)0, (int)0, (int)this.width, (int)this.height, (int)textureWidth, (int)textureHeight, (int)borderSize, (float)this.field_73735_i);
    }

    public void drawForeground(int mouseX, int mouseY, float partialTickTime) {
        this.drawbuttons(mouseX, mouseY, partialTickTime);
        if (this.slotHandler != null) {
            this.updateSlots(false);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)10.0f);
            this.slotHandler.drawScreen(mouseX, mouseY, partialTickTime);
            this.updateSlots(true);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179097_i();
    }

    protected void drawTitle() {
        this.drawTitle(this.name);
    }

    protected void drawTitle(String text) {
        String title = GuiHelper.getLocalizedControlName(text, "title", new Object[0]);
        int titleWidth = this.fontRenderer.func_78256_a(title);
        this.fontRenderer.func_78276_b(title, this.x + this.width / 2 - titleWidth / 2, this.y + 6, 0x404040);
    }

    public void openDialog(AbstractGuiDialog dialog) {
        this.dialog = dialog;
        dialog.initGui();
    }

    protected boolean isDialogOpen() {
        return this.dialog != null;
    }

    protected void closeDialog() {
        this.dialog = null;
    }

    public void update() {
    }

    @Override
    public void dialogResult(AbstractGuiDialog dialog, IDialogCallback.DialogResult result) {
        if (result == IDialogCallback.DialogResult.CANCEL) {
            this.closeDialog();
        }
    }
}

