/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.panels;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiControlSkinPanel;
import moe.plushie.armourers_workshop.client.gui.controls.GuiPanel;
import moe.plushie.armourers_workshop.client.gui.controls.GuiScrollbar;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelSearchBox;
import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskGetMostDownloaded;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskGetMostLiked;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskGetRecentlyUploaded;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGlobalLibraryPanelHome
extends GuiPanel {
    private final GuiScrollbar scrollbar;
    private final GuiControlSkinPanel skinPanelRecentlyUploaded;
    private final GuiControlSkinPanel skinPanelMostDownloaded;
    private final GuiControlSkinPanel skinPanelMostLiked;
    private GuiButtonExt buttonShowAll;

    public GuiGlobalLibraryPanelHome(GuiScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.scrollbar = new GuiScrollbar(-1, width - 11, y + 1, 10, height - 2, "", false);
        this.scrollbar.setStyleFlat(true);
        this.scrollbar.setAmount(14);
        this.skinPanelRecentlyUploaded = new GuiControlSkinPanel();
        this.skinPanelMostDownloaded = new GuiControlSkinPanel();
        this.skinPanelMostLiked = new GuiControlSkinPanel();
        this.insideCheck = true;
    }

    @Override
    public void initGui() {
        super.initGui();
        String guiName = ((GuiGlobalLibrary)this.parent).getGuiName();
        this.buttonList.clear();
        this.scrollbar.field_146129_i = this.y + 1;
        this.scrollbar.field_146128_h = this.x + this.width - 11;
        this.scrollbar.field_146121_g = this.height - 2;
        this.buttonShowAll = new GuiButtonExt(-1, this.x + 2, this.y + 2, 80, 16, GuiHelper.getLocalizedControlName(guiName, "home.showAllSkins", new Object[0]));
        this.skinPanelRecentlyUploaded.init(this.x + 2, this.y + 2 + 28, this.width - 20, 307);
        this.skinPanelMostDownloaded.init(this.x + 2, this.y + 2 + 28 + 206, this.width - 20, 307);
        this.skinPanelMostLiked.init(this.x + 2, this.y + 2 + 28 + 600, this.width - 20, 307);
        this.skinPanelRecentlyUploaded.setIconSize(50);
        this.skinPanelMostDownloaded.setIconSize(50);
        this.skinPanelMostLiked.setIconSize(50);
        int totalHeight = 995;
        this.scrollbar.setSliderMaxValue(totalHeight -= this.height);
        this.buttonList.add(this.scrollbar);
        this.buttonList.add(this.buttonShowAll);
        this.buttonList.add(this.skinPanelRecentlyUploaded);
        this.buttonList.add(this.skinPanelMostDownloaded);
        this.buttonList.add(this.skinPanelMostLiked);
    }

    public void updateSkinPanels() {
        int iconCountMostDownloaded = this.skinPanelMostDownloaded.getIconCount();
        int iconCountMostLiked = this.skinPanelMostLiked.getIconCount();
        ArrayList<ISkinType> skinTypes = SkinTypeRegistry.INSTANCE.getRegisteredSkinTypes();
        String searchTypes = "";
        for (int i = 0; i < skinTypes.size(); ++i) {
            searchTypes = searchTypes + skinTypes.get(i).getRegistryName();
            if (i >= skinTypes.size() - 1) continue;
            searchTypes = searchTypes + ";";
        }
        GlobalTaskGetRecentlyUploaded taskGetRecentlyUploaded = new GlobalTaskGetRecentlyUploaded(this.skinPanelRecentlyUploaded.getIconCount(), searchTypes);
        ListenableFutureTask<JsonArray> futureGetRecentlyUploaded = taskGetRecentlyUploaded.createTaskAndRun(new FutureCallback<JsonArray>(){

            public void onSuccess(final JsonArray result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        GuiGlobalLibraryPanelHome.this.skinPanelRecentlyUploaded.clearIcons();
                        for (int i = 0; i < result.size(); ++i) {
                            JsonObject skinJson = result.get(i).getAsJsonObject();
                            GuiGlobalLibraryPanelHome.this.skinPanelRecentlyUploaded.addIcon(skinJson);
                        }
                    }
                });
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
            }
        });
        GlobalTaskGetMostDownloaded taskGetMostDownloaded = new GlobalTaskGetMostDownloaded(this.skinPanelMostDownloaded.getIconCount(), searchTypes);
        ListenableFutureTask<JsonArray> futureGetMostDownloaded = taskGetMostDownloaded.createTaskAndRun(new FutureCallback<JsonArray>(){

            public void onSuccess(final JsonArray result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        GuiGlobalLibraryPanelHome.this.skinPanelMostDownloaded.clearIcons();
                        for (int i = 0; i < result.size(); ++i) {
                            JsonObject skinJson = result.get(i).getAsJsonObject();
                            GuiGlobalLibraryPanelHome.this.skinPanelMostDownloaded.addIcon(skinJson);
                        }
                    }
                });
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
            }
        });
        GlobalTaskGetMostLiked taskGetMostLiked = new GlobalTaskGetMostLiked(this.skinPanelMostLiked.getIconCount(), searchTypes);
        ListenableFutureTask<JsonArray> futureGetMostLiked = taskGetMostLiked.createTaskAndRun(new FutureCallback<JsonArray>(){

            public void onSuccess(final JsonArray result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        GuiGlobalLibraryPanelHome.this.skinPanelMostLiked.clearIcons();
                        for (int i = 0; i < result.size(); ++i) {
                            JsonObject skinJson = result.get(i).getAsJsonObject();
                            GuiGlobalLibraryPanelHome.this.skinPanelMostLiked.addIcon(skinJson);
                        }
                    }
                });
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
            }
        });
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        GuiControlSkinPanel.SkinIcon skinIcon;
        if (button == this.buttonShowAll) {
            ((GuiGlobalLibrary)this.parent).panelSearchResults.clearResults();
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.SEARCH);
            GuiGlobalLibraryPanelSearchBox cfr_ignored_0 = ((GuiGlobalLibrary)this.parent).panelSearchBox;
            GuiGlobalLibraryPanelSearchBox.selectedSkinType = null;
            ((GuiGlobalLibrary)this.parent).panelSearchBox.initGui();
            ((GuiGlobalLibrary)this.parent).panelSearchResults.doSearch("", null);
        }
        if (button == this.skinPanelRecentlyUploaded | button == this.skinPanelMostDownloaded | button == this.skinPanelMostLiked && (skinIcon = ((GuiControlSkinPanel)button).getLastPressedSkinIcon()) != null) {
            ((GuiGlobalLibrary)this.parent).panelSkinInfo.displaySkinInfo(skinIcon.getSkinJson(), GuiGlobalLibrary.Screen.HOME);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTickTime) {
        if (!this.visible) {
            return;
        }
        this.func_73733_a(this.x, this.y, this.x + this.width, this.y + this.height, -1072689136, -804253680);
        ModRenderHelper.enableScissor(this.x, this.y, this.width, this.height, true);
        int amount = this.scrollbar.getValue();
        this.buttonShowAll.field_146129_i = this.y + 2 - amount;
        this.skinPanelRecentlyUploaded.field_146129_i = this.y + 2 + 28 - amount;
        this.skinPanelMostDownloaded.field_146129_i = this.y + 2 + 28 + 307 + 14 - amount;
        this.skinPanelMostLiked.field_146129_i = this.y + 2 + 28 + 614 + 28 - amount;
        super.draw(mouseX, mouseY, partialTickTime);
        String guiName = ((GuiGlobalLibrary)this.parent).getGuiName();
        String labelRecentlyUploaded = GuiHelper.getLocalizedControlName(guiName, "home.recentlyUploaded", new Object[0]);
        String labelMostDownloaded = GuiHelper.getLocalizedControlName(guiName, "home.mostDownloaded", new Object[0]);
        String labelMostLikes = GuiHelper.getLocalizedControlName(guiName, "home.mostLikes", new Object[0]);
        int boxW = (this.width - 15) / 2;
        int boxH = this.height - 10 - 35;
        this.fontRenderer.func_78276_b(labelRecentlyUploaded, this.skinPanelRecentlyUploaded.field_146128_h + 2, this.skinPanelRecentlyUploaded.field_146129_i - 9, -1118482);
        this.fontRenderer.func_78276_b(labelMostDownloaded, this.skinPanelMostDownloaded.field_146128_h + 2, this.skinPanelMostDownloaded.field_146129_i - 9, -1118482);
        this.fontRenderer.func_78276_b(labelMostLikes, this.skinPanelMostLiked.field_146128_h + 2, this.skinPanelMostLiked.field_146129_i - 9, -1118482);
        ModRenderHelper.disableScissor();
    }
}

