/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.panels;

import com.google.common.util.concurrent.FutureCallback;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiControlSkinPanel;
import moe.plushie.armourers_workshop.client.gui.controls.GuiIconButton;
import moe.plushie.armourers_workshop.client.gui.controls.GuiPanel;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskSkinSearch;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGlobalLibraryPanelSearchResults
extends GuiPanel {
    private static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("armourers_workshop:textures/gui/global_library/global-library.png");
    protected final GuiControlSkinPanel skinPanelResults = new GuiControlSkinPanel();
    protected GuiIconButton iconButtonSmall;
    protected GuiIconButton iconButtonMedium;
    protected GuiIconButton iconButtonLarge;
    protected static int iconScale = 60;
    protected String search = null;
    protected ISkinType skinType = null;
    protected JsonArray[] pageList = null;
    protected HashSet<Integer> downloadedPageList = new HashSet();
    protected JsonArray jsonCurrentPage;
    protected int currentPageIndex = 0;
    protected int totalPages = -1;
    protected int totalResults = 0;

    public GuiGlobalLibraryPanelSearchResults(GuiScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
    }

    public void doSearch(String search, ISkinType skinType) {
        this.clearResults();
        this.search = search;
        this.skinType = skinType;
        if (this.search == null) {
            return;
        }
        this.fetchPage(0);
    }

    public void clearResults() {
        this.search = null;
        this.skinType = null;
        this.pageList = null;
        this.jsonCurrentPage = null;
        this.currentPageIndex = 0;
        this.totalPages = -1;
        this.totalResults = 0;
        this.skinPanelResults.clearIcons();
        this.downloadedPageList.clear();
    }

    protected void resize() {
        this.refresh();
    }

    public void refresh() {
        String thisSearch = this.search;
        ISkinType thisSkinType = this.skinType;
        int thisPage = this.currentPageIndex;
        this.clearResults();
        this.doSearch(thisSearch, thisSkinType);
    }

    protected void fetchPage(int pageIndex) {
        if (this.downloadedPageList.contains(pageIndex)) {
            return;
        }
        this.downloadedPageList.add(pageIndex);
        ArrayList<ISkinType> skinTypes = SkinTypeRegistry.INSTANCE.getRegisteredSkinTypes();
        String searchTypes = "";
        if (this.skinType == null) {
            for (int i = 0; i < skinTypes.size(); ++i) {
                searchTypes = searchTypes + skinTypes.get(i).getRegistryName();
                if (i >= skinTypes.size() - 1) continue;
                searchTypes = searchTypes + ";";
            }
        } else {
            searchTypes = this.skinType.getRegistryName();
        }
        GlobalTaskSkinSearch taskSkinSearch = new GlobalTaskSkinSearch(this.search, searchTypes, pageIndex, this.skinPanelResults.getIconCount());
        taskSkinSearch.createTaskAndRun(new FutureCallback<JsonObject>(){

            public void onSuccess(final JsonObject result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        GuiGlobalLibraryPanelSearchResults.this.onPageJsonDownload(result);
                    }
                });
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
            }
        });
    }

    protected void onPageJsonDownload(JsonObject pageJson) {
        if (pageJson.has("totalPages")) {
            this.totalPages = pageJson.get("totalPages").getAsInt();
        }
        if (pageJson.has("totalResults")) {
            this.totalResults = pageJson.get("totalResults").getAsInt();
        }
        int pageIndex = 0;
        if (pageJson.has("currentPageIndex") && (pageIndex = pageJson.get("currentPageIndex").getAsInt()) == 0 & this.totalPages > 1) {
            this.fetchPage(1);
        }
        if (pageJson.has("results")) {
            JsonArray pageResults = pageJson.get("results").getAsJsonArray();
            if (this.pageList == null) {
                this.pageList = new JsonArray[this.totalPages];
            }
            if (this.totalPages != 0) {
                this.pageList[pageIndex] = pageResults;
                this.updateSkinForPage();
            }
        }
    }

    @Override
    public GuiPanel setSize(int width, int height) {
        boolean resized = width != this.width | height != this.height;
        super.setSize(width, height);
        this.initGui();
        if (resized) {
            this.resize();
        }
        return this;
    }

    @Override
    public void initGui() {
        super.initGui();
        String guiName = ((GuiGlobalLibrary)this.parent).getGuiName();
        this.buttonList.clear();
        this.skinPanelResults.init(this.x + 2, this.y + 20, this.width - 4, this.height - 40);
        this.skinPanelResults.setIconSize(iconScale);
        this.skinPanelResults.setPanelPadding(0);
        this.skinPanelResults.setShowName(true);
        this.iconButtonSmall = new GuiIconButton(this.parent, 0, this.x + this.width - 63, this.y + 2, 16, 16, GuiHelper.getLocalizedControlName(guiName, "searchResults.small", new Object[0]), BUTTON_TEXTURES);
        this.iconButtonSmall.setIconLocation(48, 0, 16, 16);
        this.iconButtonMedium = new GuiIconButton(this.parent, 0, this.x + this.width - 42, this.y + 2, 16, 16, GuiHelper.getLocalizedControlName(guiName, "searchResults.medium", new Object[0]), BUTTON_TEXTURES);
        this.iconButtonMedium.setIconLocation(48, 17, 16, 16);
        this.iconButtonLarge = new GuiIconButton(this.parent, 0, this.x + this.width - 21, this.y + 2, 16, 16, GuiHelper.getLocalizedControlName(guiName, "searchResults.large", new Object[0]), BUTTON_TEXTURES);
        this.iconButtonLarge.setIconLocation(48, 34, 16, 16);
        this.buttonList.add(this.iconButtonSmall);
        this.buttonList.add(this.iconButtonMedium);
        this.buttonList.add(this.iconButtonLarge);
        this.buttonList.add(this.skinPanelResults);
        this.buttonList.add(new GuiButtonExt(1, this.x + 2, this.y + this.height - 18, 20, 16, "<<"));
        this.buttonList.add(new GuiButtonExt(2, this.x + this.width - 22, this.y + this.height - 18, 20, 16, ">>"));
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        GuiControlSkinPanel.SkinIcon skinIcon;
        if (button.field_146127_k == 1) {
            this.changePage(this.currentPageIndex - 1);
        }
        if (button.field_146127_k == 2) {
            this.changePage(this.currentPageIndex + 1);
            if (this.currentPageIndex + 1 < this.totalPages) {
                this.fetchPage(this.currentPageIndex + 1);
            }
        }
        if (button == this.iconButtonSmall) {
            iconScale = 30;
            this.skinPanelResults.setIconSize(iconScale);
            this.resize();
        }
        if (button == this.iconButtonMedium) {
            iconScale = 60;
            this.skinPanelResults.setIconSize(iconScale);
            this.resize();
        }
        if (button == this.iconButtonLarge) {
            iconScale = 90;
            this.skinPanelResults.setIconSize(iconScale);
            this.resize();
        }
        if (button == this.skinPanelResults && (skinIcon = ((GuiControlSkinPanel)button).getLastPressedSkinIcon()) != null) {
            ((GuiGlobalLibrary)this.parent).panelSkinInfo.displaySkinInfo(skinIcon.getSkinJson(), GuiGlobalLibrary.Screen.SEARCH);
        }
    }

    protected void changePage(int pageIndex) {
        if (pageIndex < this.totalPages & pageIndex >= 0) {
            this.currentPageIndex = pageIndex;
        }
        if (this.currentPageIndex > this.totalPages) {
            this.currentPageIndex = this.totalPages - 1;
        }
        if (this.currentPageIndex < 0) {
            this.currentPageIndex = 0;
        }
        this.updateSkinForPage();
    }

    protected void updateSkinForPage() {
        this.jsonCurrentPage = this.getJsonForPage(this.currentPageIndex);
        if (this.jsonCurrentPage != null) {
            int skinsPerPage = this.skinPanelResults.getIconCount();
            int pageOffset = skinsPerPage * this.currentPageIndex;
            this.skinPanelResults.clearIcons();
            JsonArray downloadArray = new JsonArray();
            for (int i = 0; i < skinsPerPage; ++i) {
                if (i >= this.jsonCurrentPage.size()) continue;
                JsonObject skinJson = this.jsonCurrentPage.get(i).getAsJsonObject();
                downloadArray.add((JsonElement)skinJson);
                this.skinPanelResults.addIcon(skinJson);
            }
        }
    }

    private JsonArray getJsonForPage(int pageIndex) {
        if (this.pageList != null && pageIndex >= 0 & pageIndex < this.pageList.length) {
            return this.pageList[pageIndex];
        }
        return null;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTickTime) {
        if (((Object)((Object)this)).getClass().equals(GuiGlobalLibraryPanelSearchResults.class)) {
            if (!this.visible) {
                return;
            }
            this.func_73733_a(this.x, this.y, this.x + this.width, this.y + this.height, -1072689136, -804253680);
            super.draw(mouseX, mouseY, partialTickTime);
            int maxPages = this.totalPages;
            int totalSkins = this.totalResults;
            String guiName = ((GuiGlobalLibrary)this.parent).getGuiName();
            String unlocalizedName = "inventory." + "armourers_workshop".toLowerCase() + ":" + guiName + ".searchResults.results";
            String resultsText = TranslateUtils.translate(unlocalizedName, this.currentPageIndex + 1, maxPages, totalSkins);
            if (this.jsonCurrentPage == null & this.totalPages == -1) {
                resultsText = GuiHelper.getLocalizedControlName(guiName, "searchResults.label.searching", new Object[0]);
            }
            if (this.totalPages == 0) {
                resultsText = GuiHelper.getLocalizedControlName(guiName, "searchResults.label.no_results", new Object[0]);
            }
            this.fontRenderer.func_78276_b(resultsText, this.x + 5, this.y + 6, -1118482);
        } else {
            super.draw(mouseX, mouseY, partialTickTime);
        }
    }
}

