/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.inventory.slot;

import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.init.items.ItemSkin;
import moe.plushie.armourers_workshop.common.inventory.slot.SlotHidable;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlotSkin
extends SlotHidable {
    private ISkinType skinType;

    public SlotSkin(ISkinType skinType, IInventory inventory, int slotIndex, int xDisplayPosition, int yDisplayPosition) {
        super(inventory, slotIndex, xDisplayPosition, yDisplayPosition);
        this.skinType = skinType;
    }

    public boolean func_75214_a(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemSkin && SkinNBTHelper.stackHasSkinData(stack)) {
            SkinDescriptor skinData = SkinNBTHelper.getSkinDescriptorFromStack(stack);
            if (this.skinType != null && this.skinType == skinData.getIdentifier().getSkinType()) {
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBackgroundLocation() {
        return this.skinType.getSlotIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBackgroundSprite() {
        return new DummySprite("");
    }

    @SideOnly(value=Side.CLIENT)
    private class DummySprite
    extends TextureAtlasSprite {
        protected DummySprite(String spriteName) {
            super(spriteName);
        }

        public float func_94212_f() {
            return 1.0f;
        }

        public float func_94210_h() {
            return 1.0f;
        }

        public float func_94209_e() {
            return 0.0f;
        }

        public float func_94206_g() {
            return 0.0f;
        }
    }
}

